 CBL XOPTS(SP)
       IDENTIFICATION DIVISION.
       PROGRAM-ID.                  HOBCICOL.
       AUTHOR.                      RICH SMRCINA.
       INSTALLATION.                VM ASSIST, INC.
       DATE-WRITTEN.                February, 2007.
      *****************************************************************
      * Xymon Client V1.2 for VSE/ESA and z/VSE
      *  Copyright (C) 2003-2010 Richard Smrcina
      *  This program is free software; you can redistribute it
      *  and/or modify it under the terms of the GNU General Public
      *  License as published by the Free Software Foundation; either
      *  version 2 of the License, or (at your option) any later
      *  version.
      *
      *  This program is distributed in the hope that it will be
      *  useful, but WITHOUT ANY WARRANTY; without even the implied
      *  warranty of MERCHANTABILITY or FITNESS FOR A
      *  PARTICULAR PURPOSE.
      *  See the GNU General Public License for more details.
      *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
      *
      *    This is the driver program for the CICS portion of the
      *    Xymon client for VSE.  It is initiated every 5 minutes
      *    (via a PLT program that issues an interval START).
      *    The data collected from CICS is written to a VSAM file
      *    called HOBBIT, which is then read in by the Xymon client
      *    REXX program (HOBVSECI).
      *
      *****************************************************************
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       01  MISCELLANEOUS.
           05  COMMAND-RESPONSE        PIC S9(8) COMP  VALUE +0.
           05  COMMAND-RESPONSE2       PIC S9(8) COMP  VALUE +0.
           05  DSALIM                  PIC S9(8) COMP  VALUE +0.
           05  EDSALIM                 PIC S9(8) COMP  VALUE +0.
           05  CDSASIZE                PIC S9(8) COMP  VALUE +0.
           05  RDSASIZE                PIC S9(8) COMP  VALUE +0.
           05  SDSASIZE                PIC S9(8) COMP  VALUE +0.
           05  UDSASIZE                PIC S9(8) COMP  VALUE +0.
           05  ECDSASIZE               PIC S9(8) COMP  VALUE +0.
           05  ERDSASIZE               PIC S9(8) COMP  VALUE +0.
           05  ESDSASIZE               PIC S9(8) COMP  VALUE +0.
           05  EUDSASIZE               PIC S9(8) COMP  VALUE +0.
           05  HOBOUT-LENGTH           PIC S9(4) COMP  VALUE +180.
           05  HOBOUT-KEYLENGTH        PIC S9(4) COMP  VALUE +8.
           05  CICS-APPLID             PIC X(8)        VALUE SPACES.
           05  RESPONSE-CODE           PIC S9(8) COMP  VALUE +0.
           05  UPDATE-TOKEN            PIC S9(8) COMP  VALUE +0.
           05  NOTFOUND-FLAG           PIC X           VALUE '0'.
               88 APPLID-FOUND                         VALUE '0'.
               88 APPLID-NOTFOUND                      VALUE '1'.
       01  CURRENT-TIMESTAMP.
           05  CURRENT-YEAR         PIC XXXX.
           05  CURRENT-MONTH        PIC XX.
           05  CURRENT-DAY          PIC XX.
           05  CURRENT-HOUR         PIC XX.
           05  CURRENT-MINUTE       PIC XX.
           05  CURRENT-SECOND       PIC XX.
           05  FILLER               PIC X(7).
       01  OUT-TIMESTAMP.
           05  OUT-YEAR             PIC XXXX.
           05  OUT-MONTH            PIC XX.
           05  OUT-DAY              PIC XX.
           05  FILLER               PIC X       VALUE SPACE.
           05  OUT-HOUR             PIC XX.
           05  FILLER               PIC X       VALUE ':'.
           05  OUT-MINUTE           PIC XX.
           05  FILLER               PIC X       VALUE ':'.
           05  OUT-SECOND           PIC XX.
       01  HOBOUT-DATA.
           10  OUT-APPLID           PIC X(8).
           10  FILLER               PIC X.
           10  OUT-TIMEST           PIC X(17).
           10  FILLER               PIC X.
           10  OUT-OTASK-NUMBER     PIC 9(7).
           10  FILLER               PIC X.
           10  OUT-NTASK-NUMBER     PIC 9(7).
           10  FILLER               PIC X.
           10  OUT-DSALIM           PIC 9(11).
           10  FILLER               PIC X.
           10  OUT-EDSALIM          PIC 9(11).
           10  FILLER               PIC X.
           10  OUT-CDSASIZE         PIC 9(11).
           10  FILLER               PIC X.
           10  OUT-RDSASIZE         PIC 9(11).
           10  FILLER               PIC X.
           10  OUT-SDSASIZE         PIC 9(11).
           10  FILLER               PIC X.
           10  OUT-UDSASIZE         PIC 9(11).
           10  FILLER               PIC X.
           10  OUT-ECDSASIZE        PIC 9(11).
           10  FILLER               PIC X.
           10  OUT-ERDSASIZE        PIC 9(11).
           10  FILLER               PIC X.
           10  OUT-ESDSASIZE        PIC 9(11).
           10  FILLER               PIC X.
           10  OUT-EUDSASIZE        PIC 9(11).
           10  FILLER               PIC X(28).
       PROCEDURE DIVISION.
       0000-MAINLINE.
           MOVE FUNCTION CURRENT-DATE TO CURRENT-TIMESTAMP.
           MOVE SPACES TO HOBOUT-DATA.
           MOVE CURRENT-YEAR TO OUT-YEAR.
           MOVE CURRENT-MONTH TO OUT-MONTH.
           MOVE CURRENT-DAY TO OUT-DAY.
           MOVE CURRENT-HOUR TO OUT-HOUR.
           MOVE CURRENT-MINUTE TO OUT-MINUTE.
           MOVE CURRENT-SECOND TO OUT-SECOND.
           EXEC CICS ASSIGN APPLID(CICS-APPLID)
               END-EXEC.
           EXEC CICS READ FILE('HOBBIT')
               RIDFLD(CICS-APPLID)
               INTO(HOBOUT-DATA)
               LENGTH(HOBOUT-LENGTH)
               RESP(RESPONSE-CODE)
               EQUAL UPDATE TOKEN(UPDATE-TOKEN)
               END-EXEC.
           IF RESPONSE-CODE = DFHRESP(NOTFND)
               MOVE '1' TO NOTFOUND-FLAG.
           EXEC CICS INQUIRE SYSTEM
               DSALIMIT(DSALIM)
               EDSALIMIT(EDSALIM)
               CDSASIZE(CDSASIZE)
               RDSASIZE(RDSASIZE)
               SDSASIZE(SDSASIZE)
               UDSASIZE(UDSASIZE)
               ECDSASIZE(ECDSASIZE)
               ERDSASIZE(ERDSASIZE)
               ESDSASIZE(ESDSASIZE)
               EUDSASIZE(EUDSASIZE)
               END-EXEC.
           MOVE CICS-APPLID TO OUT-APPLID
           MOVE OUT-TIMESTAMP TO OUT-TIMEST.
           MOVE DSALIM TO OUT-DSALIM.
           MOVE EDSALIM TO OUT-EDSALIM.
           MOVE CDSASIZE TO OUT-CDSASIZE.
           MOVE RDSASIZE TO OUT-RDSASIZE.
           MOVE SDSASIZE TO OUT-SDSASIZE.
           MOVE UDSASIZE TO OUT-UDSASIZE.
           MOVE ECDSASIZE TO OUT-ECDSASIZE.
           MOVE ERDSASIZE TO OUT-ERDSASIZE.
           MOVE ESDSASIZE TO OUT-ESDSASIZE.
           MOVE EUDSASIZE TO OUT-EUDSASIZE.
           IF APPLID-FOUND
               MOVE OUT-NTASK-NUMBER TO OUT-OTASK-NUMBER
               MOVE EIBTASKN TO OUT-NTASK-NUMBER
               EXEC CICS REWRITE FILE('HOBBIT')
                   FROM(HOBOUT-DATA)
                   TOKEN(UPDATE-TOKEN)
                   LENGTH(HOBOUT-LENGTH)
                   END-EXEC
           ELSE
               MOVE EIBTASKN TO OUT-OTASK-NUMBER, OUT-NTASK-NUMBER
               EXEC CICS WRITE FILE('HOBBIT')
                   RIDFLD(OUT-APPLID)
                   FROM(HOBOUT-DATA)
                   LENGTH(HOBOUT-LENGTH)
                   END-EXEC.
       0000-DONE.
           EXEC CICS START TRANSID('HOBC')
               INTERVAL(000500)
               RESP(COMMAND-RESPONSE)
               END-EXEC.
           EXEC CICS RETURN
                END-EXEC.
       0000-EXIT.
           EXIT.
           GOBACK.
