/*
 * wibocmd.h
 *
 *  Created on: 12.01.2010
 *      Author: dthiele
 */

#ifndef WIBOCMD_H_
#define WIBOCMD_H_

#include <stdint.h>

typedef enum {
	WIBOSTATUS_IDLE = 0x00,
	WIBOSTATUS_RECEIVINGDATA = 0x01,
	WIBOSTATUS_ERROR = 0xFF
} bootlstatus_t;

typedef enum {
	WIBOERROR_NONE = 0x00,
	WIBOERROR_DATAMISS,
	WIBOERROR_SUCCESS
} bootlerrorcode_t;

typedef enum {
	WIBOCMDCODE_NONE = 0x00, 	/**< no command */
	WIBOCMDCODE_PING, 			/**< Ping a node which replies and delivers information about itself */
	WIBOCMDCODE_PINGREPLY, 		/**< Reply to a ping request */
	WIBOCMDCODE_DATA, 			/**< Feed a node with data */
	WIBOCMDCODE_FINISH, 		/**< Force a write of all received data */
	WIBOCMDCODE_RESET, 			/**< Reset data stream */
	WIBOCMDCODE_EXIT, 			/**< Exit bootloader and jump to application vector */

	/* for example and debugging purposes, define command codes for application to jump into bootloader
	 * and do some actions on LEDs
	 */
	WIBOCMDCODE_XMPLJBOOTL,
	WIBOCMDCODE_XMPLLED
} wibocmdcode_t;

/* this struct is common for all commands and serves as a layer for simple node addressing */
typedef struct {
	uint16_t FCF; 			/**< frame control field */
	uint8_t seqnumber;		/**< sequence number */
	uint16_t destpanid;		/**< destination pan id */
	uint16_t destaddr;		/**< destination short address */
	uint16_t srcpanid;		/**< source pan id */
	uint16_t srcaddr; 		/**< source short address */
	wibocmdcode_t command; 	/**< the wibo command */
} wibocmd_hdr_t;

typedef struct {
	wibocmd_hdr_t hdr;
} wibocmd_ping_t;

typedef struct {
	wibocmd_hdr_t hdr;
	bootlstatus_t status; 		/**< status code of memory loading process */
	bootlerrorcode_t errcode; 	/**< error code of node */
	uint8_t swversion; 			/**< bootloader software version */
	uint16_t crc; 				/**< checksum of received data stream */
	uint16_t pagesize;			/**< page size */
	const char boardname[];
} wibocmd_pingreply_t;

typedef struct {
	wibocmd_hdr_t hdr;
	uint8_t targmem; 		/**< target memory: EEPROM or FLASH or LOCKBITS */
	uint8_t dsize; 			/**< size of data packet */
	uint8_t data[]; 		/**< data container */
} wibocmd_data_t;

typedef struct {
	wibocmd_hdr_t hdr;
} wibocmd_finish_t;

typedef struct {
	wibocmd_hdr_t hdr;
} wibocmd_reset_t;

typedef struct {
	wibocmd_hdr_t hdr;
} wibocmd_exit_t;

typedef struct {
	wibocmd_hdr_t hdr;
} wibocmd_xmpljbootl_t;

typedef struct {
	wibocmd_hdr_t hdr;
	uint8_t led;
	uint8_t state;
} wibocmd_xmplled_t;

#endif /* WIBOCMD_H_ */
