#include <stdlib.h>
#include <stdio.h>

#define N 20

int nb_num;
int tab[N];
int stack_ptr;
int stack_res[N*4];
int result;

int find(int n, int r, int a, int b, int op)
{
    int i, j;

    if (stack_ptr >= 0) {
        i = stack_ptr * 4;
        stack_res[i + 0] = a;
        stack_res[i + 1] = op;
        stack_res[i + 2] = b;
        stack_res[i + 3] = n;
        if (stack_ptr == nb_num - 2) {
            if (n != result)
                return 0;
            return 1;
        }
        tab[r] = n;
    }

    stack_ptr++;
    for(i = r; i < nb_num; ) {
        a = tab[i];
        if (a != -1) {
            for(j = 0; j < nb_num; j++) {
                if (j == i)
                    continue;
                b = tab[j];
                if (b == -1)
                    continue;
                tab[j] = -1;
                if (find(a + b, i, a, b, '+'))
                    return 1;
                if (a > b && find(a - b, i, a, b, '-'))
                    return 1;
                if (find(a * b, i, a, b, '*'))
                    return 1;
                if (b > 0 && a % b == 0 && find(a / b, i, a, b, '/'))
                    return 1;
                tab[j] = b;
            }
            tab[i] = a;
        }
        if (i == r && r)
            i = 0;
        else if (++i == r)
            ++i;
    }
    stack_ptr--;
    return 0;
}

int main(int argc, char **argv)
{
    int i, p, res;

    if (argc < 4) {
usage:
        printf("usage: %s: result numbers...\n"
               "Try to find result from numbers with the 4 basic operations.\n", argv[0]);
        exit(1);
    }

    nb_num = 0;
    for(i = 1; i < argc; i++) {
        p = atoi(argv[i]);
        if (p <= 0)
            goto usage;
        else if (i == 1)
            result = p;
        else if (nb_num == N)
            goto usage;
        else
            tab[nb_num++] = p;
    }

    stack_ptr = -1;
    res = find(0, 0, 0, 0, ' ');
    if (res) {
        for(i = 0; i <= stack_ptr; i++) {
            p = i * 4;
            printf("%6d %c %d = %d\n",
                   stack_res[p + 0],
                   stack_res[p + 1],
                   stack_res[p + 2],
                   stack_res[p + 3]);
        }
        return 0;
    } else {
        printf("Impossible\n");
        return 1;
    }
}
