/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Database;
import java.io.File;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.Serviceable;

public class DatabaseBacked
extends AbstractSdxObject
implements Serviceable {
    public static final String DEFAULT_DATABASE_TYPE = "fr.gouv.culture.sdx.utils.database.HSQLDatabase";
    public static final String CLASS_NAME_SUFFIX = "DatabaseBacked";
    public String DATABASE_DIR_NAME = "sdx-database";
    protected Database _database = null;
    protected String dbPath = null;
    protected File dbLocation = null;
    protected Configuration databaseConf = null;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configure(configuration, true);
    }

    public void configure(Configuration configuration, boolean useMetadata) throws ConfigurationException {
        super.configure(configuration);
        try {
            super.setId(configuration.getAttribute("id", super.getId()));
            if (useMetadata) {
                Configuration defaultDatabaseConf = (Configuration)Utilities.getObjectFromContext("sdx.application.defaultDatabaseConfObj", (Context)this.getContext());
                if (defaultDatabaseConf == null) {
                    defaultDatabaseConf = new DefaultConfiguration("", "");
                }
                this.databaseConf = configuration.getChild(Utilities.getElementName("Database"), false);
                if (this.databaseConf == null && defaultDatabaseConf != null) {
                    this.databaseConf = defaultDatabaseConf;
                }
                String dbType = this.databaseConf.getAttribute("type", DEFAULT_DATABASE_TYPE);
                Object l_obj = Utilities.getObjectForClassName(this.getLog(), dbType, "fr.gouv.culture.sdx.utils.database.", dbType, "Database");
                Class<?> l_objClass = l_obj.getClass();
                if (!(l_obj instanceof Database)) {
                    String[] args = new String[3];
                    args[0] = "Database";
                    if (l_objClass != null) {
                        args[1] = l_objClass.getName();
                    }
                    args[2] = dbType;
                    throw new SDXException(super.getLog(), 10, args, null);
                }
                Database l_sdxObj = (Database)l_obj;
                this._database = (Database)super.setUpSdxObject(l_sdxObj);
                String dbDirName = this._database.getDatabaseDirectoryName();
                if (Utilities.checkString(dbDirName)) {
                    this.DATABASE_DIR_NAME = dbDirName;
                }
                this._database.setId(super.getId());
                this._database.configure(this.databaseConf);
            }
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public void init() throws SDXException {
        if (this._database != null) {
            this._database.setId(this._database.getId());
            this._database.init();
        }
    }

    public Database getDatabase() {
        return this._database;
    }

    protected String getClassNameSuffix() {
        return CLASS_NAME_SUFFIX;
    }

    protected boolean initToSax() {
        this._xmlizable_objects.put("ID", this.getId());
        this._xmlizable_objects.put("Encoding", this.getEncoding());
        this._xmlizable_objects.put("XML-Lang", this.getXmlLang());
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }
}

