/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.filter;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.filter.AbstractFilter;
import fr.gouv.culture.sdx.search.lucene.query.TermInfo;
import fr.gouv.culture.sdx.search.lucene.query.Terms;
import fr.gouv.culture.sdx.utils.Bits;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Filter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Criteria
extends AbstractFilter {
    private BitSet bits;
    private Field field;
    private String pattern;
    public Filter luceneFilter;

    public void setUp(Field field, String pattern) throws SDXException {
        if (field == null) {
            throw new SDXException(this.logger, 4004, null, null);
        }
        if (!Utilities.checkString(pattern)) {
            throw new SDXException(this.logger, 4701, null, null);
        }
        this.field = field;
        this.pattern = pattern;
    }

    public void setUp(Filter luceneFilter) throws SDXException {
        if (luceneFilter == null) {
            throw new SDXException(this.logger, 4700, null, null);
        }
        this.luceneFilter = luceneFilter;
    }

    public BitSet bits(IndexReader r) {
        try {
            if (this.luceneFilter != null) {
                this.bits = this.luceneFilter.bits(r);
                return this.bits;
            }
            this.bits = new BitSet(r.numDocs());
            TreeMap terms = null;
            try {
                terms = Terms.getTerms(r, this.field, this.pattern);
            }
            catch (SDXException e) {
                LoggingUtils.logException(this.logger, (Exception)((Object)e));
                return this.bits;
            }
            Iterator it = terms.keySet().iterator();
            while (it.hasNext()) {
                TermInfo termInfo = (TermInfo)terms.get((String)it.next());
                TermDocs docs = r.termDocs(termInfo.getTerm());
                while (docs.next()) {
                    this.bits.set(docs.doc());
                }
            }
            return this.bits;
        }
        catch (IOException e) {
            return this.bits;
        }
    }

    public void toSAX(ContentHandler hdl) throws SAXException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "filter";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "type", "type", "CDATA", "criteria");
        if (this.field != null) {
            atts.addAttribute("", "field", "field", "CDATA", this.field.getCode());
        }
        if (this.pattern != null) {
            atts.addAttribute("", "value", "value", "CDATA", this.pattern);
        }
        if (this.bits != null) {
            atts.addAttribute("", "nb", "nb", "CDATA", String.valueOf(Bits.countBits(this.bits)));
        }
        hdl.startElement(sdxNsUri, localName, qName, atts);
        hdl.endElement(sdxNsUri, localName, qName);
    }
}

