/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.validationruleimpl;

import java.math.BigDecimal;
import org.apache.cocoon.forms.datatype.validationruleimpl.AbstractValidationRule;
import org.apache.cocoon.forms.formmodel.CannotYetResolveWarning;
import org.apache.cocoon.forms.util.I18nMessage;
import org.apache.cocoon.forms.validation.ValidationError;
import org.outerj.expression.Expression;
import org.outerj.expression.ExpressionContext;

public class RangeValidationRule
extends AbstractValidationRule {
    private Expression minExpr;
    private Expression maxExpr;
    private static final String RANGE_ELEM = "range";
    private static final String MIN_ATTR = "min";
    private static final String MAX_ATTR = "max";
    static /* synthetic */ Class class$java$lang$Comparable;

    public void setMinExpr(Expression minExpr) {
        this.minExpr = minExpr;
    }

    public void setMaxExpr(Expression maxExpr) {
        this.maxExpr = maxExpr;
    }

    public ValidationError validate(Object value, ExpressionContext expressionContext) {
        Comparable<BigDecimal> decimal = value instanceof Integer ? new BigDecimal((double)((Integer)value).intValue()) : (value instanceof Long ? new BigDecimal((double)((Long)value).longValue()) : (value instanceof Float ? new BigDecimal(((Float)value).floatValue()) : (value instanceof Double ? new BigDecimal((Double)value) : (Comparable)value)));
        Comparable min = null;
        if (this.minExpr != null) {
            Object result = this.evaluateComparable(this.minExpr, expressionContext, MIN_ATTR, RANGE_ELEM);
            if (result instanceof ValidationError) {
                return (ValidationError)result;
            }
            if (result instanceof CannotYetResolveWarning) {
                return null;
            }
            min = (Comparable)result;
        }
        Comparable max = null;
        if (this.maxExpr != null) {
            Object result = this.evaluateComparable(this.maxExpr, expressionContext, MAX_ATTR, RANGE_ELEM);
            if (result instanceof ValidationError) {
                return (ValidationError)result;
            }
            if (result instanceof CannotYetResolveWarning) {
                return null;
            }
            max = (Comparable)result;
        }
        if (min != null && max != null) {
            if (decimal.compareTo((BigDecimal)min) < 0 || decimal.compareTo((BigDecimal)max) > 0) {
                return this.hasFailMessage() ? this.getFailMessage() : new ValidationError(new I18nMessage("validation.numeric.range", new String[]{min.toString(), max.toString()}, "forms"));
            }
            return null;
        }
        if (min != null) {
            if (decimal.compareTo((BigDecimal)min) < 0) {
                return this.hasFailMessage() ? this.getFailMessage() : new ValidationError(new I18nMessage("validation.numeric.min", new String[]{min.toString()}, "forms"));
            }
            return null;
        }
        if (max != null) {
            if (decimal.compareTo((BigDecimal)max) > 0) {
                return this.hasFailMessage() ? this.getFailMessage() : new ValidationError(new I18nMessage("validation.numeric.max", new String[]{max.toString()}, "forms"));
            }
            return null;
        }
        return null;
    }

    public boolean supportsType(Class clazz, boolean arrayType) {
        return (class$java$lang$Comparable == null ? (class$java$lang$Comparable = RangeValidationRule.class$("java.lang.Comparable")) : class$java$lang$Comparable).isAssignableFrom(clazz) && !arrayType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

