/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;

public class HierarchyBinaryType
implements IBinaryType {
    private int modifiers;
    private boolean isClass;
    private char[] name;
    private char[] enclosingTypeName;
    private char[] superclass;
    private char[][] superInterfaces = IBinaryType.NoInterface;

    public HierarchyBinaryType(int modifiers, char[] qualification, char[] typeName, char[] enclosingTypeName, char classOrInterface) {
        this.modifiers = modifiers;
        boolean bl = this.isClass = classOrInterface == 'C';
        if (enclosingTypeName == null) {
            this.name = CharOperation.concat(qualification, typeName, '/');
        } else {
            this.name = CharOperation.concat(qualification, '/', enclosingTypeName, '$', typeName);
            this.enclosingTypeName = CharOperation.concat(qualification, enclosingTypeName, '/');
            CharOperation.replace(this.enclosingTypeName, '.', '/');
        }
        CharOperation.replace(this.name, '.', '/');
    }

    public char[] getEnclosingTypeName() {
        return this.enclosingTypeName;
    }

    public IBinaryField[] getFields() {
        return null;
    }

    public char[] getFileName() {
        return null;
    }

    public char[][] getInterfaceNames() {
        return this.superInterfaces;
    }

    public IBinaryNestedType[] getMemberTypes() {
        return null;
    }

    public IBinaryMethod[] getMethods() {
        return null;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public char[] getName() {
        return this.name;
    }

    public char[] getSuperclassName() {
        return this.superclass;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isBinaryType() {
        return true;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isInterface() {
        return !this.isClass;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isMember() {
        return false;
    }

    public void recordSuperType(char[] superTypeName, char[] superQualification, char superClassOrInterface) {
        int length;
        if (superQualification != null && superQualification[(length = superQualification.length) - 1] == '$') {
            char[] enclosingSuperName = CharOperation.lastSegment(superQualification, '.');
            superTypeName = CharOperation.concat(enclosingSuperName, superTypeName);
            superQualification = CharOperation.subarray(superQualification, 0, length - enclosingSuperName.length - 1);
        }
        if (superClassOrInterface == 'C') {
            if (!this.isClass) {
                return;
            }
            char[] encodedName = CharOperation.concat(superQualification, superTypeName, '/');
            CharOperation.replace(encodedName, '.', '/');
            this.superclass = encodedName;
        } else {
            char[] encodedName = CharOperation.concat(superQualification, superTypeName, '/');
            CharOperation.replace(encodedName, '.', '/');
            if (this.superInterfaces == IBinaryType.NoInterface) {
                this.superInterfaces = new char[][]{encodedName};
            } else {
                int length2 = this.superInterfaces.length;
                this.superInterfaces = new char[length2 + 1][];
                System.arraycopy(this.superInterfaces, 0, this.superInterfaces, 0, length2);
                this.superInterfaces[length2] = encodedName;
            }
        }
    }

    public String toString() {
        int length;
        StringBuffer buffer = new StringBuffer();
        if (this.modifiers == 1) {
            buffer.append("public ");
        }
        if (this.isClass()) {
            buffer.append("class ");
        } else {
            buffer.append("interface ");
        }
        if (this.name != null) {
            buffer.append(this.name);
        }
        if (this.superclass != null) {
            buffer.append("\n  extends ");
            buffer.append(this.superclass);
        }
        if (this.superInterfaces != null && (length = this.superInterfaces.length) != 0) {
            buffer.append("\n implements ");
            int i = 0;
            while (i < length) {
                buffer.append(this.superInterfaces[i]);
                if (i != length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    public char[] sourceFileName() {
        return null;
    }
}

