/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.build;

import net.sourceforge.chaperon.build.EmptyList;
import net.sourceforge.chaperon.build.FirstSetCollection;
import net.sourceforge.chaperon.common.IntegerList;
import net.sourceforge.chaperon.common.IntegerSet;
import net.sourceforge.chaperon.model.grammar.Error;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.symbol.Nonterminal;
import net.sourceforge.chaperon.model.symbol.Symbol;
import net.sourceforge.chaperon.model.symbol.SymbolList;
import net.sourceforge.chaperon.model.symbol.SymbolSet;
import net.sourceforge.chaperon.model.symbol.Terminal;

public class ItemSet {
    private int capacityIncrement = 25;
    private int elementCount = 0;
    private int[] productions = new int[25];
    private int[] positions = new int[25];
    private SymbolSet[] lookaheads = new SymbolSet[25];
    private SymbolSet transitionsymbols = new SymbolSet();
    private IntegerList transitionstates = new IntegerList();
    private Grammar grammar;
    private FirstSetCollection firstsets;
    private static final EmptyList EMPTYLIST = new EmptyList();

    public ItemSet(Grammar grammar, FirstSetCollection firstsets) {
        this.grammar = grammar;
        this.firstsets = firstsets;
    }

    private ItemSet(Grammar grammar, FirstSetCollection firstsets, ItemSet I) {
        this.grammar = grammar;
        this.firstsets = firstsets;
        this.addItemSet(I);
    }

    public boolean addItem(int production, int position, Symbol lookahead) {
        if (lookahead == null) {
            throw new NullPointerException("Lookahead symbol is null");
        }
        int i = 0;
        while (i < this.elementCount) {
            if (this.productions[i] == production && this.positions[i] == position) {
                if (this.lookaheads[i] == null) {
                    this.lookaheads[i] = new SymbolSet();
                }
                return this.lookaheads[i].addSymbol(lookahead);
            }
            ++i;
        }
        this.ensureCapacity(this.elementCount + 1);
        this.productions[this.elementCount] = production;
        this.positions[this.elementCount] = position;
        this.lookaheads[this.elementCount] = new SymbolSet();
        this.lookaheads[this.elementCount++].addSymbol(lookahead);
        return true;
    }

    public boolean addItem(int production, int position, SymbolSet lookaheads) {
        if (lookaheads == null) {
            throw new NullPointerException("Lookahead symbol set is null");
        }
        int i = 0;
        while (i < this.elementCount) {
            if (this.productions[i] == production && this.positions[i] == position) {
                if (this.lookaheads[i] == null) {
                    this.lookaheads[i] = new SymbolSet();
                }
                return this.lookaheads[i].addSymbol(lookaheads);
            }
            ++i;
        }
        this.ensureCapacity(this.elementCount + 1);
        this.productions[this.elementCount] = production;
        this.positions[this.elementCount] = position;
        this.lookaheads[this.elementCount] = new SymbolSet();
        this.lookaheads[this.elementCount++].addSymbol(lookaheads);
        return true;
    }

    public boolean addItemSet(ItemSet I) {
        boolean changed = false;
        int i = 0;
        while (i < I.elementCount) {
            changed |= this.addItem(I.productions[i], I.positions[i], I.lookaheads[i]);
            ++i;
        }
        return changed;
    }

    public boolean contains(ItemSet itemset) {
        int i = 0;
        while (i < itemset.elementCount) {
            int production = itemset.productions[i];
            int position = itemset.positions[i];
            boolean found = false;
            int j = 0;
            while (j < this.elementCount) {
                if (this.productions[j] == production && this.positions[j] == position) {
                    found = this.lookaheads[j].contains(itemset.lookaheads[i]);
                    break;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean containsCore(ItemSet itemset) {
        int i = 0;
        while (i < itemset.elementCount) {
            int production = itemset.productions[i];
            int position = itemset.positions[i];
            boolean found = false;
            int j = 0;
            while (j < this.elementCount && !found) {
                found = this.productions[j] == production && this.positions[j] == position;
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getItemCount() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public boolean equals(Object o) {
        if (o instanceof ItemSet) {
            ItemSet itemset = (ItemSet)o;
            if (itemset.getItemCount() != this.getItemCount()) {
                return false;
            }
            if (!this.contains(itemset)) {
                return false;
            }
            return itemset.contains(this);
        }
        return false;
    }

    public boolean equalsCore(Object o) {
        if (o instanceof ItemSet) {
            ItemSet itemset = (ItemSet)o;
            if (!this.containsCore(itemset)) {
                return false;
            }
            return itemset.containsCore(this);
        }
        return false;
    }

    private Symbol getItemNext(int index) {
        SymbolList productiondefinition = this.grammar.getProduction(this.productions[index]).getDefinition();
        if (this.positions[index] < productiondefinition.getSymbolCount()) {
            return productiondefinition.getSymbol(this.positions[index]);
        }
        return EMPTYLIST;
    }

    public SymbolSet getNextTerminals() {
        SymbolSet set = new SymbolSet();
        int item = 0;
        while (item < this.elementCount) {
            SymbolList productiondefinition = this.grammar.getProduction(this.productions[item]).getDefinition();
            if (this.positions[item] < productiondefinition.getSymbolCount() && productiondefinition.getSymbol(this.positions[item]) instanceof Terminal) {
                set.addSymbol(productiondefinition.getSymbol(this.positions[item]));
            }
            ++item;
        }
        return set;
    }

    public SymbolSet getNextNonterminals() {
        SymbolSet set = new SymbolSet();
        int item = 0;
        while (item < this.elementCount) {
            SymbolList productiondefinition = this.grammar.getProduction(this.productions[item]).getDefinition();
            if (this.positions[item] < productiondefinition.getSymbolCount() && productiondefinition.getSymbol(this.positions[item]) instanceof Nonterminal) {
                set.addSymbol(productiondefinition.getSymbol(this.positions[item]));
            }
            ++item;
        }
        return set;
    }

    public Error getNextError() {
        int item = 0;
        while (item < this.elementCount) {
            SymbolList productiondefinition = this.grammar.getProduction(this.productions[item]).getDefinition();
            if (this.positions[item] < productiondefinition.getSymbolCount() && productiondefinition.getSymbol(this.positions[item]) instanceof Error) {
                return (Error)productiondefinition.getSymbol(this.positions[item]);
            }
            ++item;
        }
        return null;
    }

    public ItemSet closure() {
        ItemSet J = new ItemSet(this.grammar, this.firstsets, this);
        SymbolSet b = new SymbolSet();
        SymbolSet b2 = new SymbolSet();
        boolean changed = false;
        do {
            changed = false;
            int i = 0;
            while (i < J.elementCount) {
                Symbol symbol;
                SymbolList productiondefinition = this.grammar.getProduction(J.productions[i]).getDefinition();
                if (J.positions[i] < productiondefinition.getSymbolCount() && (symbol = productiondefinition.getSymbol(J.positions[i])) instanceof Nonterminal) {
                    int pos = J.positions[i] + 1;
                    b.clear();
                    if (pos < productiondefinition.getSymbolCount()) {
                        do {
                            if (productiondefinition.getSymbol(pos) instanceof Terminal) {
                                b2.clear();
                                b2.addSymbol(productiondefinition.getSymbol(pos));
                            } else {
                                b2.clear();
                                b2.addSymbol(this.firstsets.getFirstSet(productiondefinition.getSymbol(pos)));
                            }
                            b.addSymbol(b2);
                        } while (b2.contains(EMPTYLIST) && ++pos < productiondefinition.getSymbolCount());
                        if (b.contains(EMPTYLIST)) {
                            b.addSymbol(J.lookaheads[i]);
                        }
                        b.removeSymbol(EMPTYLIST);
                    } else if (pos >= productiondefinition.getSymbolCount()) {
                        b.addSymbol(J.lookaheads[i]);
                    }
                    IntegerList productionlist = this.grammar.getProductionList(symbol);
                    int j = 0;
                    while (j < productionlist.getCount()) {
                        int k = 0;
                        while (k < b.getSymbolCount()) {
                            changed |= J.addItem(productionlist.get(j), 0, b.getSymbol(k));
                            ++k;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        } while (changed);
        return J;
    }

    public ItemSet jump(Symbol symbol) {
        ItemSet J = new ItemSet(this.grammar, this.firstsets);
        int i = 0;
        while (i < this.elementCount) {
            if (this.getItemNext(i).equals(symbol)) {
                J.addItem(this.productions[i], this.positions[i] + 1, this.lookaheads[i]);
            }
            ++i;
        }
        return J.closure();
    }

    public void setTransition(Symbol symbol, int state) {
        if (this.transitionsymbols.contains(symbol)) {
            this.transitionstates.set(this.transitionsymbols.indexOf(symbol), state);
        } else {
            this.transitionsymbols.addSymbol(symbol);
            this.transitionstates.add(state);
        }
    }

    public int getTransition(Symbol symbol) {
        if (this.transitionsymbols.contains(symbol)) {
            return this.transitionstates.get(this.transitionsymbols.indexOf(symbol));
        }
        return -1;
    }

    public SymbolSet getShiftSymbols() {
        return this.transitionsymbols;
    }

    public IntegerSet getReduceProductions() {
        IntegerSet reduceproductions = new IntegerSet();
        int i = 0;
        while (i < this.elementCount) {
            if (this.getItemNext(i).equals(EMPTYLIST)) {
                reduceproductions.add(this.productions[i]);
            }
            ++i;
        }
        return reduceproductions;
    }

    public IntegerSet getReduceProductions(Symbol lookahead) {
        IntegerSet reduceproductions = new IntegerSet();
        int i = 0;
        while (i < this.elementCount) {
            if (this.getItemNext(i).equals(EMPTYLIST) && (this.lookaheads[i].contains(lookahead) || this.lookaheads[i].contains(Error.instance))) {
                reduceproductions.add(this.productions[i]);
            }
            ++i;
        }
        return reduceproductions;
    }

    public SymbolSet getReduceSymbols() {
        SymbolSet reducesymbols = new SymbolSet();
        int i = 0;
        while (i < this.elementCount) {
            if (this.getItemNext(i).equals(EMPTYLIST)) {
                reducesymbols.addSymbol(this.lookaheads[i]);
            }
            ++i;
        }
        return reducesymbols;
    }

    private void ensureCapacity(int minCapacity) {
        if (this.productions.length >= minCapacity) {
            return;
        }
        int newCapacity = this.productions.length + this.capacityIncrement;
        if (this.capacityIncrement <= 0) {
            newCapacity = this.productions.length * 2;
        }
        int[] newProductions = new int[Math.max(newCapacity, minCapacity)];
        int[] newPositions = new int[Math.max(newCapacity, minCapacity)];
        SymbolSet[] newLookaheads = new SymbolSet[Math.max(newCapacity, minCapacity)];
        System.arraycopy(this.productions, 0, newProductions, 0, this.productions.length);
        System.arraycopy(this.positions, 0, newPositions, 0, this.productions.length);
        System.arraycopy(this.lookaheads, 0, newLookaheads, 0, this.productions.length);
        this.productions = newProductions;
        this.positions = newPositions;
        this.lookaheads = newLookaheads;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int production = 0;
        while (production < this.grammar.getProductionCount()) {
            SymbolList list = this.grammar.getProduction(production).getDefinition();
            int position = 0;
            while (position <= list.getSymbolCount()) {
                int item = 0;
                while (item < this.elementCount) {
                    if (this.productions[item] == production && this.positions[item] == position) {
                        buffer.append(this.grammar.getProduction(production).getSymbol());
                        buffer.append(" -> ");
                        int i = 0;
                        while (i < list.getSymbolCount()) {
                            if (i == position) {
                                buffer.append(".");
                            }
                            buffer.append(list.getSymbol(i) + " ");
                            ++i;
                        }
                        if (position == list.getSymbolCount()) {
                            buffer.append(".");
                        }
                        buffer.append(" , ");
                        int lookahead = 0;
                        while (lookahead < this.lookaheads[item].getSymbolCount()) {
                            if (lookahead > 0) {
                                buffer.append(" / ");
                            }
                            buffer.append(this.lookaheads[item].getSymbol(lookahead).toString());
                            ++lookahead;
                        }
                        buffer.append("\n");
                        break;
                    }
                    ++item;
                }
                ++position;
            }
            ++production;
        }
        SymbolSet set = this.getShiftSymbols();
        int index = 0;
        while (index < set.getSymbolCount()) {
            buffer.append("Transition for ");
            buffer.append(set.getSymbol(index));
            buffer.append(" -> State ");
            buffer.append(String.valueOf(this.getTransition(set.getSymbol(index))));
            buffer.append("\n");
            ++index;
        }
        return buffer.toString();
    }
}

