/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import javax.xml.transform.Source;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class XPathDynamicContext {
    private XPathContextMajor contextObject;

    protected XPathDynamicContext(XPathContextMajor xPathContextMajor) {
        this.contextObject = xPathContextMajor;
    }

    public void setContextNode(Source source) throws XPathException {
        NodeInfo nodeInfo = source instanceof NodeInfo ? (NodeInfo)source : this.contextObject.getConfiguration().buildDocument(source);
        this.setContextItem(nodeInfo);
    }

    public void setContextItem(Item item) {
        UnfailingIterator unfailingIterator = SingletonIterator.makeIterator(item);
        unfailingIterator.next();
        this.contextObject.setCurrentIterator(unfailingIterator);
    }

    public Item getContextItem() {
        return this.contextObject.getContextItem();
    }

    public void setVariable(XPathVariable xPathVariable, ValueRepresentation valueRepresentation) {
        this.contextObject.setLocalVariable(xPathVariable.getLocalSlotNumber(), valueRepresentation);
    }

    protected XPathContext getXPathContextObject() {
        return this.contextObject;
    }

    protected void checkExternalVariables(SlotManager slotManager, int n) throws XPathException {
        ValueRepresentation[] valueRepresentationArray = this.contextObject.getStackFrame().getStackFrameValues();
        for (int i = 0; i < n; ++i) {
            if (valueRepresentationArray[i] != null) continue;
            int n2 = (Integer)slotManager.getVariableMap().get(i);
            String string = this.contextObject.getConfiguration().getNamePool().getDisplayName(n2);
            throw new DynamicError("No value has been supplied for variable $" + string);
        }
    }
}

