/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.sax;

import java.util.HashMap;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class XMLByteStreamCompiler
implements XMLSerializer,
Recyclable {
    private HashMap map = new HashMap();
    private int mapCount;
    private byte[] buf;
    private int bufCount;
    private int bufCountAverage = 2000;
    private static final int START_DOCUMENT = 0;
    private static final int END_DOCUMENT = 1;
    private static final int START_PREFIX_MAPPING = 2;
    private static final int END_PREFIX_MAPPING = 3;
    private static final int START_ELEMENT = 4;
    private static final int END_ELEMENT = 5;
    private static final int CHARACTERS = 6;
    private static final int IGNORABLE_WHITESPACE = 7;
    private static final int PROCESSING_INSTRUCTION = 8;
    private static final int COMMENT = 9;
    private static final int LOCATOR = 10;
    private static final int START_DTD = 11;
    private static final int END_DTD = 12;
    private static final int START_CDATA = 13;
    private static final int END_CDATA = 14;
    private static final int SKIPPED_ENTITY = 15;
    private static final int START_ENTITY = 16;
    private static final int END_ENTITY = 17;

    public XMLByteStreamCompiler() {
        this.initOutput();
    }

    private void initOutput() {
        this.mapCount = 0;
        this.map.clear();
        this.buf = new byte[this.bufCountAverage];
        this.buf[0] = 67;
        this.buf[1] = 88;
        this.buf[2] = 77;
        this.buf[3] = 76;
        this.buf[4] = 1;
        this.buf[5] = 0;
        this.bufCount = 6;
    }

    public void recycle() {
        this.bufCountAverage = (this.bufCountAverage + this.bufCount) / 2;
        this.initOutput();
    }

    public Object getSAXFragment() {
        if (this.bufCount == 6) {
            return null;
        }
        byte[] newbuf = new byte[this.bufCount];
        System.arraycopy(this.buf, 0, newbuf, 0, this.bufCount);
        return newbuf;
    }

    public void startDocument() throws SAXException {
        this.writeEvent(0);
    }

    public void endDocument() throws SAXException {
        this.writeEvent(1);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.writeEvent(2);
        this.writeString(prefix);
        this.writeString(uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.writeEvent(3);
        this.writeString(prefix);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        int length = atts.getLength();
        this.writeEvent(4);
        this.writeAttributes(length);
        for (int i = 0; i < length; ++i) {
            this.writeString(atts.getURI(i));
            this.writeString(atts.getLocalName(i));
            this.writeString(atts.getQName(i));
            this.writeString(atts.getType(i));
            this.writeString(atts.getValue(i));
        }
        this.writeString(namespaceURI == null ? "" : namespaceURI);
        this.writeString(localName);
        this.writeString(qName);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.writeEvent(5);
        this.writeString(namespaceURI == null ? "" : namespaceURI);
        this.writeString(localName);
        this.writeString(qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.writeEvent(6);
        this.writeChars(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.writeEvent(7);
        this.writeChars(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.writeEvent(8);
        this.writeString(target);
        this.writeString(data);
    }

    public void setDocumentLocator(Locator locator) {
        try {
            this.writeEvent(10);
            String publicId = locator.getPublicId();
            String systemId = locator.getSystemId();
            this.writeString(publicId != null ? publicId : "");
            this.writeString(systemId != null ? systemId : "");
            this.write(locator.getLineNumber());
            this.write(locator.getColumnNumber());
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error while handling locator", (Throwable)e);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        this.writeEvent(15);
        this.writeString(name);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.writeEvent(11);
        this.writeString(name);
        this.writeString(publicId != null ? publicId : "");
        this.writeString(systemId != null ? systemId : "");
    }

    public void endDTD() throws SAXException {
        this.writeEvent(12);
    }

    public void startEntity(String name) throws SAXException {
        this.writeEvent(16);
        this.writeString(name);
    }

    public void endEntity(String name) throws SAXException {
        this.writeEvent(17);
        this.writeString(name);
    }

    public void startCDATA() throws SAXException {
        this.writeEvent(13);
    }

    public void endCDATA() throws SAXException {
        this.writeEvent(14);
    }

    public void comment(char[] ary, int start, int length) throws SAXException {
        try {
            this.writeEvent(9);
            this.writeChars(ary, start, length);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public final void writeEvent(int event) {
        this.write(event);
    }

    public final void writeAttributes(int attributes) throws SAXException {
        if (attributes > 65535) {
            throw new SAXException("Too many attributes");
        }
        this.write(attributes >>> 8 & 0xFF);
        this.write(attributes >>> 0 & 0xFF);
    }

    public final void writeString(String str) throws SAXException {
        Integer index = (Integer)this.map.get(str);
        if (index == null) {
            this.map.put(str, new Integer(this.mapCount++));
            int length = str.length();
            this.writeChars(str.toCharArray(), 0, length);
        } else {
            int i = index;
            if (i > 65535) {
                throw new SAXException("Index too large");
            }
            this.write(i >>> 8 & 0xFF | 0x80);
            this.write(i >>> 0 & 0xFF);
        }
    }

    public final void writeChars(char[] ch, int start, int length) {
        char c;
        int i;
        int utflen = 0;
        for (i = 0; i < length; ++i) {
            c = ch[i + start];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen >= Short.MAX_VALUE) {
            this.assure(this.bufCount + utflen + 6);
            this.buf[this.bufCount++] = 127;
            this.buf[this.bufCount++] = -1;
            this.buf[this.bufCount++] = (byte)(utflen >>> 24 & 0xFF);
            this.buf[this.bufCount++] = (byte)(utflen >>> 16 & 0xFF);
            this.buf[this.bufCount++] = (byte)(utflen >>> 8 & 0xFF);
            this.buf[this.bufCount++] = (byte)(utflen >>> 0 & 0xFF);
        } else {
            this.assure(this.bufCount + utflen + 2);
            this.buf[this.bufCount++] = (byte)(utflen >>> 8 & 0xFF);
            this.buf[this.bufCount++] = (byte)(utflen >>> 0 & 0xFF);
        }
        for (i = 0; i < length; ++i) {
            c = ch[i + start];
            if (c >= '\u0001' && c <= '\u007f') {
                this.buf[this.bufCount++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.buf[this.bufCount++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buf[this.bufCount++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buf[this.bufCount++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buf[this.bufCount++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buf[this.bufCount++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    private void write(int b) {
        int newcount = this.bufCount + 1;
        this.assure(newcount);
        this.buf[this.bufCount] = (byte)b;
        this.bufCount = newcount;
    }

    private void assure(int size) {
        if (size > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, size)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.bufCount);
            this.buf = newbuf;
        }
    }
}

