/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import java.util.ArrayList;
import java.util.Iterator;

public class Property
extends AbstractSdxObject {
    public static final String CLASS_NAME_SUFFIX = "Property";
    protected String name;
    protected ArrayList values = new ArrayList();
    protected String firstValue = null;

    public Property() {
    }

    public Property(String name, String value) {
        this.name = name;
        this.attemptToSetFirstValue(value);
        this.values.add(value);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValues(String[] values) {
        if (values != null) {
            this.resetValues();
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                this.addValue(value);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getValues() {
        if (this.values != null) {
            Iterator keys = this.values.iterator();
            String[] vals = new String[this.values.size()];
            for (int i = 0; i < vals.length && keys.hasNext(); ++i) {
                vals[i] = (String)keys.next();
            }
            return vals;
        }
        return new String[0];
    }

    public String getValue() {
        return this.firstValue;
    }

    public void deleteValue(String value) {
        if (this.values != null && value != null) {
            this.values.remove(value);
        }
    }

    public void addValue(String value) {
        if (this.values != null && value != null) {
            this.attemptToSetFirstValue(value);
            this.values.add(value);
        }
    }

    protected void attemptToSetFirstValue(String value) {
        if (Utilities.checkString(this.firstValue)) {
            return;
        }
        this.firstValue = value;
    }

    protected void resetValues() {
        if (this.values != null) {
            this.values.clear();
        }
        this.firstValue = null;
    }

    public boolean containsValue(String value) {
        return this.values.contains(value);
    }

    protected String getClassNameSuffix() {
        return CLASS_NAME_SUFFIX;
    }

    protected boolean initToSax() {
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }
}

