/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fonts.Font;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.CharUtilities;

public class CharacterLayoutManager
extends LeafNodeLayoutManager {
    private Character fobj;
    private MinOptMax letterSpaceIPD;
    private int hyphIPD;
    private Font font;
    private CommonBorderPaddingBackground borderProps = null;

    public CharacterLayoutManager(Character node) {
        super(node);
        this.fobj = node;
    }

    public void initialize() {
        this.font = this.fobj.getCommonFont().getFontState(this.fobj.getFOEventHandler().getFontInfo(), this);
        SpaceVal ls = SpaceVal.makeLetterSpacing(this.fobj.getLetterSpacing());
        this.letterSpaceIPD = ls.getSpace();
        this.hyphIPD = this.font.getCharWidth(this.fobj.getCommonHyphenation().hyphenationCharacter);
        this.borderProps = this.fobj.getCommonBorderPaddingBackground();
        this.setCommonBorderPaddingBackground(this.borderProps);
        TextArea chArea = this.getCharacterInlineArea(this.fobj);
        chArea.setBaselineOffset(this.font.getAscender());
        this.setCurrentArea(chArea);
    }

    private TextArea getCharacterInlineArea(Character node) {
        TextArea text = new TextArea();
        char ch = node.getCharacter();
        if (CharUtilities.isAnySpace(ch)) {
            if (!CharUtilities.isZeroWidthSpace(ch)) {
                text.addSpace(ch, 0, CharUtilities.isAdjustableSpace(ch));
            }
        } else {
            text.addWord(String.valueOf(ch), 0);
        }
        TraitSetter.setProducerID(text, node.getId());
        TraitSetter.addTextDecoration(text, this.fobj.getTextDecoration());
        return text;
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        this.curArea = this.get(context);
        InlineKnuthSequence seq = new InlineKnuthSequence();
        if (this.curArea == null) {
            this.setFinished(true);
            return null;
        }
        MinOptMax ipd = new MinOptMax(this.font.getCharWidth(this.fobj.getCharacter()));
        this.curArea.setIPD(ipd.opt);
        this.curArea.setBPD(this.font.getAscender() - this.font.getDescender());
        TraitSetter.addFontTraits(this.curArea, this.font);
        this.curArea.addTrait(Trait.COLOR, this.fobj.getColor());
        this.alignmentContext = new AlignmentContext(this.font, this.font.getFontSize(), this.fobj.getAlignmentAdjust(), this.fobj.getAlignmentBaseline(), this.fobj.getBaselineShift(), this.fobj.getDominantBaseline(), context.getAlignmentContext());
        this.addKnuthElementsForBorderPaddingStart(seq);
        this.areaInfo = new LeafNodeLayoutManager.AreaInfo(this, 0, ipd, false, this.alignmentContext);
        if (this.letterSpaceIPD.min == this.letterSpaceIPD.max) {
            seq.add(new KnuthInlineBox(this.areaInfo.ipdArea.opt, this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
        } else {
            seq.add(new KnuthInlineBox(this.areaInfo.ipdArea.opt, this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
            seq.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            seq.add(new KnuthGlue(0, 0, 0, new LeafPosition(this, -1), true));
            seq.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true));
        }
        this.addKnuthElementsForBorderPaddingEnd(seq);
        LinkedList<InlineKnuthSequence> returnList = new LinkedList<InlineKnuthSequence>();
        returnList.add(seq);
        this.setFinished(true);
        return returnList;
    }

    public void getWordChars(StringBuffer sbChars, Position bp) {
        sbChars.append(((TextArea)this.curArea).getText());
    }

    public void hyphenate(Position pos, HyphContext hc) {
        if (hc.getNextHyphPoint() == 1) {
            this.areaInfo.bHyphenated = true;
            this.isSomethingChanged = true;
        }
        hc.updateOffset(1);
    }

    public boolean applyChanges(List oldList) {
        this.setFinished(false);
        return this.isSomethingChanged;
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        this.addKnuthElementsForBorderPaddingStart(returnList);
        if (this.letterSpaceIPD.min == this.letterSpaceIPD.max || this.areaInfo.iLScount == 0) {
            returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.opt, this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
            if (this.areaInfo.bHyphenated) {
                returnList.add(new KnuthPenalty(this.hyphIPD, 50, true, new LeafPosition(this, -1), false));
            }
        } else {
            returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.opt - this.areaInfo.iLScount * this.letterSpaceIPD.opt, this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
            returnList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            returnList.add(new KnuthGlue(this.areaInfo.iLScount * this.letterSpaceIPD.opt, this.areaInfo.iLScount * this.letterSpaceIPD.max - this.letterSpaceIPD.opt, this.areaInfo.iLScount * this.letterSpaceIPD.opt - this.letterSpaceIPD.min, new LeafPosition(this, -1), true));
            returnList.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true));
            if (this.areaInfo.bHyphenated) {
                returnList.add(new KnuthPenalty(this.hyphIPD, 50, true, new LeafPosition(this, -1), false));
            }
        }
        this.addKnuthElementsForBorderPaddingEnd(returnList);
        this.setFinished(true);
        return returnList;
    }

    protected void addId() {
        this.getPSLM().addIDToPage(this.fobj.getId());
    }
}

