/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;

public class WildcardMatcherHelper {
    public static final char ESC = '\\';
    public static final char PATHSEP = '/';
    public static final char STAR = '*';
    private static final Map cache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map match(String pat, String str) {
        Matcher matcher;
        Map map = cache;
        synchronized (map) {
            matcher = (Matcher)cache.get(pat);
            if (matcher == null) {
                matcher = new Matcher(pat);
                cache.put(pat, matcher);
            }
        }
        String[] list = matcher.getMatches(str);
        if (list == null) {
            return null;
        }
        int n = list.length;
        HashMap<String, String> map2 = new HashMap<String, String>(n * 2 + 1);
        for (int i = 0; i < n; ++i) {
            map2.put(String.valueOf(i), list[i]);
        }
        return map2;
    }

    private static REProgram compileRegexp(String pat) {
        StringBuffer repat = new StringBuffer(pat.length() * 6);
        repat.append('^');
        char[] wcpat = (pat + '\\').toCharArray();
        int n = pat.length();
        for (int i = 0; i < n; ++i) {
            char ch = wcpat[i];
            if (ch == '*') {
                if (wcpat[i + 1] != '*') {
                    repat.append("([^/]*)");
                    continue;
                }
                while (wcpat[i + 1] == '*') {
                    ++i;
                }
                repat.append("(.*)");
                continue;
            }
            if (ch == '\\' && (ch = wcpat[++i]) != '\\' && ch != '*') {
                repat.append("\\\\");
            }
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '/') {
                repat.append(ch);
                continue;
            }
            repat.append('\\');
            repat.append(ch);
        }
        repat.append('$');
        return new RECompiler().compile(repat.toString());
    }

    private static class Matcher {
        private static final REProgram splitter;
        private static final int WC_CONST = 0;
        private static final int WC_STAR = 1;
        private static final int WC_STARSTAR = 2;
        private static final int WC_REGEXP = 3;
        private final String prefix;
        private final String suffix;
        private final int fixlen;
        private final int wctype;
        private final REProgram regexp;

        Matcher(String pat) {
            RE re = new RE(splitter);
            if (re.match(pat)) {
                this.prefix = re.getParen(1);
                String wildcard = re.getParen(2);
                String tail = re.getParen(3);
                if (tail.length() != 0 && wildcard.charAt(wildcard.length() - 1) == '\\') {
                    wildcard = wildcard + tail.substring(0, 1);
                    this.suffix = tail.substring(1);
                } else {
                    this.suffix = tail;
                }
                if (wildcard.equals("*")) {
                    this.wctype = 1;
                    this.regexp = null;
                } else if (wildcard.equals("**")) {
                    this.wctype = 2;
                    this.regexp = null;
                } else {
                    this.wctype = 3;
                    this.regexp = WildcardMatcherHelper.compileRegexp(wildcard);
                }
            } else {
                this.prefix = pat;
                this.suffix = "";
                this.wctype = 0;
                this.regexp = null;
            }
            this.fixlen = this.prefix.length() + this.suffix.length();
        }

        String[] getMatches(String str) {
            if (str.length() < this.fixlen) {
                return null;
            }
            if (!str.startsWith(this.prefix)) {
                return null;
            }
            if (!str.endsWith(this.suffix)) {
                return null;
            }
            String infix = str.substring(this.prefix.length(), str.length() - this.suffix.length());
            if (this.wctype == 3) {
                RE re = new RE(this.regexp);
                if (!re.match(infix)) {
                    return null;
                }
                int n = re.getParenCount();
                String[] list = new String[n];
                list[0] = str;
                for (int i = 1; i < n; ++i) {
                    list[i] = re.getParen(i);
                }
                return list;
            }
            if (this.wctype == 0) {
                if (infix.length() != 0) {
                    return null;
                }
                return new String[]{str};
            }
            if (this.wctype == 1 && infix.indexOf(47) != -1) {
                return null;
            }
            return new String[]{str, infix};
        }

        static {
            String fixedRE = "([^*\\\\]*)";
            String wcardRE = "(.*[*\\\\])";
            String splitRE = "^([^*\\\\]*)(.*[*\\\\])([^*\\\\]*)$";
            splitter = new RECompiler().compile("^([^*\\\\]*)(.*[*\\\\])([^*\\\\]*)$");
        }
    }
}

