/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.source.SourceFactory;
import org.apache.cocoon.components.source.impl.CocoonToAvalonSource;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.util.ClassUtils;
import org.apache.excalibur.source.Source;

public final class SourceFactoryWrapper
extends AbstractLogEnabled
implements org.apache.excalibur.source.SourceFactory,
ThreadSafe,
Configurable,
Disposable,
Composable,
Contextualizable {
    private ComponentManager manager;
    private SourceFactory sourceFactory;
    private Context context;

    public void configure(Configuration conf) throws ConfigurationException {
        try {
            Configuration factoryConf = conf.getChild("source-factory");
            String className = factoryConf.getAttribute("class");
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Getting the SourceFactory " + className);
            }
            this.sourceFactory = (SourceFactory)ClassUtils.newInstance((String)className);
            this.init(this.sourceFactory, factoryConf);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not get parameters because: " + e.getMessage(), (Throwable)e);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void dispose() {
        if (this.sourceFactory != null) {
            this.deinit(this.sourceFactory);
        }
        this.sourceFactory = null;
    }

    public Source getSource(String location, Map parameters) throws MalformedURLException, IOException {
        org.apache.cocoon.environment.Source source;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating source object for " + location);
        }
        Environment currentEnv = CocoonComponentManager.getCurrentEnvironment();
        try {
            source = this.sourceFactory.getSource(currentEnv, location);
        }
        catch (ProcessingException pe) {
            throw new CascadingIOException("ProcessingException: " + pe.getMessage(), (Throwable)pe);
        }
        return new CocoonToAvalonSource(location, source);
    }

    private void init(SourceFactory factory, Configuration config) throws ContextException, ComponentException, ConfigurationException {
        if (factory instanceof LogEnabled) {
            ((LogEnabled)factory).enableLogging(this.getLogger());
        }
        if (factory instanceof Contextualizable) {
            ((Contextualizable)factory).contextualize(this.context);
        }
        if (factory instanceof Composable) {
            ((Composable)factory).compose(this.manager);
        }
        if (config != null && factory instanceof Configurable) {
            ((Configurable)factory).configure(config);
        }
    }

    private void deinit(SourceFactory factory) {
        if (factory instanceof Disposable) {
            ((Disposable)factory).dispose();
        }
    }

    public void release(Source source) {
        if (null != source) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Releasing source " + source.getURI());
            }
            ((Recyclable)source).recycle();
        }
    }
}

