/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashSet;
import org.apache.lucene.store.Lock;

class NativeFSLock
extends Lock {
    private RandomAccessFile f;
    private FileChannel channel;
    private FileLock lock;
    private File path;
    private File lockDir;
    private static HashSet LOCK_HELD = new HashSet();

    public NativeFSLock(File lockDir, String lockFileName) {
        this.lockDir = lockDir;
        this.path = new File(lockDir, lockFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean obtain() throws IOException {
        block49: {
            if (this.isLocked()) {
                return false;
            }
            if (!this.lockDir.exists()) {
                if (!this.lockDir.mkdirs()) {
                    throw new IOException("Cannot create directory: " + this.lockDir.getAbsolutePath());
                }
            } else if (!this.lockDir.isDirectory()) {
                throw new IOException("Found regular file where directory expected: " + this.lockDir.getAbsolutePath());
            }
            String canonicalPath = this.path.getCanonicalPath();
            boolean markedHeld = false;
            try {
                HashSet hashSet = LOCK_HELD;
                synchronized (hashSet) {
                    block48: {
                        if (!LOCK_HELD.contains(canonicalPath)) break block48;
                        boolean bl = false;
                        return bl;
                    }
                    LOCK_HELD.add(canonicalPath);
                    markedHeld = true;
                }
                try {
                    this.f = new RandomAccessFile(this.path, "rw");
                }
                catch (IOException e) {
                    this.failureReason = e;
                    this.f = null;
                }
                if (this.f == null) break block49;
                try {
                    this.channel = this.f.getChannel();
                    try {
                        this.lock = this.channel.tryLock();
                    }
                    catch (IOException e) {
                        this.failureReason = e;
                    }
                    finally {
                        if (this.lock == null) {
                            try {
                                this.channel.close();
                            }
                            finally {
                                this.channel = null;
                            }
                        }
                    }
                }
                finally {
                    if (this.channel == null) {
                        try {
                            this.f.close();
                        }
                        finally {
                            this.f = null;
                        }
                    }
                }
            }
            finally {
                if (markedHeld && !this.isLocked()) {
                    HashSet hashSet = LOCK_HELD;
                    synchronized (hashSet) {
                        if (LOCK_HELD.contains(canonicalPath)) {
                            LOCK_HELD.remove(canonicalPath);
                        }
                    }
                }
            }
        }
        return this.isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        block37: {
            try {
                if (!this.isLocked()) break block37;
                try {
                    this.lock.release();
                    Object var2_1 = null;
                    this.lock = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.lock = null;
                    try {
                        this.channel.close();
                    }
                    finally {
                        this.channel = null;
                        try {
                            this.f.close();
                        }
                        finally {
                            this.f = null;
                            HashSet hashSet = LOCK_HELD;
                            synchronized (hashSet) {
                                LOCK_HELD.remove(this.path.getCanonicalPath());
                            }
                        }
                    }
                    throw throwable;
                }
                try {
                    this.channel.close();
                }
                finally {
                    this.channel = null;
                    try {
                        this.f.close();
                    }
                    finally {
                        this.f = null;
                        HashSet hashSet = LOCK_HELD;
                        synchronized (hashSet) {
                            LOCK_HELD.remove(this.path.getCanonicalPath());
                        }
                    }
                }
                this.path.delete();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isLocked() {
        return this.lock != null;
    }

    public String toString() {
        return "NativeFSLock@" + this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            if (this.isLocked()) {
                this.release();
            }
        }
        finally {
            super.finalize();
        }
    }
}

