/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.xpath;

import java.util.List;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.xml.xpath.AbstractProcessorImpl;
import org.apache.excalibur.xml.xpath.EmptyNodeList;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.SimpleNodeList;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.jaxen.NamespaceContext;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JaxenProcessorImpl
extends AbstractProcessorImpl
implements XPathProcessor,
Component,
ThreadSafe {
    public boolean evaluateAsBoolean(Node contextNode, String str, PrefixResolver resolver) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)new JaxenResolver(resolver));
            return path.booleanValueOf((Object)contextNode);
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return false;
        }
    }

    public Number evaluateAsNumber(Node contextNode, String str, PrefixResolver resolver) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)new JaxenResolver(resolver));
            return path.numberValueOf((Object)contextNode);
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    public String evaluateAsString(Node contextNode, String str, PrefixResolver resolver) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)new JaxenResolver(resolver));
            return path.stringValueOf((Object)contextNode);
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    public Node selectSingleNode(Node contextNode, String str, PrefixResolver resolver) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)new JaxenResolver(resolver));
            return (Node)path.selectSingleNode((Object)contextNode);
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return null;
        }
    }

    public NodeList selectNodeList(Node contextNode, String str, PrefixResolver resolver) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)new JaxenResolver(resolver));
            List list = path.selectNodes((Object)contextNode);
            return new SimpleNodeList(list);
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to evaluate '" + str + "'", (Throwable)e);
            }
            return new EmptyNodeList();
        }
    }

    private static class JaxenResolver
    implements NamespaceContext {
        private final PrefixResolver resolver;

        public JaxenResolver(PrefixResolver resolver) {
            this.resolver = resolver;
        }

        public String translateNamespacePrefixToUri(String prefix) {
            return this.resolver.prefixToNamespace(prefix);
        }
    }
}

