/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.access.exception.ObjectNotFoundException;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.remote.RemoteCacheFactory;
import org.apache.jcs.auxiliary.remote.RemoteCacheMonitor;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWaitFacade;
import org.apache.jcs.auxiliary.remote.ZombieRemoteCacheService;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.behavior.ICache;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.behavior.IZombie;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;
import org.apache.jcs.utils.threadpool.ThreadPool;
import org.apache.jcs.utils.threadpool.ThreadPoolManager;

public class RemoteCache
implements ICache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCache == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCache = RemoteCache.class$("org.apache.jcs.auxiliary.remote.RemoteCache")) : class$org$apache$jcs$auxiliary$remote$RemoteCache));
    final String cacheName;
    private IRemoteCacheAttributes irca;
    private IRemoteCacheService remote;
    private IRemoteCacheListener listener;
    IElementAttributes attr = null;
    private ThreadPool pool = null;
    private boolean usePoolForGet = false;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCache;

    public RemoteCache(IRemoteCacheAttributes cattr, IRemoteCacheService remote, IRemoteCacheListener listener) {
        this.irca = cattr;
        this.cacheName = cattr.getCacheName();
        this.remote = remote;
        this.listener = listener;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Construct> cacheName=" + cattr.getCacheName()));
            log.debug((Object)("irca = " + this.irca));
            log.debug((Object)("listener = " + listener));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("GetTimeoutMillis() = " + this.irca.getGetTimeoutMillis()));
        }
        if (this.irca.getGetTimeoutMillis() > 0) {
            this.pool = ThreadPoolManager.getInstance().getPool(this.irca.getThreadPoolName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Thread Pool = " + this.pool));
            }
            if (this.pool != null) {
                this.usePoolForGet = true;
            }
        }
    }

    public void setElementAttributes(IElementAttributes attr) {
        this.attr = attr;
    }

    public IElementAttributes getElementAttributes() {
        return this.attr;
    }

    public void update(ICacheElement ce) throws IOException {
        if (!this.irca.getGetOnly()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sending item to remote server");
                }
                this.remote.update(ce, this.getListenerId());
            }
            catch (NullPointerException npe) {
                log.error((Object)("npe for ce = " + ce + "ce.attr = " + ce.getElementAttributes()), (Throwable)npe);
                return;
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to put " + ce.getKey() + " to " + ce.getCacheName());
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"get only mode, not sending to remote server");
        }
    }

    public ICacheElement get(Serializable key) throws IOException {
        ICacheElement retVal = null;
        try {
            retVal = this.usePoolForGet ? this.getUsingPool(this.sanitized(key)) : this.remote.get(this.cacheName, this.sanitized(key));
        }
        catch (ObjectNotFoundException one) {
            log.debug((Object)("didn't find element " + key + " in remote"));
            return null;
        }
        catch (Exception ex) {
            this.handleException(ex, "Failed to get " + key + " from " + this.cacheName);
        }
        return retVal;
    }

    public ICacheElement getUsingPool(final Serializable key) throws IOException {
        int timeout = this.irca.getGetTimeoutMillis();
        try {
            FutureResult future = new FutureResult();
            Runnable command = future.setter(new Callable(){

                public Object call() throws IOException {
                    try {
                        return RemoteCache.this.remote.get(RemoteCache.this.cacheName, key);
                    }
                    catch (ObjectNotFoundException onf) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"getusingPool, Didin't find object");
                        }
                        return null;
                    }
                }
            });
            this.pool.execute(command);
            ICacheElement ice = (ICacheElement)future.timedGet((long)timeout);
            if (log.isDebugEnabled()) {
                if (ice == null) {
                    log.debug((Object)"nothing found in remote cache");
                } else {
                    log.debug((Object)"found item in remote cache");
                }
            }
            return ice;
        }
        catch (InterruptedException ex) {
            log.warn((Object)("Get Request timed out after " + timeout));
            throw new IOException("Get Request timed out after " + timeout);
        }
        catch (InvocationTargetException ex) {
            log.error((Object)"Assuming an IO exception thrown in the backfground.", (Throwable)ex);
            throw new IOException("Get Request timed out after " + timeout);
        }
    }

    public Set getGroupKeys(String groupName) throws RemoteException {
        return this.remote.getGroupKeys(this.cacheName, groupName);
    }

    private Serializable sanitized(Serializable s) throws IOException {
        return s;
    }

    public boolean remove(Serializable key) throws IOException {
        if (!this.irca.getGetOnly()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove> key=" + key));
            }
            try {
                this.remote.remove(this.cacheName, this.sanitized(key), this.getListenerId());
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to remove " + key + " from " + this.cacheName);
            }
        }
        return false;
    }

    public void removeAll() throws IOException {
        if (!this.irca.getGetOnly()) {
            try {
                this.remote.removeAll(this.cacheName, this.getListenerId());
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to remove all from " + this.cacheName);
            }
        }
    }

    public void dispose() throws IOException {
        log.debug((Object)"disposing of remote cache");
        try {
            this.remote.dispose(this.cacheName);
        }
        catch (Exception ex) {
            log.error((Object)"couldn't dispose");
            this.handleException(ex, "Failed to dispose " + this.cacheName);
        }
    }

    public int getStatus() {
        return this.remote instanceof IZombie ? 3 : 1;
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache No Wait");
        ArrayList<StatElement> elems = new ArrayList<StatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("UsePoolForGet");
        se.setData("" + this.usePoolForGet);
        elems.add(se);
        if (this.pool != null) {
            se = new StatElement();
            se.setName("Pool Size");
            se.setData("" + this.pool.getPool().getPoolSize());
            elems.add(se);
            se = new StatElement();
            se.setName("Maximum Pool Size");
            se.setData("" + this.pool.getPool().getMaximumPoolSize());
            elems.add(se);
        }
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    public int getSize() {
        return 0;
    }

    public int getCacheType() {
        return 4;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void fixCache(IRemoteCacheService remote) {
        this.remote = remote;
    }

    private void handleException(Exception ex, String msg) throws IOException {
        log.error((Object)("Disabling remote cache due to error " + msg));
        log.error((Object)ex.toString());
        this.remote = new ZombieRemoteCacheService();
        RemoteCacheMonitor.getInstance().notifyError();
        RemoteCacheNoWaitFacade rcnwf = (RemoteCacheNoWaitFacade)RemoteCacheFactory.getFacades().get(this.irca.getCacheName());
        log.debug((Object)("Initiating failover, rcnf = " + rcnwf));
        if (rcnwf != null && rcnwf.rca.getRemoteType() == 0) {
            log.debug((Object)"found facade, calling failover");
            rcnwf.failover(0);
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        throw new IOException(ex.getMessage());
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.irca;
    }

    public void setListenerId(long id) {
        try {
            this.listener.setListenerId(id);
            if (log.isDebugEnabled()) {
                log.debug((Object)("set listenerId = " + id));
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem setting listenerId", (Throwable)e);
        }
    }

    public long getListenerId() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("get listenerId = " + this.listener.getListenerId()));
            }
            return this.listener.getListenerId();
        }
        catch (Exception e) {
            log.error((Object)"Problem setting listenerId", (Throwable)e);
            return -1L;
        }
    }

    protected IRemoteCacheListener getListener() {
        return this.listener;
    }

    public String toString() {
        return "RemoteCache: " + this.cacheName + " attributes = " + this.irca;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

