/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.user;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class UserInformation
extends AbstractSdxObject {
    public static final String CLASS_NAME_SUFFIX = "UserInformation";
    private String appId;
    private String firstname;
    private String lastname;
    private String email;
    private boolean isAdmin;
    private Hashtable groups;
    protected String ip;
    protected String host;
    public static final String SESSION_PROPERTY = "sdxUserInformation";
    public static final String ANONYMOUS_USERNAME = "sdxAnonymous";
    private static final String ATTRIBUTE_NAME_FIRSTNAME = "firstname";
    private static final String ATTRIBUTE_NAME_LASTNAME = "lastname";
    private static final String ATTRIBUTE_NAME_EMAIL = "email";

    public void setUp(String appId, String id, Hashtable groups, Locale locale, String firstname, String lastname, String email, String adminGroup) throws SDXException {
        this.appId = appId;
        super.setId(id);
        this.firstname = firstname;
        this.lastname = lastname;
        this.email = email;
        if (groups != null) {
            this.setGroups(groups);
        } else {
            this.setGroups(new Hashtable());
        }
        this.isAdmin = this.isMember(adminGroup);
        this.setPreferredLocale(locale);
    }

    public Hashtable getGroups() {
        return this.groups;
    }

    public void setGroups(Hashtable groups) throws SDXException {
        if (groups == null) {
            throw new SDXException(super.getLog(), 6002, null, null);
        }
        this.groups = groups;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) throws SDXException {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) throws SDXException {
        this.lastname = lastname;
    }

    public Locale getPreferredLocale() {
        return super.getLocale();
    }

    public void setPreferredLocale(Locale preferredLocale) throws SDXException {
        super.setLocale(preferredLocale);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAppId() {
        return this.appId;
    }

    public boolean isMember(String[] groupnames, boolean all) {
        if (groupnames == null) {
            return false;
        }
        int nbGroups = 0;
        for (int i = 0; i < groupnames.length; ++i) {
            String group = groupnames[i];
            if (group == null) continue;
            if (this.groups.containsKey(group)) {
                ++nbGroups;
                if (all) continue;
                return true;
            }
            if (!all) continue;
            return false;
        }
        return nbGroups > 0;
    }

    public boolean isMember(String[] groupnames) {
        return this.isMember(groupnames, false);
    }

    public boolean isMember(String groupname) {
        if (groupname == null) {
            return false;
        }
        if (this.groups == null) {
            return false;
        }
        return this.groups.containsKey(groupname);
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        String lang;
        AttributesImpl atts = new AttributesImpl();
        if (this.getId() != null) {
            atts.addAttribute("", "id", "id", "CDATA", this.getId());
        }
        if (this.firstname != null) {
            atts.addAttribute("", ATTRIBUTE_NAME_FIRSTNAME, ATTRIBUTE_NAME_FIRSTNAME, "CDATA", this.firstname);
        }
        if (this.lastname != null) {
            atts.addAttribute("", ATTRIBUTE_NAME_LASTNAME, ATTRIBUTE_NAME_LASTNAME, "CDATA", this.lastname);
        }
        if (this.isAdmin) {
            atts.addAttribute("", "admin", "admin", "CDATA", "true");
        }
        if (this.getEmail() != null) {
            atts.addAttribute("", ATTRIBUTE_NAME_EMAIL, ATTRIBUTE_NAME_EMAIL, "CDATA", this.getEmail());
        }
        if (this.appId != null) {
            atts.addAttribute("", "app", "app", "CDATA", this.appId);
        }
        if (this.ip != null) {
            atts.addAttribute("", "ip", "ip", "CDATA", this.ip);
        }
        if (this.host != null) {
            atts.addAttribute("", "host", "host", "CDATA", this.host);
        }
        if (this.isSuperuser()) {
            atts.addAttribute("", "superuser", "superuser", "CDATA", "true");
        }
        if (!"".equals(lang = this.getPreferredLocale().getLanguage()) && !"".equals(this.getPreferredLocale().getCountry())) {
            lang = lang + "-" + this.getPreferredLocale().getCountry();
        }
        if (lang != null && !"".equals(lang)) {
            atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", lang);
        }
        handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "user", "sdx:user", atts);
        if (this.getGroups() != null) {
            Enumeration e = this.getGroups().keys();
            while (e.hasMoreElements()) {
                atts = new AttributesImpl();
                atts.addAttribute("", "id", "id", "CDATA", String.valueOf(e.nextElement()));
                handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "group", "sdx:group", atts);
                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "group", "sdx:group");
            }
        }
        handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "user", "sdx:user");
    }

    public boolean isSuperuser() {
        return false;
    }

    protected String getClassNameSuffix() {
        return CLASS_NAME_SUFFIX;
    }

    protected boolean initToSax() {
        this._xmlizable_objects.put("Application_ID", this.getAppId());
        this._xmlizable_objects.put("ID", this.getId());
        this._xmlizable_objects.put("Encoding", this.getEncoding());
        this._xmlizable_objects.put("XML-Lang", this.getXmlLang());
        this._xmlizable_objects.put("First_Name", this.getFirstname());
        this._xmlizable_objects.put("Last_Name", this.getLastname());
        this._xmlizable_objects.put("Email", this.getEmail());
        this._xmlizable_objects.put("Host", this.getHost());
        this._xmlizable_objects.put("IP", this.getIp());
        this._xmlizable_objects.put("Groups", this.getGroups());
        if (this.getLocale() != null) {
            this._xmlizable_objects.put("Locale", this.getLocale().toString());
        }
        if (this.getPreferredLocale() != null) {
            this._xmlizable_objects.put("Prefered_Locale", this.getPreferredLocale().toString());
        }
        this._xmlizable_objects.put("Is_Admin", String.valueOf(this.isAdmin()));
        this._xmlizable_objects.put("Is_Superuser", String.valueOf(this.isSuperuser()));
        return true;
    }

    protected void initVolatileObjectsToSax() {
        if (this.getLocale() != null) {
            this._xmlizable_objects.put("Locale", this.getLocale().toString());
        }
        if (this.getPreferredLocale() != null) {
            this._xmlizable_objects.put("Prefered_Locale", this.getPreferredLocale().toString());
        }
        this._xmlizable_objects.put("Is_Admin", String.valueOf(this.isAdmin()));
        this._xmlizable_objects.put("Is_Superuser", String.valueOf(this.isSuperuser()));
    }
}

