/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.cron;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.cron.ConfigurableCronJob;
import org.apache.cocoon.components.cron.CronJob;
import org.apache.cocoon.components.cron.DataSourceComponentConnectionProvider;
import org.apache.cocoon.components.cron.JobScheduler;
import org.apache.cocoon.components.cron.JobSchedulerEntry;
import org.apache.cocoon.components.cron.QuartzJobExecutor;
import org.apache.cocoon.components.cron.QuartzJobSchedulerEntry;
import org.apache.cocoon.components.cron.QuartzJobStoreCMT;
import org.apache.cocoon.components.cron.QuartzJobStoreTX;
import org.apache.cocoon.components.thread.RunnableManager;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.impl.jdbcjobstore.InvalidConfigurationException;
import org.quartz.simpl.RAMJobStore;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.utils.ConnectionProvider;
import org.quartz.utils.DBConnectionManager;
import org.quartz.utils.JNDIConnectionProvider;

public class QuartzJobScheduler
extends AbstractLogEnabled
implements JobScheduler,
Component,
ThreadSafe,
Serviceable,
Configurable,
Startable,
Disposable,
Contextualizable,
Initializable {
    static final String DATA_MAP_ROLE = "QuartzJobScheduler.ROLE";
    static final String DATA_MAP_OBJECT = "QuartzJobScheduler.Object";
    static final String DATA_MAP_NAME = "QuartzJobScheduler.JobName";
    static final String DATA_MAP_CONTEXT = "QuartzJobScheduler.Context";
    static final String DATA_MAP_MANAGER = "QuartzJobScheduler.ServiceManager";
    static final String DATA_MAP_LOGGER = "QuartzJobScheduler.Logger";
    static final String DATA_MAP_RUN_CONCURRENT = "QuartzJobScheduler.RunConcurrently";
    static final String DATA_MAP_PARAMETERS = "QuartzJobScheduler.Parameters";
    static final String DATA_MAP_OBJECTMAP = "QuartzJobScheduler.Map";
    static final String DATA_MAP_KEY_ISRUNNING = "QuartzJobExecutor.isRunning";
    static final String DEFAULT_QUARTZ_JOB_GROUP = "Cocoon";
    static final String DEFAULT_QUARTZ_SCHEDULER_NAME = "Cocoon";
    private Context context;
    private org.apache.cocoon.components.thread.ThreadPool executor;
    private Scheduler scheduler;
    private ServiceManager manager;
    private Configuration config;
    private boolean m_shutdownGraceful;

    public String[] getJobNames() {
        try {
            Object[] names = this.scheduler.getJobNames("Cocoon");
            Arrays.sort(names);
            return names;
        }
        catch (SchedulerException se) {
            this.getLogger().error("could not gather job names", (Throwable)se);
            return new String[0];
        }
    }

    public JobSchedulerEntry getJobSchedulerEntry(String jobname) {
        try {
            return new QuartzJobSchedulerEntry(jobname, this.scheduler);
        }
        catch (Exception e) {
            this.getLogger().error("cannot create QuartzJobSchedulerEntry", (Throwable)e);
            return null;
        }
    }

    public void addJob(String name, Object job, String cronSpec, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)DATA_MAP_OBJECT, job);
        this.addJob(name, jobDataMap, cronSpec, canRunConcurrently, params, objects);
    }

    public void addJob(String name, String jobrole, String cronSpec, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(DATA_MAP_ROLE, jobrole);
        this.addJob(name, jobDataMap, cronSpec, canRunConcurrently, params, objects);
    }

    public void addJob(String name, Object job, String cronSpec, boolean canRunConcurrently) throws CascadingException {
        if (!(job instanceof CronJob || job instanceof Runnable || job instanceof Job)) {
            throw new CascadingException("Job object is neither an instance of " + CronJob.class.getName() + "," + Runnable.class.getName() + " nor " + Job.class.getName());
        }
        this.addJob(name, job, cronSpec, canRunConcurrently, null, null);
    }

    public void addJob(String name, String jobrole, String cronSpec, boolean canRunConcurrently) throws CascadingException {
        this.addJob(name, jobrole, cronSpec, canRunConcurrently, null, null);
    }

    public void addPeriodicJob(String name, String jobrole, long period, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(DATA_MAP_ROLE, jobrole);
        long ms = period * 1000L;
        SimpleTrigger timeEntry = new SimpleTrigger(name, "Cocoon", new Date(System.currentTimeMillis() + ms), null, SimpleTrigger.REPEAT_INDEFINITELY, ms);
        this.addJob(name, jobDataMap, (Trigger)timeEntry, canRunConcurrently, params, objects);
    }

    public void addPeriodicJob(String name, Object job, long period, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        if (!(job instanceof CronJob || job instanceof Runnable || job instanceof Job)) {
            throw new CascadingException("Job object is neither an instance of " + CronJob.class.getName() + "," + Runnable.class.getName() + " nor " + Job.class.getName());
        }
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)DATA_MAP_OBJECT, job);
        long ms = period * 1000L;
        SimpleTrigger timeEntry = new SimpleTrigger(name, "Cocoon", new Date(System.currentTimeMillis() + ms), null, SimpleTrigger.REPEAT_INDEFINITELY, ms);
        this.addJob(name, jobDataMap, (Trigger)timeEntry, canRunConcurrently, params, objects);
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.config = config;
    }

    public void dispose() {
        try {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("shutting down scheduler " + (this.m_shutdownGraceful ? "graceful (waiting for running jobs to complete)" : "immediately (killing running jobs)"));
            }
            this.scheduler.shutdown(this.m_shutdownGraceful);
            this.scheduler = null;
        }
        catch (SchedulerException se) {
            this.getLogger().error("failure during scheduler shutdown", (Throwable)se);
        }
        this.executor = null;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void initialize() throws Exception {
        try {
            String runID = new Date().toString().replace(' ', '_');
            QuartzThreadPool pool = this.createThreadPool(this.config.getChild("thread-pool"));
            JobStore store = this.createJobStore("Cocoon", runID, this.config.getChild("store"));
            DirectSchedulerFactory.getInstance().createScheduler("Cocoon", runID, (ThreadPool)pool, store);
            this.scheduler = DirectSchedulerFactory.getInstance().getScheduler("Cocoon");
        }
        catch (SchedulerException se) {
            throw new ConfigurationException("cannot create a quartz scheduler", (Throwable)se);
        }
        Configuration[] triggers = this.config.getChild("triggers").getChildren("trigger");
        this.createTriggers(triggers);
        this.config = null;
        if (this.getLogger().isDebugEnabled() && triggers.length == 0) {
            this.getLogger().debug("no triggers configured at startup");
        }
    }

    public boolean fireJob(Object job) {
        return this.fireJob(job.getClass().getName(), job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireJob(String jobrole) {
        Object job = null;
        try {
            job = this.manager.lookup(jobrole);
            boolean bl = this.fireJob(jobrole, job);
            return bl;
        }
        catch (ServiceException se) {
            this.getLogger().error("cannot fire job " + jobrole, (Throwable)se);
        }
        finally {
            this.manager.release(job);
        }
        return false;
    }

    public boolean fireJob(Object job, Parameters params, Map objects) throws CascadingException {
        if (job instanceof ConfigurableCronJob) {
            ((ConfigurableCronJob)job).setup(params, objects);
        }
        return this.fireJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireJob(String jobrole, Parameters params, Map objects) throws CascadingException {
        Object job = null;
        try {
            job = this.manager.lookup(jobrole);
            if (job instanceof ConfigurableCronJob) {
                ((ConfigurableCronJob)job).setup(params, objects);
            }
            boolean bl = this.fireJob(jobrole, job);
            return bl;
        }
        catch (ServiceException se) {
            this.getLogger().error("cannot fire job " + jobrole, (Throwable)se);
        }
        finally {
            this.manager.release(job);
        }
        return false;
    }

    public void fireJobAt(Date date, String name, Object job) throws CascadingException {
        this.fireJobAt(date, name, job, null, null);
    }

    public void fireJobAt(Date date, String name, String jobrole) throws CascadingException {
        this.fireJobAt(date, name, jobrole, null, null);
    }

    public void fireJobAt(Date date, String name, Object job, Parameters params, Map objects) throws CascadingException {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)DATA_MAP_OBJECT, job);
        this.addJob(name, jobDataMap, date, true, params, objects);
    }

    public void fireJobAt(Date date, String name, String jobrole, Parameters params, Map objects) throws CascadingException {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(DATA_MAP_ROLE, jobrole);
        this.addJob(name, jobDataMap, date, true, params, objects);
    }

    public void removeJob(String name) throws NoSuchElementException {
        try {
            if (this.scheduler.deleteJob(name, "Cocoon")) {
                this.getLogger().info("job " + name + " removed by request");
            } else {
                this.getLogger().error("couldn't remove requested job " + name);
            }
        }
        catch (SchedulerException se) {
            this.getLogger().error("cannot remove job " + name, (Throwable)se);
            throw new NoSuchElementException(se.getMessage());
        }
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void start() throws Exception {
        this.scheduler.start();
    }

    public void stop() throws Exception {
        this.scheduler.standby();
    }

    private void addJob(String name, JobDataMap jobDataMap, Date date, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        SimpleTrigger trigger = new SimpleTrigger(name, "Cocoon", date);
        this.addJob(name, jobDataMap, (Trigger)trigger, canRunConcurrently, params, objects);
    }

    private void addJob(String name, JobDataMap jobDataMap, String cronSpec, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        CronTrigger cronJobEntry = new CronTrigger(name, "Cocoon");
        try {
            cronJobEntry.setCronExpression(cronSpec);
        }
        catch (ParseException pe) {
            throw new CascadingException(pe.getMessage(), (Throwable)pe);
        }
        this.addJob(name, jobDataMap, (Trigger)cronJobEntry, canRunConcurrently, params, objects);
    }

    private void addJob(String name, JobDataMap jobDataMap, Trigger trigger, boolean canRunConcurrently, Parameters params, Map objects) throws CascadingException {
        try {
            JobDetail jobdetail = this.scheduler.getJobDetail(name, "Cocoon");
            if (jobdetail != null) {
                this.removeJob(name);
            }
        }
        catch (SchedulerException ignored) {
            // empty catch block
        }
        this.initDataMap(jobDataMap, name, canRunConcurrently, params, objects);
        JobDetail detail = this.createJobDetail(name, jobDataMap);
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Adding CronJob '" + trigger.getFullName() + "'");
        }
        try {
            this.scheduler.scheduleJob(detail, trigger);
        }
        catch (SchedulerException se) {
            throw new CascadingException(se.getMessage(), (Throwable)se);
        }
        if (this.getLogger().isDebugEnabled()) {
            if (trigger instanceof CronTrigger) {
                this.getLogger().debug("Time schedule summary:\n" + ((CronTrigger)trigger).getExpressionSummary());
            } else {
                this.getLogger().debug("Next scheduled time: " + trigger.getNextFireTime());
            }
        }
    }

    protected JobDataMap initDataMap(JobDataMap jobDataMap, String jobName, boolean concurent, Parameters params, Map objects) {
        jobDataMap.put(DATA_MAP_NAME, jobName);
        jobDataMap.put((Object)DATA_MAP_LOGGER, (Object)this.getLogger());
        jobDataMap.put((Object)DATA_MAP_CONTEXT, (Object)this.context);
        jobDataMap.put((Object)DATA_MAP_MANAGER, (Object)this.manager);
        jobDataMap.put((Object)DATA_MAP_RUN_CONCURRENT, (Object)(concurent ? Boolean.TRUE : Boolean.FALSE));
        if (null != params) {
            jobDataMap.put((Object)DATA_MAP_PARAMETERS, (Object)params);
        }
        if (null != objects) {
            jobDataMap.put((Object)DATA_MAP_OBJECTMAP, (Object)objects);
        }
        return jobDataMap;
    }

    protected JobDetail createJobDetail(String name, JobDataMap jobDataMap) {
        JobDetail detail = new JobDetail(name, "Cocoon", QuartzJobExecutor.class);
        detail.setJobDataMap(jobDataMap);
        return detail;
    }

    private QuartzThreadPool createThreadPool(Configuration poolConfig) throws ServiceException {
        int queueSize = poolConfig.getChild("queue-size").getValueAsInteger(-1);
        int maxPoolSize = poolConfig.getChild("max-pool-size").getValueAsInteger(-1);
        int minPoolSize = poolConfig.getChild("min-pool-size").getValueAsInteger(-1);
        int keepAliveTimeMs = poolConfig.getChild("keep-alive-time-ms").getValueAsInteger(-1);
        String blockPolicy = poolConfig.getChild("block-policy").getValue(null);
        this.m_shutdownGraceful = poolConfig.getChild("shutdown-graceful").getValueAsBoolean(true);
        int shutdownWaitTimeMs = poolConfig.getChild("shutdown-wait-time-ms").getValueAsInteger(-1);
        RunnableManager runnableManager = (RunnableManager)this.manager.lookup(RunnableManager.ROLE);
        this.executor = runnableManager.createPool(queueSize, maxPoolSize, minPoolSize, 5, false, (long)keepAliveTimeMs, blockPolicy, this.m_shutdownGraceful, shutdownWaitTimeMs);
        QuartzThreadPool pool = new QuartzThreadPool(this.executor);
        return pool;
    }

    private void createTriggers(Configuration[] triggers) throws ConfigurationException {
        for (int i = 0; i < triggers.length; ++i) {
            String cron = triggers[i].getChild("cron").getValue(null);
            if (null == cron) {
                String seconds = triggers[i].getChild("seconds").getValue("0");
                String minutes = triggers[i].getChild("minutes").getValue("*");
                String hours = triggers[i].getChild("hours").getValue("*");
                String days = triggers[i].getChild("days").getValue("*");
                String months = triggers[i].getChild("months").getValue("*");
                String weekdays = triggers[i].getChild("weekdays").getValue("?");
                String years = triggers[i].getChild("years").getValue("*");
                cron = seconds + " " + minutes + " " + hours + " " + days + " " + months + " " + weekdays + " " + years;
            }
            try {
                this.addJob(triggers[i].getAttribute("name"), triggers[i].getAttribute("target"), cron, triggers[i].getAttributeAsBoolean("concurrent-runs", true));
                continue;
            }
            catch (CascadingException ce) {
                throw new ConfigurationException("failed adding trigger to scheduler", (Throwable)ce);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private JobStore createJobStore(String instanceName, String instanceID, Configuration configuration) throws ConfigurationException {
        void var9_9;
        Object provider;
        String type = configuration.getAttribute("type", "ram");
        if (type.equals("ram")) {
            return new RAMJobStore();
        }
        Object store = null;
        if (type.equals("tx")) {
            store = new QuartzJobStoreTX(this.getLogger(), this.manager, this.context);
        } else if (type.equals("cmt")) {
            store = new QuartzJobStoreCMT(this.getLogger(), this.manager, this.context);
        } else {
            throw new ConfigurationException("Unknown store type: " + type);
        }
        Configuration dsConfig = configuration.getChild("datasource", false);
        if (dsConfig == null) {
            throw new ConfigurationException("Store " + type + " requires datasource configuration.");
        }
        String dsName = dsConfig.getValue();
        String dsType = dsConfig.getAttribute("provider", "jndi");
        if (dsType.equals("jndi")) {
            provider = new JNDIConnectionProvider(dsName, false);
        } else if (dsType.equals("excalibur")) {
            provider = new DataSourceComponentConnectionProvider(dsName, this.manager);
        } else {
            try {
                provider = (ConnectionProvider)Class.forName(dsType).newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException("Could not instantiate ConnectionProvider class " + dsType);
            }
        }
        store.setInstanceName(instanceName);
        store.setInstanceId(instanceID);
        store.setDataSource(dsType + ":" + dsName);
        DBConnectionManager.getInstance().addConnectionProvider(dsType + ":" + dsName, (ConnectionProvider)var9_9);
        String delegate = configuration.getAttribute("delegate", null);
        try {
            if (delegate != null) {
                store.setDriverDelegateClass(delegate);
            }
        }
        catch (InvalidConfigurationException e) {
            throw new ConfigurationException("Could not instantiate DriverDelegate class " + delegate, (Throwable)e);
        }
        return store;
    }

    private boolean fireJob(String name, final Object job) {
        try {
            if (job instanceof CronJob || job instanceof Job) {
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.put((Object)DATA_MAP_OBJECT, job);
                this.initDataMap(jobDataMap, name, true, null, null);
                JobDetail detail = this.createJobDetail(name, jobDataMap);
                SimpleTrigger trigger = new SimpleTrigger(name, "Cocoon");
                TriggerFiredBundle fireBundle = new TriggerFiredBundle(detail, (Trigger)trigger, null, false, null, null, null, null);
                final Job executor = this.createJobExecutor();
                final JobExecutionContext context = new JobExecutionContext(this.scheduler, fireBundle, executor);
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            executor.execute(context);
                        }
                        catch (JobExecutionException e) {
                            QuartzJobScheduler.this.getLogger().error("Job '" + job + "' died.", (Throwable)e);
                        }
                    }
                });
            } else if (job instanceof Runnable) {
                this.executor.execute((Runnable)job);
            } else {
                this.getLogger().error("Job named '" + name + "' is of invalid class: " + job.getClass().getName());
                return false;
            }
            return true;
        }
        catch (InterruptedException ie) {
            this.getLogger().error("job " + name + " interrupted", (Throwable)ie);
            return false;
        }
    }

    protected Job createJobExecutor() {
        return new QuartzJobExecutor();
    }

    private static class QuartzThreadPool
    extends AbstractLogEnabled
    implements ThreadPool {
        private org.apache.cocoon.components.thread.ThreadPool executor;

        public QuartzThreadPool(org.apache.cocoon.components.thread.ThreadPool executor) {
            this.executor = executor;
        }

        public int getPoolSize() {
            return this.executor.getMaximumPoolSize();
        }

        public void initialize() {
        }

        public boolean runInThread(Runnable job) {
            try {
                this.executor.execute(job);
            }
            catch (InterruptedException ie) {
                this.getLogger().error("Cronjob failed", (Throwable)ie);
            }
            return true;
        }

        public void shutdown(boolean waitForJobsToComplete) {
            this.executor.shutdown();
        }
    }
}

