/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.reading;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.reading.AbstractReader;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.xml.sax.SAXException;

public class DirectoryZipArchiver
extends AbstractReader {
    private Source inputSource;
    private File directory;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            this.inputSource = this.resolver.resolveURI(this.source);
        }
        catch (SourceException se) {
            throw new ProcessingException("Could not retrieve source '" + this.source + "'", (Throwable)se);
        }
        String systemId = this.inputSource.getURI();
        if (!systemId.startsWith("file:")) {
            throw new ResourceNotFoundException(systemId + " does not denote a directory");
        }
        this.directory = new File(new URL(systemId).getFile());
        if (!this.directory.isDirectory()) {
            throw new ResourceNotFoundException(this.directory + " is not a directory.");
        }
    }

    public void generate() throws IOException, ProcessingException {
        File[] files = this.directory.listFiles();
        ZipOutputStream zip = new ZipOutputStream(this.out);
        zip.setLevel(0);
        int i = 0;
        while (i < files.length) {
            if (!files[i].isDirectory()) {
                ZipEntry entry = new ZipEntry(files[i].getName());
                zip.putNextEntry(entry);
                this.read(files[i], zip);
                zip.closeEntry();
            }
            ++i;
        }
        zip.finish();
        zip.flush();
    }

    public String getMimeType() {
        return "application/zip";
    }

    protected void read(File file, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(file);
        byte[] buffer = new byte[8192];
        int length = -1;
        while ((length = ((InputStream)in).read(buffer)) > -1) {
            out.write(buffer, 0, length);
        }
        ((InputStream)in).close();
    }
}

