/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils;

import fr.gouv.culture.sdx.utils.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXUtils {
    public static String prefixNodeName(String prefix, String elemName) {
        if (!Utilities.checkString(elemName)) {
            return null;
        }
        String qualifiedElementName = "";
        if (Utilities.checkString(prefix)) {
            qualifiedElementName = qualifiedElementName + prefix + ":";
        }
        qualifiedElementName = qualifiedElementName + elemName;
        return qualifiedElementName;
    }

    public static void sendElement(ContentHandler handler, String uri, String localName, String qName, Attributes atts, String elemContent) throws SAXException {
        if (atts == null) {
            atts = new AttributesImpl();
        }
        handler.startElement(uri, localName, qName, atts);
        SAXUtils.sendElementContent(handler, elemContent);
        handler.endElement(uri, localName, qName);
    }

    public static void sendElementContent(ContentHandler handler, String content) throws SAXException {
        if (Utilities.checkString(content)) {
            char[] chars = content.toCharArray();
            handler.characters(chars, 0, chars.length);
        }
    }
}

