/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.analysis.filter;

import java.io.IOException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizerConstants;

public class FrenchStandardFilter
extends TokenFilter
implements StandardTokenizerConstants,
LogEnabled {
    private Logger logger;
    private static final String APOSTROPHE_TYPE = tokenImage[2];
    private static final String ACRONYM_TYPE = tokenImage[3];

    public void setUp(TokenStream in) {
        this.input = in;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public Token next() throws IOException {
        Token t = this.input.next();
        if (t == null) {
            return null;
        }
        String text = t.termText();
        String type = t.type();
        if (type == APOSTROPHE_TYPE) {
            int idx = text.indexOf("'");
            if (idx < 2) {
                if (text.length() > idx + 3) {
                    return new Token(text.substring(idx + 1), t.startOffset(), t.endOffset(), type);
                }
                return t;
            }
            return t;
        }
        if (type == ACRONYM_TYPE) {
            StringBuffer trimmed = new StringBuffer();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '.') continue;
                trimmed.append(c);
            }
            return new Token(trimmed.toString(), t.startOffset(), t.endOffset(), type);
        }
        return t;
    }
}

