/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.analysis;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.FieldList;
import fr.gouv.culture.sdx.search.lucene.analysis.AbstractAnalyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;

public class MetaAnalyzer
extends AbstractAnalyzer {
    protected static final String ANALYZER_TYPE = "MetaAnalyzer";
    private FieldList fields;
    private Analyzer defaultAnalyzer;

    protected String getAnalyzerType() {
        return ANALYZER_TYPE;
    }

    public void setUp(FieldList fields) throws SDXException {
        if (fields == null) {
            throw new SDXException(this.logger, 4300, null, null);
        }
        this.fields = fields;
        this.defaultAnalyzer = fields.getAnalyzer();
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        if (fieldName == null) {
            return this.defaultAnalyzer.tokenStream(fieldName, reader);
        }
        Field f = this.fields.getField(fieldName);
        if (f == null) {
            return this.defaultAnalyzer.tokenStream(fieldName, reader);
        }
        Analyzer theAnalyzer = f.getAnalyzer();
        if (theAnalyzer == null) {
            return this.defaultAnalyzer.tokenStream(fieldName, reader);
        }
        return theAnalyzer.tokenStream(fieldName, reader);
    }

    public FieldList getFieldList() {
        return this.fields;
    }
}

