/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.AbstractRepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;

public class LuceneRepositoryConnection
extends AbstractRepositoryConnection {
    private String indexPath = null;
    private final StandardAnalyzer analyzer = new StandardAnalyzer();

    public void setUp(String indexPath) {
        this.indexPath = indexPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void optimize() throws SDXException {
        if (!Utilities.checkString(this.indexPath)) return;
        if (this.analyzer == null) return;
        IndexWriter w = null;
        try {
            w = new IndexWriter(this.indexPath, (Analyzer)this.analyzer, false);
            w.optimize();
            if (w == null) return;
        }
        catch (IOException e) {
            try {
                String[] args = new String[]{this.indexPath};
                throw new SDXException(super.getLog(), 223, args, e);
            }
            catch (Throwable throwable) {
                if (w == null) throw throwable;
                try {
                    w.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    String[] args = new String[]{this.indexPath};
                    throw new SDXException(super.getLog(), 223, args, e2);
                }
            }
        }
        try {
            w.close();
            return;
        }
        catch (IOException e) {
            String[] args = new String[]{this.indexPath};
            throw new SDXException(super.getLog(), 223, args, e);
        }
    }
}

