/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.exception.SDXException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.excalibur.source.impl.AbstractSource;
import org.apache.cocoon.components.source.SourceUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import java.io.IOException;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 18 mars 2004
 * Time: 19:15:38
 * To change this template use Options | File Templates.
 */
public class ParsableDocumentSource extends AbstractSource {

	protected ParsableDocument _parsableDocument = null;

	public ParsableDocumentSource(ServiceManager manager, ParsableDocument document) {
		_parsableDocument = document;
	}

/*
	public InputStream getInputStream()
			throws ProcessingException, IOException {
		return null;
	}
*/
	public InputSource getInputSource() throws IOException, ProcessingException {
		try {
			return ((AbstractDocument) _parsableDocument).getInputSource();
		} catch (SDXException e) {
			throw new ProcessingException(e);
		}
	}

	public String getSystemId() {
		try {
			return _parsableDocument.getURL().toExternalForm();
		} catch (SDXException e) {
			return null;
		}
	}

	/**
	 * Stream content to a content handler or to an XMLConsumer.
	 *
	 * @throws org.apache.cocoon.ResourceNotFoundException if file not found or
	 *         HTTP location does not exist.
	 * @throws org.xml.sax.SAXException if failed to parse source document.
	 */
	public void toSAX(ContentHandler handler) throws SAXException, ProcessingException {
		try {
			SourceUtil.toSAX(this,handler);
		} catch (IOException e) {
			throw new SAXException(e.getMessage(),e); 
		}
//		SAXParser parser = null;
//		ServiceManager l_manager = super.manager;
//
//		try {
//			parser = (SAXParser) l_manager.lookup(SAXParser.ROLE);
//			_parsableDocument.parse(parser, new ContentHandlerWrapper(handler));
//		} catch (Exception e) {
//			throw new ProcessingException("Exception during processing of "
//					+ this.getSystemId(), e);
//		} finally {
//			if (parser != null) l_manager.release(parser);
//		}
	}

	/**
	 * @see org.apache.excalibur.source.Source#exists()
	 */
	public boolean exists() {
		// TODO Auto-generated method stub
		return false;
	}

}
