/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.hsql;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.jcs.auxiliary.disk.hsql.HSQLCacheAttributes;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.utils.data.PropertyGroups;
import org.hsqldb.jdbcDriver;

public class HSQLCache
extends AbstractDiskCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$hsql$HSQLCache == null ? (class$org$apache$jcs$auxiliary$disk$hsql$HSQLCache = HSQLCache.class$("org.apache.jcs.auxiliary.disk.hsql.HSQLCache")) : class$org$apache$jcs$auxiliary$disk$hsql$HSQLCache));
    private int numInstances = 0;
    public boolean isAlive = false;
    HSQLCacheAttributes cattr;
    Connection cConn;
    Statement sStatement;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$hsql$HSQLCache;

    public HSQLCache(HSQLCacheAttributes cattr) {
        super(cattr.getCacheName());
        this.cattr = cattr;
        String rafroot = cattr.getDiskPath();
        ++this.numInstances;
        if (rafroot == null) {
            try {
                PropertyGroups pg = new PropertyGroups("/cache.properties");
                rafroot = pg.getProperty("diskPath");
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        try {
            Properties p = new Properties();
            String driver = p.getProperty("driver", "org.hsqldb.jdbcDriver");
            String url = p.getProperty("url", "jdbc:hsqldb:");
            String database = p.getProperty("database", "cache_hsql_db");
            String user = p.getProperty("user", "sa");
            String password = p.getProperty("password", "");
            boolean test = p.getProperty("test", "true").equalsIgnoreCase("true");
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("driver  =" + driver + ", url = " + url + ", database = " + database + ", user = " + user + ", password = " + password + ", test = " + test));
                }
                new jdbcDriver();
                Class.forName(driver).newInstance();
                this.cConn = DriverManager.getConnection(url + database, user, password);
                try {
                    this.sStatement = this.cConn.createStatement();
                    this.isAlive = true;
                }
                catch (SQLException e) {
                    System.out.println("Exception: " + e);
                    this.isAlive = false;
                }
                this.setupTABLE();
            }
            catch (Exception e) {
                log.error((Object)"QueryTool.init", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    void setupTABLE() {
        boolean newT = true;
        String setup = "create table " + this.cacheName + " (KEY varchar(255) primary key, ELEMENT binary)";
        try {
            this.sStatement.executeQuery(setup);
        }
        catch (SQLException e) {
            if (e.toString().indexOf("already exists") != -1) {
                newT = false;
            }
            log.error((Object)e);
        }
        String[] setupData = new String[]{"create index iKEY on " + this.cacheName + " (KEY)"};
        if (newT) {
            int i = 1;
            while (i < setupData.length) {
                try {
                    this.sStatement.executeQuery(setupData[i]);
                }
                catch (SQLException e) {
                    System.out.println("Exception: " + e);
                }
                ++i;
            }
        }
    }

    public void doUpdate(ICacheElement ce) {
        block14: {
            byte[] element;
            log.debug((Object)"update");
            if (!this.isAlive) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Putting " + ce.getKey() + " on disk."));
            }
            try {
                element = HSQLCache.serialize(ce);
            }
            catch (IOException e) {
                log.error((Object)"Could not serialize element", (Throwable)e);
                return;
            }
            boolean exists = false;
            try {
                String sqlS = "SELECT element FROM " + this.cacheName + " WHERE key = '" + (String)((Object)ce.getKey()) + "'";
                ResultSet rs = this.sStatement.executeQuery(sqlS);
                if (rs.next()) {
                    exists = true;
                }
                rs.close();
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
            if (!exists) {
                try {
                    String sqlI = "insert into " + this.cacheName + " (KEY, ELEMENT) values (?, ? )";
                    PreparedStatement psInsert = this.cConn.prepareStatement(sqlI);
                    psInsert.setString(1, (String)((Object)ce.getKey()));
                    psInsert.setBytes(2, element);
                    psInsert.execute();
                    psInsert.close();
                }
                catch (SQLException e) {
                    if (e.toString().indexOf("Violation of unique index") != -1 || e.getMessage().indexOf("Violation of unique index") != -1) {
                        exists = true;
                        break block14;
                    }
                    log.error((Object)"Could not insert element", (Throwable)e);
                }
            } else {
                try {
                    String sqlU = "update " + this.cacheName + " set ELEMENT  = ? ";
                    PreparedStatement psUpdate = this.cConn.prepareStatement(sqlU);
                    psUpdate.setBytes(1, element);
                    psUpdate.setString(2, (String)((Object)ce.getKey()));
                    psUpdate.execute();
                    psUpdate.close();
                    log.debug((Object)"ran update");
                }
                catch (SQLException e2) {
                    log.error((Object)("e2 Exception: " + e2));
                }
            }
        }
    }

    public ICacheElement doGet(Serializable key) {
        ICacheElement obj;
        block10: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getting " + key + " from disk"));
            }
            if (!this.isAlive) {
                return null;
            }
            obj = null;
            byte[] data = null;
            try {
                String sqlS = "select ELEMENT from " + this.cacheName + " where KEY = ?";
                PreparedStatement psSelect = this.cConn.prepareStatement(sqlS);
                psSelect.setString(1, (String)((Object)key));
                ResultSet rs = psSelect.executeQuery();
                if (rs.next()) {
                    data = rs.getBytes(1);
                }
                if (data == null) break block10;
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    BufferedInputStream bis = new BufferedInputStream(bais);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    try {
                        obj = (ICacheElement)ois.readObject();
                        Object var11_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        ois.close();
                        throw throwable;
                    }
                    ois.close();
                    rs.close();
                    psSelect.close();
                }
                catch (IOException ioe) {
                    log.error((Object)ioe);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            catch (SQLException sqle) {
                log.error((Object)sqle);
            }
        }
        return obj;
    }

    public boolean doRemove(Serializable key) {
        String sql = "delete from " + this.cacheName + " where KEY = '" + key + "'";
        try {
            if (key instanceof String && key.toString().endsWith(":")) {
                sql = "delete from " + this.cacheName + " where KEY = like '" + key + "%'";
            }
            try {
                this.sStatement.executeQuery(sql);
            }
            catch (SQLException e) {
                log.error((Object)e);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            this.reset();
        }
        return false;
    }

    public void doRemoveAll() {
    }

    public void reset() {
    }

    public void doDispose() {
    }

    public int getSize() {
        return 0;
    }

    static byte[] serialize(Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(obj);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            oos.close();
            throw throwable;
        }
        oos.close();
        return baos.toByteArray();
    }

    public Set getGroupKeys(String groupName) {
        throw new UnsupportedOperationException("Groups not implemented.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

