/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ErrorHandlerHelper;
import org.apache.cocoon.environment.Environment;

public class PipelineNode
extends AbstractParentProcessingNode
implements Composable,
ParameterizableProcessingNode {
    private ProcessingNode[] children;
    private ProcessingNode error404;
    private ProcessingNode error500;
    private ErrorHandlerHelper errorHandlerHelper = new ErrorHandlerHelper();
    protected Logger handledErrorsLogger;
    private boolean internalOnly = false;
    private boolean isLast = false;
    protected String processingPipeline;
    protected Map parameters;

    public PipelineNode(String name) {
        this.processingPipeline = name;
    }

    public void compose(ComponentManager manager) {
        this.errorHandlerHelper.compose(manager);
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.errorHandlerHelper.enableLogging(logger);
        this.handledErrorsLogger = logger.getChildLogger("handled-errors");
    }

    public void setChildren(ProcessingNode[] nodes) {
        this.children = nodes;
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public void setLast(boolean isLast) {
        this.isLast = isLast;
    }

    public void set404Handler(ProcessingNode node) {
        this.error404 = node;
    }

    public void set500Handler(ProcessingNode node) {
        this.error500 = node;
    }

    public void setInternalOnly(boolean internalOnly) {
        this.internalOnly = internalOnly;
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        boolean externalRequest = env.isExternal();
        if (this.internalOnly && externalRequest) {
            return false;
        }
        context.inform(this.processingPipeline, this.parameters, env.getObjectModel());
        try {
            if (this.invokeNodes(this.children, env, context)) {
                return true;
            }
            if (!this.isLast) {
                return false;
            }
            throw new ResourceNotFoundException("No pipeline matched request: " + env.getURIPrefix() + env.getURI());
        }
        catch (ConnectionResetException cre) {
            throw cre;
        }
        catch (Exception ex) {
            if (!externalRequest && !env.isInternalRedirect()) {
                throw ex;
            }
            if (this.error404 != null && ex instanceof ResourceNotFoundException) {
                this.handledErrorsLogger.error(ex.getMessage(), (Throwable)ex);
                return this.errorHandlerHelper.invokeErrorHandler(this.error404, ex, env);
            }
            if (this.error500 != null) {
                this.handledErrorsLogger.error(ex.getMessage(), (Throwable)ex);
                return this.errorHandlerHelper.invokeErrorHandler(this.error500, ex, env);
            }
            throw ex;
        }
    }
}

