/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.util.apache.avalon.excalibur.concurrent;

import org.apache.avalon.excalibur.concurrent.Sync;

public class Semaphore
implements Sync {
    private long max_tokens;
    private long m_tokens;

    public Semaphore(long tokens) {
        this.m_tokens = this.max_tokens = tokens;
    }

    public synchronized void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        while (0L >= this.m_tokens) {
            this.wait();
        }
        --this.m_tokens;
    }

    public synchronized void release() {
        if (this.m_tokens < this.max_tokens) {
            ++this.m_tokens;
            this.notifyAll();
        }
    }

    public synchronized boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.m_tokens > 0L) {
            --this.m_tokens;
            return true;
        }
        long start = System.currentTimeMillis();
        long wait = msecs;
        while (wait > 0L) {
            this.wait(wait);
            if (this.m_tokens > 0L) {
                --this.m_tokens;
                return true;
            }
            wait = msecs - (System.currentTimeMillis() - start);
        }
        return false;
    }

    public long getTokens() {
        return this.m_tokens;
    }
}

