/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler;

import fr.gouv.culture.sdx.utils.SdxObjectImpl;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.Target;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.TimeScheduler;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.TimeTrigger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class SimpleTimeScheduler
extends SdxObjectImpl
implements TimeScheduler {
    protected Hashtable triggers = new Hashtable();
    protected Hashtable targets = new Hashtable();

    public void addTrigger(String name, TimeTrigger trigger, Target target) {
        if (Utilities.checkString(name) && trigger != null && target != null) {
            this.triggers.put(name, trigger);
            this.targets.put(name, target);
        }
    }

    public void removeTrigger(String name) throws NoSuchElementException {
        if (Utilities.checkString(name)) {
            this.triggers.remove(name);
            this.targets.remove(name);
        }
    }

    public void resetTrigger(String name) throws NoSuchElementException {
        TimeTrigger trigger;
        if (Utilities.checkString(name) && (trigger = (TimeTrigger)this.triggers.get(name)) != null) {
            trigger.reset();
        }
    }

    public void start() {
        Enumeration trigKeys = this.triggers.keys();
        if (trigKeys != null) {
            while (trigKeys.hasMoreElements()) {
                String trigName = (String)trigKeys.nextElement();
                this.launchScheduleThread(trigName);
            }
        }
    }

    protected synchronized void launchScheduleThread(final String triggerName) {
        if (triggerName != null) {
            TimeTrigger trigger = (TimeTrigger)this.triggers.get(triggerName);
            final Target target = (Target)this.targets.get(triggerName);
            if (trigger != null && target != null) {
                long now = System.currentTimeMillis();
                long next = trigger.getTimeAfter(now);
                final long timeUntilTrigger = next - now;
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            try {
                                this.wait(timeUntilTrigger);
                                target.targetTriggered(triggerName);
                                SimpleTimeScheduler.this.launchScheduleThread(triggerName);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }.start();
            }
        }
    }
}

