/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.database.AbstractJDBCDatabase;
import fr.gouv.culture.sdx.utils.database.DatabaseConnection;
import fr.gouv.culture.sdx.utils.database.JDBCDatabaseConnection;
import java.sql.SQLException;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class JDBCDatabase
extends AbstractJDBCDatabase {
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.tableName = (String)this.props.get("appPathName") + "_" + this.id;
    }

    public DatabaseConnection getConnection() throws SDXException {
        try {
            JDBCDatabaseConnection dbConn = new JDBCDatabaseConnection(this.getDataSourceComponent());
            dbConn.enableLogging(this.logger);
            dbConn.setAutoCommit(false);
            return dbConn;
        }
        catch (SQLException e) {
            String[] args = new String[]{this.getId(), e.getMessage()};
            throw new SDXException(this.logger, 3007, args, e);
        }
        catch (ComponentException e) {
            String[] args = new String[]{e.getMessage()};
            SDXException sdxE = new SDXException(null, 3201, args, e);
            String[] args2 = new String[]{this.getId(), sdxE.getMessage()};
            throw new SDXException(this.logger, 3007, args2, sdxE);
        }
    }

    public void releaseConnection(DatabaseConnection conn) throws SDXException {
        if (conn != null) {
            if (conn.getConnection() != null) {
                ((JDBCDatabaseConnection)conn).releaseSqlConnection();
            }
            this.releaseDataSourceComponent(((JDBCDatabaseConnection)conn).getDataSource());
        }
    }

    public String getDatabaseDirectoryName() {
        return null;
    }

    public void optimize() throws SDXException {
    }
}

