/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Database;
import fr.gouv.culture.sdx.utils.database.DatabaseConnection;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.database.Property;
import fr.gouv.culture.sdx.utils.rdbms.DataSourceComponentBacked;
import fr.gouv.culture.sdx.utils.rdbms.JDBC;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;

public abstract class AbstractJDBCDatabase
extends DataSourceComponentBacked
implements Database {
    protected final String FIELD_ID = "id";
    protected final String FIELD_PROPERTY_NAME = "propertyName";
    protected final String FIELD_PROPERTY_VALUE = "propertyValue";
    protected final int COLUMN_PARAM_INDEX_FIELD_ID = 1;
    protected final int COLUMN_PARAM_INDEX_FIELD_PROPERTY_NAME = 2;
    protected final int COLUMN_PARAM_INDEX_FIELD_PROPERTY_VALUE = 3;
    public static final String[] _searchModes = new String[]{"UNION", "INTERSECT", "EXCEPT"};
    protected Hashtable props = null;
    protected Hashtable entityCache = new Hashtable();

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        if (!Utilities.checkString(this.getId())) {
            throw new ConfigurationException("we dont have a valid id with which to build a table name");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseEntity getEntity(String id) throws SDXException {
        DatabaseEntity databaseEntity;
        DatabaseConnection sqldbConn;
        block13: {
            if (!Utilities.checkString(id)) {
                return null;
            }
            DatabaseEntity dbe = null;
            dbe = this.getEntityFromCache(id);
            if (dbe != null) {
                return dbe;
            }
            sqldbConn = this.getConnection();
            Connection conn = sqldbConn.getConnection();
            String queryString = this.getEntityGetQuery();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement(queryString);
                    ps.setString(1, id);
                    rs = ps.executeQuery();
                    dbe = this.getEntity(id, rs);
                    this.addEntityToCache(dbe);
                    databaseEntity = dbe;
                    Object var11_10 = null;
                    if (ps == null) break block13;
                }
                catch (SQLException e) {
                    String[] args = new String[]{id};
                    throw new SDXException(this.logger, 302, args, e);
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (ps != null) {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException e2) {
                        String[] args = new String[]{this.getId(), e2.getMessage()};
                        throw new SDXException(this.logger, 3203, args, e2);
                    }
                }
                this.releaseConnection(sqldbConn);
                throw throwable;
            }
            try {}
            catch (SQLException e2) {
                String[] args = new String[]{this.getId(), e2.getMessage()};
                throw new SDXException(this.logger, 3203, args, e2);
            }
            if (ps != null) {
                ps.close();
            }
        }
        this.releaseConnection(sqldbConn);
        return databaseEntity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseEntity[] getEntities() throws SDXException {
        DatabaseEntity[] databaseEntityArray;
        DatabaseConnection sqldbConn;
        block11: {
            sqldbConn = this.getConnection();
            Connection conn = sqldbConn.getConnection();
            String queryString = this.getAllEntitiesQuery();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement(queryString);
                    rs = ps.executeQuery();
                    databaseEntityArray = this.getEntities(rs);
                    Object var9_8 = null;
                    if (ps == null) break block11;
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId()};
                    throw new SDXException(this.logger, 303, args, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (ps != null) {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException e2) {
                        String[] args = new String[]{this.getId(), e2.getMessage()};
                        throw new SDXException(this.logger, 3203, args, e2);
                    }
                }
                this.releaseConnection(sqldbConn);
                throw throwable;
            }
            try {}
            catch (SQLException e2) {
                String[] args = new String[]{this.getId(), e2.getMessage()};
                throw new SDXException(this.logger, 3203, args, e2);
            }
            if (ps != null) {
                ps.close();
            }
        }
        this.releaseConnection(sqldbConn);
        return databaseEntityArray;
    }

    public String getPropertyValue(String entityId, String name) throws SDXException {
        DatabaseEntity dbe = this.getEntity(entityId);
        if (dbe == null || !Utilities.checkString(name)) {
            return null;
        }
        return dbe.getProperty(name);
    }

    public String[] getPropertyValues(String entityId, String propertyName) throws SDXException {
        DatabaseEntity dbe = this.getEntity(entityId);
        if (dbe == null || !Utilities.checkString(propertyName)) {
            return null;
        }
        return dbe.getPropertyValues(propertyName);
    }

    public Property[] getProperties(String entityId) throws SDXException {
        DatabaseEntity dbe = this.getEntity(entityId);
        if (dbe == null) {
            return null;
        }
        return dbe.getProperties();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void save(DatabaseEntity ent) throws SDXException {
        if (ent == null) {
            return;
        }
        String entityId = ent.getId();
        if (!Utilities.checkString(entityId)) {
            return;
        }
        Property[] props = ent.getProperties();
        DatabaseConnection sqldbConn = this.getConnection();
        Connection conn = sqldbConn.getConnection();
        String queryString = null;
        PreparedStatement ps = null;
        try {
            block14: {
                try {
                    if (props != null && props.length > 0) {
                        for (int i = 0; i < props.length; ++i) {
                            String[] values = props[i].getValues();
                            if (values == null) continue;
                            for (int j = 0; j < values.length; ++j) {
                                queryString = this.getPropertyAddQuery();
                                ps = conn.prepareStatement(queryString);
                                ps.setString(1, entityId);
                                String propName = props[i].getName();
                                String propVal = values[j];
                                if (!Utilities.checkString(propName) || !Utilities.checkString(propVal)) continue;
                                ps.setString(2, propName);
                                ps.setString(3, propVal);
                                ps.executeUpdate();
                                ps.clearParameters();
                            }
                        }
                        break block14;
                    }
                    queryString = this.getPropertyAddQuery();
                    ps = conn.prepareStatement(queryString);
                    ps.clearParameters();
                    ps.setString(1, entityId);
                    ps.setString(2, "");
                    ps.setString(3, "");
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    String[] args = new String[]{entityId, this.getId()};
                    throw new SDXException(this.logger, 307, args, e);
                }
            }
            Object var14_15 = null;
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3203, args, e);
                }
            }
            sqldbConn.commit();
            this.releaseConnection(sqldbConn);
            return;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (ps != null) {
                try {}
                catch (SQLException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3203, args, e);
                }
                ps.close();
            }
            sqldbConn.commit();
            this.releaseConnection(sqldbConn);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void delete(DatabaseEntity ent) throws SDXException {
        DatabaseConnection sqldbConn;
        block11: {
            if (ent == null) return;
            String entityId = ent.getId();
            if (!Utilities.checkString(entityId)) return;
            sqldbConn = this.getConnection();
            Connection conn = sqldbConn.getConnection();
            String queryString = this.getEntityDeleteQuery();
            PreparedStatement ps = null;
            try {
                try {
                    ps = conn.prepareStatement(queryString);
                    ps.setString(1, entityId);
                    ps.executeUpdate();
                    this.deleteEntityFromCache(entityId);
                }
                catch (SQLException e) {
                    String[] args = new String[]{entityId, this.getId()};
                    throw new SDXException(this.logger, 308, args, e);
                }
                Object var10_7 = null;
                if (ps == null) break block11;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (ps != null) {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException e) {
                        String[] args = new String[]{this.getId(), e.getMessage()};
                        throw new SDXException(this.logger, 3203, args, e);
                    }
                }
                sqldbConn.commit();
                this.releaseConnection(sqldbConn);
                throw throwable;
            }
            try {}
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.logger, 3203, args, e);
            }
            if (ps != null) {
                ps.close();
            }
        }
        sqldbConn.commit();
        this.releaseConnection(sqldbConn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void delete(DatabaseEntity[] entities) throws SDXException {
        DatabaseConnection sqldbConn;
        block14: {
            if (entities == null) {
                return;
            }
            Connection conn = null;
            String entityId = null;
            Statement ps = null;
            String queryString = this.getEntityDeleteQuery();
            sqldbConn = this.getConnection();
            try {
                try {
                    for (int i = 0; i < entities.length; ++i) {
                        DatabaseEntity ent = entities[i];
                        if (ent == null || !Utilities.checkString(entityId = ent.getId())) continue;
                        if (conn == null) {
                            conn = sqldbConn.getConnection();
                            ps = conn.prepareStatement(queryString);
                        }
                        ps.setString(1, entityId);
                        ps.executeUpdate();
                        this.deleteEntityFromCache(entityId);
                    }
                    Object var10_11 = null;
                    if (ps == null) break block14;
                }
                catch (SQLException e) {
                    String[] args = new String[2];
                    args[0] = this.getId();
                    throw new SDXException(this.logger, 309, args, e);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (ps != null) {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException e) {
                        String[] args = new String[]{this.getId(), e.getMessage()};
                        throw new SDXException(this.logger, 3203, args, e);
                    }
                }
                sqldbConn.commit();
                this.releaseConnection(sqldbConn);
                throw throwable;
            }
            try {}
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.logger, 3203, args, e);
            }
            if (ps != null) {
                ps.close();
            }
        }
        sqldbConn.commit();
        this.releaseConnection(sqldbConn);
    }

    public void update(DatabaseEntity ent) throws SDXException {
        if (ent != null) {
            this.delete(ent);
            this.save(ent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long size() {
        Exception e2;
        long l;
        int ret;
        Statement ps;
        DatabaseConnection sqldbConn;
        block17: {
            sqldbConn = null;
            Connection conn = null;
            ps = null;
            ResultSet rs = null;
            ret = -1;
            sqldbConn = this.getConnection();
            conn = sqldbConn.getConnection();
            String queryString = "SELECT COUNT(DISTINCT id) FROM " + this.getTableName();
            ps = conn.prepareStatement(queryString);
            rs = ps.executeQuery();
            rs.next();
            ret = rs.getInt(1);
            l = ret;
            Object var10_12 = null;
            if (ps == null) break block17;
            try {
                ps.close();
            }
            catch (SQLException e2) {
                String[] args = new String[]{this.getId(), e2.getMessage()};
                new SDXException(this.logger, 3203, args, e2);
            }
        }
        try {
            this.releaseConnection(sqldbConn);
        }
        catch (SDXException e2) {
            Utilities.logException(this.logger, e2);
        }
        return l;
        catch (SQLException e3) {
            long l2;
            block19: {
                l2 = ret;
                Object var10_13 = null;
                if (ps == null) break block19;
                try {
                    ps.close();
                }
                catch (SQLException e2) {
                    String[] args = new String[]{this.getId(), e2.getMessage()};
                    new SDXException(this.logger, 3203, args, e2);
                }
            }
            try {
                this.releaseConnection(sqldbConn);
            }
            catch (SDXException e2) {
                Utilities.logException(this.logger, e2);
            }
            return l2;
        }
        catch (SDXException e4) {
            long l3;
            block21: {
                l3 = ret;
                Object var10_14 = null;
                if (ps == null) break block21;
                {
                    catch (Throwable throwable) {
                        Object var10_15 = null;
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (SQLException e2) {
                                String[] args = new String[]{this.getId(), e2.getMessage()};
                                new SDXException(this.logger, 3203, args, e2);
                            }
                        }
                        try {
                            this.releaseConnection(sqldbConn);
                        }
                        catch (SDXException e2) {
                            Utilities.logException(this.logger, e2);
                        }
                        throw throwable;
                    }
                }
                try {
                    ps.close();
                }
                catch (SQLException e2) {
                    String[] args = new String[]{this.getId(), e2.getMessage()};
                    new SDXException(this.logger, 3203, args, e2);
                }
            }
            try {
                this.releaseConnection(sqldbConn);
            }
            catch (SDXException e2) {
                Utilities.logException(this.logger, e2);
            }
            return l3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void empty() throws SDXException {
        DatabaseConnection sqlDbConn;
        block9: {
            sqlDbConn = this.getConnection();
            Connection conn = null;
            Statement ps = null;
            try {
                try {
                    conn = sqlDbConn.getConnection();
                    String queryString = this.getDeleteAllQuery();
                    ps = conn.prepareStatement(queryString);
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(this.logger, 3003, args, e);
                }
                Object var7_6 = null;
                if (ps == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        String[] args = new String[]{this.getId(), e.getMessage()};
                        throw new SDXException(this.logger, 3203, args, e);
                    }
                }
                sqlDbConn.commit();
                this.releaseConnection(sqlDbConn);
                throw throwable;
            }
            try {}
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.logger, 3203, args, e);
            }
            ps.close();
        }
        sqlDbConn.commit();
        this.releaseConnection(sqlDbConn);
    }

    public void setProperties(Hashtable props) {
        this.props = props;
    }

    public boolean entityExists(String id) {
        if (!Utilities.checkString(id)) {
            return false;
        }
        DatabaseEntity dbe = null;
        try {
            dbe = this.getEntity(id);
        }
        catch (SDXException e) {
            Utilities.logException(this.logger, e);
            return false;
        }
        return dbe != null;
    }

    public String[] search(Parameters params) throws SDXException {
        if (params.getNames().length >= 2) {
            return this.searchWithParams(params);
        }
        return this.search(params, 1);
    }

    public String[] search(final Parameters params, int mode) throws SDXException {
        if (mode != 0 && mode != 1 && mode != 2) {
            return new String[0];
        }
        String modeString = _searchModes[mode];
        if (params == null) {
            return new String[0];
        }
        String[] entities = new String[]{};
        DatabaseConnection sqlDbConn = this.getConnection();
        Connection conn = sqlDbConn.getConnection();
        String queryString = "";
        String l_templateQueryString = "SELECT id FROM " + this.getTableName() + " WHERE " + "propertyName" + " = ? AND " + "propertyValue" + " = ?";
        final String[] paramNames = params.getNames();
        try {
            for (int i = 0; i < paramNames.length; ++i) {
                queryString = i == 0 ? queryString + l_templateQueryString : queryString + " " + modeString + " " + l_templateQueryString;
            }
            if (Utilities.checkString(queryString)) {
                JDBC.Template template = new JDBC.Template(conn, queryString);
                JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){
                    String[] l_dbes = null;

                    public void prepare(PreparedStatement ps) throws SQLException, SDXException {
                        for (int j = 0; j < paramNames.length; ++j) {
                            int paramIdx = j * 2;
                            ps.setString(paramIdx + 1, paramNames[j]);
                            try {
                                ps.setString(paramIdx + 2, params.getParameter(paramNames[j]));
                                continue;
                            }
                            catch (ParameterException e) {
                                throw new SDXException(AbstractJDBCDatabase.this.logger, 114, null, e);
                            }
                        }
                    }

                    public void collect(ResultSet rs) throws SQLException, SDXException {
                        this.l_dbes = AbstractJDBCDatabase.this.getEntityIds(rs);
                    }

                    public Object get() {
                        return this.l_dbes;
                    }
                };
                template.execute(qe, 0);
                entities = (String[])qe.get();
            }
            if (entities == null) {
                entities = new String[]{};
            }
            String[] template = entities;
            return template;
        }
        catch (SDXException e) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(this.logger, 306, args, e);
        }
        finally {
            this.releaseConnection(sqlDbConn);
        }
    }

    public String[] searchWithParams(final Parameters params) throws SDXException {
        if (params == null) {
            return new String[0];
        }
        String[] entities = new String[]{};
        DatabaseConnection sqlDbConn = this.getConnection();
        Connection conn = sqlDbConn.getConnection();
        String queryString = "";
        final String[] paramNames = params.getNames();
        for (int j = 0; j < paramNames.length; ++j) {
            try {
                String paramValue = params.getParameter(paramNames[j]);
                continue;
            }
            catch (ParameterException e1) {
                e1.printStackTrace();
            }
        }
        try {
            if (paramNames.length < 2) {
                queryString = queryString + "SELECT id FROM " + this.getTableName() + " WHERE " + "propertyName" + " = ? AND " + "propertyValue" + " = ?";
            } else if (paramNames.length == 2) {
                queryString = queryString + "SELECT t1.id FROM " + this.getTableName() + " AS t1, " + this.getTableName() + " AS t2 ";
                queryString = queryString + " WHERE t1.propertyName = ? AND t1.propertyValue = ? ";
                queryString = queryString + " AND t2.propertyName = ? AND t2.propertyValue = ? ";
                queryString = queryString + " AND t1.id = t2.id";
            } else {
                String[] args = new String[]{this.getId(), "Search in database with more tha two parameters not implemented."};
                new SDXException(this.logger, 306, args, null);
            }
            if (Utilities.checkString(queryString)) {
                JDBC.Template template = new JDBC.Template(conn, queryString);
                JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){
                    String[] l_dbes = null;

                    public void prepare(PreparedStatement ps) throws SQLException, SDXException {
                        for (int j = 0; j < paramNames.length; ++j) {
                            int paramIdx = j * 2;
                            ps.setString(paramIdx + 1, paramNames[j]);
                            try {
                                ps.setString(paramIdx + 2, params.getParameter(paramNames[j]));
                                continue;
                            }
                            catch (ParameterException e) {
                                throw new SDXException(AbstractJDBCDatabase.this.logger, 114, null, e);
                            }
                        }
                    }

                    public void collect(ResultSet rs) throws SQLException, SDXException {
                        this.l_dbes = AbstractJDBCDatabase.this.getEntityIds(rs);
                    }

                    public Object get() {
                        return this.l_dbes;
                    }
                };
                template.execute(qe, 0);
                entities = (String[])qe.get();
            }
            if (entities == null) {
                entities = new String[]{};
            }
            String[] template = entities;
            return template;
        }
        catch (SDXException e) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(this.logger, 306, args, e);
        }
        finally {
            this.releaseConnection(sqlDbConn);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws SDXException {
        DatabaseConnection sqlDbConn;
        block10: {
            sqlDbConn = this.getConnection();
            Connection conn = null;
            ResultSet rs = null;
            try {
                try {
                    conn = sqlDbConn.getConnection();
                    DatabaseMetaData dbmd = conn.getMetaData();
                    rs = dbmd.getTables(null, null, this.getTableName(), null);
                    if (!rs.next()) {
                        this.createTable(conn);
                        this.createIndicies(conn);
                    }
                }
                catch (SQLException e) {
                    String[] args = new String[]{this.getId()};
                    throw new SDXException(this.logger, 301, args, e);
                }
                Object var7_6 = null;
                if (rs == null) break block10;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        String[] args = new String[]{this.getId(), e.getMessage()};
                        throw new SDXException(this.logger, 3200, args, e);
                    }
                }
                sqlDbConn.commit();
                this.releaseConnection(sqlDbConn);
                throw throwable;
            }
            try {}
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(this.logger, 3200, args, e);
            }
            rs.close();
        }
        sqlDbConn.commit();
        this.releaseConnection(sqlDbConn);
    }

    protected String getTableCreationQuery() {
        return "CREATE TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + "propertyName" + " VARCHAR(255) NOT NULL, " + "propertyValue" + " VARCHAR(255) NOT NULL, " + "PRIMARY KEY (" + "id" + "(255), " + "propertyName" + "(255), " + "propertyValue" + "(255) ))";
    }

    protected String getEntityGetQuery() {
        return "SELECT * FROM " + this.getTableName() + " WHERE " + "id" + " = ?";
    }

    protected String getAllEntitiesQuery() {
        return "SELECT * FROM " + this.getTableName();
    }

    protected String getEntityDeleteQuery() {
        return "DELETE FROM " + this.getTableName() + " WHERE " + "id" + " = ?";
    }

    protected String getPropertyAddQuery() {
        return "INSERT INTO " + this.getTableName() + " (" + "id" + "," + "propertyName" + "," + "propertyValue" + ") VALUES (?, ?, ?)";
    }

    protected String getPropertyRemoveQueryWithId() {
        return "DELETE FROM " + this.getTableName() + " WHERE " + "id" + " = ? AND " + "propertyName" + " = ? AND " + "propertyValue" + " = ?";
    }

    protected String getPropertyRemoveQueryWithoutId() {
        return "DELETE FROM " + this.getTableName() + " WHERE " + "propertyName" + " = ? AND " + "propertyValue" + " = ?";
    }

    protected String getDeleteAllQuery() {
        return "DELETE FROM " + this.getTableName();
    }

    protected String getCreateIndiciesQuery(String fieldName) {
        return "CREATE INDEX " + fieldName + " ON " + this.getTableName() + " (" + fieldName + ")";
    }

    protected DatabaseEntity getEntity(String id, ResultSet rs) throws SDXException {
        if (!Utilities.checkString(id) || rs == null) {
            return null;
        }
        DatabaseEntity dbe = null;
        try {
            while (rs.next()) {
                String rowid = rs.getString("id");
                String propName = rs.getString("propertyName");
                String propVal = rs.getString("propertyValue");
                if (!Utilities.checkString(rowid) || !id.equals(rowid)) continue;
                if (dbe == null) {
                    dbe = new DatabaseEntity(id);
                }
                dbe.addProperty(propName, propVal);
            }
            return dbe;
        }
        catch (SQLException e) {
            String[] args = new String[]{id};
            throw new SDXException(this.logger, 302, args, e);
        }
    }

    protected DatabaseEntity[] getEntities(ResultSet rs) throws SDXException {
        if (rs == null) {
            return null;
        }
        Hashtable<String, DatabaseEntity> entities = null;
        try {
            while (rs.next()) {
                if (entities == null) {
                    entities = new Hashtable<String, DatabaseEntity>();
                }
                String rowid = rs.getString("id");
                String propName = rs.getString("propertyName");
                String propVal = rs.getString("propertyValue");
                if (!Utilities.checkString(rowid) || !Utilities.checkString(propName)) continue;
                DatabaseEntity dbe = (DatabaseEntity)entities.get(rowid);
                if (dbe == null) {
                    dbe = new DatabaseEntity(rowid);
                }
                dbe.addProperty(propName, propVal);
                entities.put(rowid, dbe);
            }
            if (entities == null || entities.size() == 0) {
                return null;
            }
            return entities.values().toArray(new DatabaseEntity[0]);
        }
        catch (SQLException e) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(this.logger, 303, args, e);
        }
    }

    protected String[] getEntityIds(ResultSet rs) throws SDXException {
        if (rs == null) {
            return null;
        }
        ArrayList<String> ids = null;
        try {
            while (rs.next()) {
                String rowid;
                if (ids == null) {
                    ids = new ArrayList<String>();
                }
                if (!Utilities.checkString(rowid = rs.getString("id"))) continue;
                ids.add(rowid);
            }
            if (ids == null || ids.size() == 0) {
                return null;
            }
            return ids.toArray(new String[0]);
        }
        catch (SQLException e) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(this.logger, 303, args, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createIndicies(Connection conn) throws SDXException {
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(this.getCreateIndiciesQuery("id"));
                ps.executeUpdate();
                ps = conn.prepareStatement(this.getCreateIndiciesQuery("propertyName"));
                ps.executeUpdate();
                ps = conn.prepareStatement(this.getCreateIndiciesQuery("propertyValue"));
                ps.executeUpdate();
            }
            catch (SQLException e) {
                String[] args = new String[]{this.getTableName(), this.getId()};
                throw new SDXException(this.logger, 310, args, e);
            }
            Object var6_3 = null;
            if (ps == null) return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (ps == null) throw throwable;
            try {
                ps.close();
                throw throwable;
            }
            catch (SQLException e1) {
                String[] args1 = new String[]{this.id, e1.getMessage()};
                throw new SDXException(this.logger, 3203, args1, e1);
            }
        }
        try {}
        catch (SQLException e1) {
            String[] args1 = new String[]{this.id, e1.getMessage()};
            throw new SDXException(this.logger, 3203, args1, e1);
        }
        ps.close();
    }

    public void addProperty(String entityId, String propertyName, String propertyValue) throws SDXException {
        if (!(Utilities.checkString(entityId) && Utilities.checkString(propertyName) && Utilities.checkString(propertyValue))) {
            return;
        }
        if (this.entityExists(entityId)) {
            DatabaseConnection sqldbConn = this.getConnection();
            Connection conn = sqldbConn.getConnection();
            String queryString = this.getPropertyAddQuery();
            try {
                PreparedStatement ps = conn.prepareStatement(queryString);
                ps.setString(1, entityId);
                ps.setString(2, propertyName);
                ps.setString(3, propertyValue);
                ps.executeUpdate();
                this.deleteEntityFromCache(entityId);
            }
            catch (SQLException e) {
                String[] args = new String[]{entityId, this.getId()};
                throw new SDXException(this.logger, 311, args, e);
            }
            finally {
                sqldbConn.commit();
                this.releaseConnection(sqldbConn);
            }
        }
    }

    public void removeProperty(String entityId, String propertyName, String propertyValue) throws SDXException {
        if (!(Utilities.checkString(entityId) && Utilities.checkString(propertyName) && Utilities.checkString(propertyValue))) {
            return;
        }
        if (this.entityExists(entityId)) {
            DatabaseConnection sqldbConn = this.getConnection();
            Connection conn = sqldbConn.getConnection();
            String queryString = this.getPropertyRemoveQueryWithId();
            try {
                PreparedStatement ps = conn.prepareStatement(queryString);
                ps.setString(1, entityId);
                ps.setString(2, propertyName);
                ps.setString(3, propertyValue);
                ps.executeUpdate();
                this.deleteEntityFromCache(entityId);
            }
            catch (SQLException e) {
                String[] args = new String[]{entityId, this.getId()};
                throw new SDXException(this.logger, 312, args, e);
            }
            finally {
                sqldbConn.commit();
                this.releaseConnection(sqldbConn);
            }
        }
    }

    public void removeProperty(String propertyName, String propertyValue) throws SDXException {
        if (!Utilities.checkString(propertyName) || !Utilities.checkString(propertyValue)) {
            return;
        }
        DatabaseConnection sqldbConn = this.getConnection();
        Connection conn = sqldbConn.getConnection();
        String queryString = this.getPropertyRemoveQueryWithoutId();
        try {
            PreparedStatement ps = conn.prepareStatement(queryString);
            ps.setString(1, propertyName);
            ps.setString(2, propertyValue);
            ps.executeUpdate();
            this.refreshEntityCache();
        }
        catch (SQLException e) {
            String[] args = new String[]{propertyName, propertyValue, this.getId()};
            throw new SDXException(this.logger, 313, args, e);
        }
        finally {
            sqldbConn.commit();
            this.releaseConnection(sqldbConn);
        }
    }

    protected synchronized DatabaseEntity getEntityFromCache(String id) {
        if (!Utilities.checkString(id)) {
            return null;
        }
        return (DatabaseEntity)this.entityCache.get(id);
    }

    protected synchronized void addEntityToCache(DatabaseEntity dbe) {
        if (dbe == null || !Utilities.checkString(dbe.getId())) {
            return;
        }
        this.entityCache.put(dbe.getId(), dbe);
    }

    protected synchronized void deleteEntityFromCache(String id) {
        if (!Utilities.checkString(id)) {
            return;
        }
        this.entityCache.remove(id);
    }

    public String getWildcardSearchToken() {
        return "%";
    }

    protected synchronized boolean isEntityInCache(String id) {
        if (!Utilities.checkString(id)) {
            return false;
        }
        return this.entityCache.containsKey(id);
    }

    protected synchronized void refreshEntityCache() throws SDXException {
        Enumeration ids = this.entityCache.keys();
        if (ids != null) {
            while (ids.hasMoreElements()) {
                String id = (String)ids.nextElement();
                if (!Utilities.checkString(id)) continue;
                this.addEntityToCache(this.getEntity(id));
            }
        }
    }
}

