/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.query.ResultDocument;
import fr.gouv.culture.sdx.search.lucene.query.ResultDocuments;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.utils.Date;
import java.io.IOException;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ProcessingException;
import org.apache.lucene.search.Hits;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SortSpecification
implements Comparator,
LogEnabled {
    private Logger logger;
    public static final int SORT_ORDER_ASCENDANT = 0;
    public static final int SORT_ORDER_DESCENDANT = 1;
    public static final String SORT_RANKING = "sdxscore";
    private Vector sortKeys = new Vector();
    private Hashtable collators = new Hashtable();

    public void addSortKey(Field field, int order) throws SDXException {
        if (field != null) {
            this.sortKeys.add(new SortKey(field, order));
        }
    }

    public void addSortKey(Field field) throws SDXException {
        if (field != null) {
            this.sortKeys.add(new SortKey(field, 0));
        }
    }

    public void addSortKey(String fieldName, int order, SearchLocations locations) throws SDXException {
        if (locations == null) {
            return;
        }
        Field f = locations.getField(fieldName);
        if (f != null) {
            this.sortKeys.add(new SortKey(f, order));
        }
    }

    public void addSortKey(String fieldName, SearchLocations locations) throws SDXException {
        this.addSortKey(fieldName, 0, locations);
    }

    public ResultDocuments sortResults(Hits hits) throws SDXException {
        if (hits == null) {
            throw new SDXException(this.logger, 4002, null, null);
        }
        ResultDocuments rDocs = null;
        if (this.sortKeys.size() == 0 || this.sortKeys.size() == 1 && ((SortKey)this.sortKeys.get(0)).isRankingSort()) {
            rDocs = new ResultDocuments();
            rDocs.enableLogging(this.logger);
            rDocs.setUp(hits);
            return rDocs;
        }
        int nbHits = hits.length();
        ResultDocument[] ret = new ResultDocument[nbHits];
        for (int i = 0; i < nbHits; ++i) {
            ResultDocument rDoc = new ResultDocument();
            rDoc.enableLogging(this.logger);
            try {
                rDoc.setUp(hits.doc(i), hits.score(i));
            }
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 4105, args, e);
            }
            ret[i] = rDoc;
        }
        Arrays.sort(ret, this);
        rDocs = new ResultDocuments();
        rDocs.enableLogging(this.logger);
        rDocs.setUp(ret);
        return rDocs;
    }

    public ResultDocuments sortResults(ResultDocuments res) throws SDXException, IOException {
        if (res == null) {
            throw new SDXException(this.logger, 4900, null, null);
        }
        if (this.sortKeys.size() == 0) {
            return res;
        }
        ResultDocument[] docs = res.getDocuments();
        Arrays.sort(docs, this);
        res.setSortedResults(docs);
        return res;
    }

    public int compare(Object doc1, Object doc2) {
        int ret = 0;
        for (int i = 0; i < this.sortKeys.size(); ++i) {
            ret = this.compare((ResultDocument)doc1, (ResultDocument)doc2, (SortKey)this.sortKeys.get(i));
            if (ret == 0) continue;
            return ret;
        }
        return ret;
    }

    private int compare(ResultDocument doc1, ResultDocument doc2, SortKey key) {
        int ret = 0;
        int order = key.getOrder();
        if (key.isRankingSort()) {
            switch (order) {
                default: {
                    if (doc1.getScore() < doc2.getScore()) {
                        return -1;
                    }
                    if (doc1.getScore() > doc2.getScore()) {
                        return 1;
                    }
                    return 0;
                }
                case 1: 
            }
            if (doc1.getScore() > doc2.getScore()) {
                return -1;
            }
            if (doc1.getScore() < doc2.getScore()) {
                return 1;
            }
            return 0;
        }
        Field field = key.getField();
        Collator col = (Collator)this.collators.get(field);
        if (col == null) {
            col = field.getCollator();
            this.collators.put(field, col);
        }
        if (field.getFieldType() == 2) {
            String doc1_value = doc1.getFieldValue(field.getCode());
            String doc2_value = doc2.getFieldValue(field.getCode());
            ret = doc1_value.equals("") ? (doc2_value.equals("") ? 0 : -1) : (doc2_value.equals("") ? 1 : col.compare(Date.formatDate(DateField.stringToDate(doc1_value)), Date.formatDate(DateField.stringToDate(doc2_value))));
        } else {
            ret = col.compare(doc1.getFieldValue(field.getCode()), doc2.getFieldValue(field.getCode()));
        }
        if (order == 1) {
            return -ret;
        }
        return ret;
    }

    public void toSAX(ContentHandler hdl) throws SAXException, ProcessingException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "sort";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        hdl.startElement(sdxNsUri, localName, qName, atts);
        if (this.sortKeys != null) {
            for (int i = 0; i < this.sortKeys.size(); ++i) {
                ((SortKey)this.sortKeys.get(i)).toSAX(hdl);
            }
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    private class SortKey {
        private Field field;
        private int order;
        private boolean rankingSort = false;

        public SortKey(Field field, int order) throws SDXException {
            if (this.checkOrder(order)) {
                this.field = field;
                this.order = order;
                if (field.getCode().equals(SortSpecification.SORT_RANKING)) {
                    this.rankingSort = true;
                }
            }
        }

        private boolean checkOrder(int o) throws SDXException {
            switch (o) {
                case 0: 
                case 1: {
                    return true;
                }
            }
            throw new SDXException(SortSpecification.this.logger, 4901, null, null);
        }

        public boolean isRankingSort() {
            return this.rankingSort;
        }

        public int getOrder() {
            return this.order;
        }

        public Field getField() {
            return this.field;
        }

        public void toSAX(ContentHandler hdl) throws SAXException, ProcessingException {
            String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
            String sdxNsPrefix = "sdx";
            String localName = "field";
            String qName = sdxNsPrefix + ":" + localName;
            AttributesImpl atts = new AttributesImpl();
            if (this.rankingSort) {
                atts.addAttribute("", "name", "name", "CDATA", SortSpecification.SORT_RANKING);
            } else {
                atts.addAttribute("", "name", "name", "CDATA", this.field.getCode());
            }
            if (this.order == 0) {
                atts.addAttribute("", "order", "order", "CDATA", "ascending");
            } else {
                atts.addAttribute("", "order", "order", "CDATA", "descending");
            }
            hdl.startElement(sdxNsUri, localName, qName, atts);
            hdl.endElement(sdxNsUri, localName, qName);
        }
    }
}

