/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.analysis;

import fr.gouv.culture.sdx.search.lucene.analysis.DefaultAnalyzer;
import java.io.Reader;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.ru.RussianCharsets;

public class Analyzer_ru
extends DefaultAnalyzer {
    private String ATTRIBUTE_CHARSET = "charset";
    private RussianAnalyzer russianAnalyzer = null;
    private char[] charset;
    private String CHARSET_UNICODE_RUSSIAN = "unicodeRussian";
    private String CHARSET_CP1251 = "CP1251";
    private String CHARSET_KOI8 = "KOI8";
    private String DEFAULT_CHARSET = this.CHARSET_UNICODE_RUSSIAN;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.configureCharset(configuration);
        this.russianAnalyzer = this.stopTable != null ? new RussianAnalyzer(this.charset, this.stopTable) : new RussianAnalyzer(this.charset);
    }

    private void configureCharset(Configuration configuration) {
        String cs = this.DEFAULT_CHARSET;
        if (configuration != null) {
            cs = configuration.getAttribute(this.ATTRIBUTE_CHARSET, this.DEFAULT_CHARSET);
        }
        if (cs.equalsIgnoreCase(this.CHARSET_UNICODE_RUSSIAN)) {
            this.charset = RussianCharsets.UnicodeRussian;
        }
        if (cs.equalsIgnoreCase(this.CHARSET_CP1251)) {
            this.charset = RussianCharsets.CP1251;
        }
        if (cs.equalsIgnoreCase(this.CHARSET_KOI8)) {
            this.charset = RussianCharsets.KOI8;
        }
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        return this.russianAnalyzer.tokenStream(fieldName, reader);
    }
}

