/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.AbstractRepositoryConnection;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.logger.Logger;

public class JDBCRepositoryConnection
extends AbstractRepositoryConnection {
    private Connection conn;
    private DataSourceComponent dataSource;

    public JDBCRepositoryConnection(DataSourceComponent dataSource) throws SQLException {
        this.dataSource = dataSource;
        this.conn = dataSource.getConnection();
        this.conn.setAutoCommit(false);
    }

    public void commit() throws SDXException {
        try {
            if (this.conn != null) {
                this.conn.commit();
            }
        }
        catch (SQLException e) {
            String[] args = new String[]{this.dataSource.toString(), e.getMessage()};
            throw new SDXException(this.logger, 3400, args, e);
        }
    }

    public void rollback() throws SDXException {
        try {
            if (this.conn != null) {
                this.conn.rollback();
            }
        }
        catch (SQLException e) {
            String[] args = new String[]{this.dataSource.toString(), e.getMessage()};
            throw new SDXException(this.logger, 3401, args, e);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SDXException {
        try {
            if (this.conn != null) {
                this.conn.setAutoCommit(autoCommit);
            }
        }
        catch (SQLException e) {
            String[] args = new String[]{this.dataSource.toString(), e.getMessage()};
            throw new SDXException(this.logger, 3402, args, e);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public DataSourceComponent getDataSource() {
        return this.dataSource;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected void releaseSqlConnection() throws SDXException {
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(this.logger, 3010, args, e);
        }
    }
}

