/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.documentbase.DefaultIDGenerator;
import fr.gouv.culture.sdx.pipeline.Transformation;
import fr.gouv.culture.sdx.utils.Utilities;
import java.util.Hashtable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.xml.AbstractXMLPipe;

public abstract class AbstractTransformation
extends AbstractXMLPipe
implements Transformation {
    protected static final String PARAMETER_NAME_DISABLE = "disable";
    protected static final String PARAMETER_NAME_ENABLE = "enable";
    protected Parameters parameters;
    protected Parameters transParameters;
    protected Logger logger;
    protected String id = "";
    protected Hashtable props;
    protected ComponentManager manager;
    private boolean keepResult = false;

    public void setProperties(Hashtable props) {
        this.props = props;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters p) {
        this.parameters = p;
    }

    public void recycle() {
        super.recycle();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.id = configuration.getAttribute("id", new DefaultIDGenerator().generate());
        this.keepResult = configuration.getAttributeAsBoolean("keep", false);
        if (configuration != null) {
            this.transParameters = Parameters.fromConfiguration((Configuration)configuration);
            this.verifyConfigurationParameters(this.transParameters);
        }
    }

    protected void verifyConfigurationParameters(Parameters params) {
        if (params != null) {
            String[] paramNames = params.getNames();
            for (int i = 0; i < paramNames.length; ++i) {
                String paramValue;
                String paramName = paramNames[i];
                if (!Utilities.checkString(paramName) || (paramValue = params.getParameter(paramName, null)) != null && !paramValue.equals("null")) continue;
                params.removeParameter(paramName);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean shouldKeepResult() {
        return this.keepResult;
    }

    protected boolean isStepEnabled() {
        String enable;
        boolean enabled = true;
        if (this.transParameters != null && (enabled = Boolean.getBoolean(enable = this.transParameters.getParameter(PARAMETER_NAME_ENABLE, "true")))) {
            String disable = this.transParameters.getParameter(PARAMETER_NAME_DISABLE, "false");
            boolean bl = enabled = !Boolean.getBoolean(disable);
        }
        if (this.parameters != null) {
            if (!enabled) {
                String enableTransId = this.parameters.getParameter(PARAMETER_NAME_ENABLE, null);
                if (Utilities.checkString(enableTransId) && enableTransId.equals(this.id)) {
                    enabled = true;
                }
            } else {
                String disableTransId = this.parameters.getParameter(PARAMETER_NAME_DISABLE, null);
                if (Utilities.checkString(disableTransId) && disableTransId.equals(this.id)) {
                    enabled = false;
                }
            }
        }
        return enabled;
    }
}

