/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.framework;

import fr.gouv.culture.sdx.application.Application;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.framework.Framework;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.search.lucene.analysis.AnalyzerManager;
import fr.gouv.culture.sdx.user.SuperuserInformation;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.avalon.excalibur.io.FileUtil;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.activity.Suspendable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.util.StringUtils;
import org.apache.cocoon.xml.XMLizable;
import org.apache.excalibur.source.SourceUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FrameworkImpl
implements Framework,
Component,
ComponentSelector,
Contextualizable,
Composable,
Configurable,
Reconfigurable,
Initializable,
Disposable,
Startable,
Suspendable,
LogEnabled,
XMLizable,
ThreadSafe {
    private Logger logger;
    private ComponentManager manager;
    private Configuration sdxConf;
    private org.apache.avalon.framework.context.Context context;
    private String contextPath;
    private String libPath;
    private String sdxConfPath;
    private File workDir = null;
    private File context_upload_dir = null;
    private Locale locale;
    private String xmlLang = "";
    private Hashtable registeredAppsByPath;
    private Hashtable registeredAppsById;
    private Hashtable pipes;
    private boolean isSuperUserSet = false;
    private String suEncryptedPasswd = null;
    private boolean isRmiRegistryCreated = false;
    private String rmiHost = "localhost";
    private int rmiPort = 9000;
    private AnalyzerManager analyzerMgr = new AnalyzerManager();
    private String encoding = "UTF-8";
    private final String CONFIGURATION_DIR_PATH = "WEB-INF" + File.separator + "sdx" + File.separator;
    private File sdxAppsDir = null;
    public static final String CONFIGURATION_FILE_NAME = "sdx.xconf";
    private final String APPLICATIONS_DIR = "applications";
    private final String APPLICATION_CONFIGURATION_DIRECTORY = "conf";
    public static final String APP_CONFIG_FILENAME = "application.xconf";
    private final String LIBRARY_DIR_PATH = "WEB-INF/lib/";
    public static final String SDX_CONF = "sdxConfFile";
    public static final String APP_PATH_NAME = "appPathName";
    public static final String APP_CONF_PATH = "appConfDirPath";
    public static final String APP_CONF = "appConf";
    public static final String SDX_APP_PATH = "cocoonAppPath";
    public static final String SDX_CONF_PATH = "sdxConfPath";
    public static final String LIB_PATH = "libPath";
    public static final String SECURITY_POLICY = "securityPolicy";
    public static final String RMI_HOST = "rmiHost";
    public static final String RMI_PORT = "rmiPort";
    public static final String ANALYZER_MGR = "analyzerMgr";
    public static final String ATTRIBUTE_NAME_ENCODING = "encoding";
    private final String ATTRIBUTE_USE = "use";
    private final String ELEMENT_NAME_RMI = "rmi-registry";
    private String ATTRIBUTE_NAME_PORT = "port";
    private String ATTRIBUTE_NAME_HOST = "host";
    private String SUPER_USER_FILE_NAME = "su";
    private final String SDX_DEFAULT_SECURITY_POLICY = "rmi.policy";
    public static final String SDX_DEFAULT_RMI_HOST = "localhost";
    public static final int SDX_DEFAULT_RMI_PORT = 9000;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        if (context == null) {
            throw new ContextException("Context provided was null", null);
        }
        this.context = context;
        this.context_upload_dir = (File)this.context.get((Object)"upload-directory");
        if (this.workDir == null) {
            this.workDir = (File)context.get((Object)"work-directory");
        }
        Context ctx = (Context)context.get((Object)"environment-context");
        try {
            String rootPath = ctx.getRealPath("/");
            if (rootPath != null) {
                this.contextPath = new File(rootPath).toURL().toExternalForm();
            } else {
                String webInf = ctx.getResource("/WEB-INF").toExternalForm();
                this.contextPath = webInf.substring(0, webInf.length() - "WEB-INF".length());
            }
        }
        catch (MalformedURLException e) {
            Utilities.logWarn(this.logger, "Could not get context directory", e);
            this.contextPath = "";
        }
        this.libPath = this.contextPath + "WEB-INF/lib/";
    }

    public void compose(ComponentManager manager) throws ComponentException {
        if (manager == null) {
            SDXException sdxE = new SDXException(null, 221, null, null);
            Utilities.logWarn(this.logger, sdxE.getMessage(), sdxE);
        }
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Utilities.checkConfiguration(configuration);
    }

    private void configureApplications() throws SDXException {
        String sdxAppsPath = this.sdxConfPath + "applications";
        this.sdxAppsDir = Utilities.checkDirectory(sdxAppsPath, this.logger);
        String[] appNames = this.sdxAppsDir.list();
        if (appNames == null || appNames.length == 0) {
            String[] args = new String[]{this.sdxAppsDir.getAbsolutePath()};
            throw new SDXException(this.logger, 4, args, null);
        }
        if (this.registeredAppsById == null) {
            this.registeredAppsById = new Hashtable();
        }
        if (this.registeredAppsByPath == null) {
            this.registeredAppsByPath = new Hashtable();
        }
        Utilities.logInfo(this.logger, "\tConfiguring Applications...");
        for (int i = 0; i < appNames.length; ++i) {
            try {
                this.configureApplication(appNames[i]);
                continue;
            }
            catch (SDXException e) {
                // empty catch block
            }
        }
    }

    private synchronized void configureApplication(String appPath) throws SDXException {
        String appDirPath = this.contextPath + appPath + File.separator;
        File appDir = new File(appDirPath);
        if (!appDir.exists()) {
            String[] args = new String[]{appDirPath};
            throw new SDXException(this.logger, 22, args, null);
        }
        String appConfDirPath = this.contextPath + appPath + File.separator + "conf" + File.separator;
        Utilities.checkDirectory(appConfDirPath, this.logger);
        String appConfFilePath = appConfDirPath + APP_CONFIG_FILENAME;
        File appConfFile = new File(appConfFilePath);
        Utilities.logInfo(this.logger, "\tLoading Application Configuration file from :  " + appConfFile.toString());
        if (!appConfFile.exists()) {
            String[] args = new String[]{appPath, appConfFilePath};
            throw new SDXException(this.logger, 6, args, null);
        }
        DefaultConfigurationBuilder appConfigBuild = new DefaultConfigurationBuilder(true);
        Configuration appConf = null;
        try {
            appConf = appConfigBuild.buildFromFile(appConfFile);
        }
        catch (Exception e) {
            String[] args = new String[]{appPath, appConfFile.getAbsolutePath()};
            throw new SDXException(this.logger, 3, args, e);
        }
        if (appConf == null) {
            String[] args = new String[]{appPath, appConfFile.getAbsolutePath()};
            throw new SDXException(this.logger, 3, args, null);
        }
        if (!this.isRmiRegistryCreated) {
            this.createRmiRegistry(appConf);
        }
        Hashtable props = this.getProperties();
        props.put(APP_PATH_NAME, appPath);
        props.put(APP_CONF_PATH, appConfDirPath);
        props.put(APP_CONF, appConf);
        try {
            Application app = new Application();
            app.enableLogging(this.logger.getChildLogger(appPath));
            app.contextualize(this.context);
            app.compose(this.manager);
            app.setProperties(props);
            Utilities.logInfo(this.logger, "\tConfiguring application..." + app.toString());
            app.configure(appConf);
            app.init();
            this.addApplication(app);
            Utilities.logInfo(this.logger, "\tApplication Configuration Successful, the application, \"" + app.getId() + "\", was configured !");
        }
        catch (ComponentException e) {
            String[] args = new String[]{appDirPath};
            throw new SDXException(this.logger, 32, args, e);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{appDirPath};
            throw new SDXException(this.logger, 32, args, e);
        }
        catch (ContextException e) {
            String[] args = new String[]{appDirPath};
            throw new SDXException(this.logger, 32, args, e);
        }
    }

    private void configurePipelines() throws SDXException {
        Configuration[] pipesConfList = this.sdxConf.getChild("pipelines").getChildren("pipeline");
        if (this.pipes == null) {
            this.pipes = new Hashtable();
        }
        if (pipesConfList != null) {
            for (int i = 0; i < pipesConfList.length; ++i) {
                String[] args;
                Utilities.logInfo(this.logger, "\tConfiguring Pipelines...");
                try {
                    String[] args2;
                    String pipeId = pipesConfList[i].getAttribute("id");
                    Utilities.checkConfAttributeValue("id", pipeId, pipesConfList[i].getLocation());
                    String pipeType = pipesConfList[i].getAttribute("type");
                    Utilities.checkConfAttributeValue("type", pipeType, pipesConfList[i].getLocation());
                    String pipeClassName = "fr.gouv.culture.sdx.pipeline." + pipeType.substring(0, 1).toUpperCase() + pipeType.substring(1, pipeType.length()).toLowerCase() + "Pipeline";
                    Class<?> pipeClass = null;
                    try {
                        pipeClass = Class.forName(pipeClassName);
                    }
                    catch (ClassNotFoundException e) {
                        args2 = new String[]{pipesConfList[i].getAttribute("id"), e.getMessage()};
                        SDXException sdxE = new SDXException(null, 24, args2, e);
                        Utilities.logWarn(this.logger, sdxE.getMessage(), null);
                        pipeClassName = pipeType;
                        try {
                            pipeClass = Class.forName(pipeClassName);
                        }
                        catch (ClassNotFoundException e1) {
                            String[] args22 = new String[]{pipesConfList[i].getAttribute("id"), e1.getMessage()};
                            throw new SDXException(this.logger, 24, args22, e1);
                        }
                    }
                    Object obj = pipeClass.newInstance();
                    if (obj == null) {
                        args2 = new String[]{pipeClassName};
                        throw new SDXException(this.logger, 220, args2, null);
                    }
                    if (!(obj instanceof Pipeline)) {
                        args2 = new String[]{"Pipeline", pipeClass.getName(), pipeType};
                        throw new SDXException(this.logger, 10, args2, null);
                    }
                    Pipeline pipe = (Pipeline)obj;
                    pipe.enableLogging(this.logger.getChildLogger(pipeId));
                    pipe.compose(this.manager);
                    pipe.configure(pipesConfList[i]);
                    this.pipes.put(pipe.getId(), pipe);
                    Utilities.logInfo(this.logger, "\tPipeline Configuration Successful, the application, \"" + pipe.getId() + "\", was configured !");
                    continue;
                }
                catch (InstantiationException e) {
                    args = new String[]{pipesConfList[i].getLocation(), e.getMessage()};
                    new SDXException(this.logger, 24, args, e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    args = new String[]{pipesConfList[i].getLocation(), e.getMessage()};
                    new SDXException(this.logger, 24, args, e);
                    continue;
                }
                catch (ComponentException e) {
                    args = new String[]{pipesConfList[i].getLocation(), e.getMessage()};
                    new SDXException(this.logger, 24, args, e);
                    continue;
                }
                catch (ConfigurationException e) {
                    Utilities.logException(this.logger, (Exception)((Object)e));
                    continue;
                }
                catch (SDXException sDXException) {
                    // empty catch block
                }
            }
        }
    }

    private void createRmiRegistry(Configuration configuration) throws SDXException {
        Configuration[] docBases = configuration.getChild("documentBases").getChildren("documentBase");
        boolean remoteDocBase = false;
        for (int i = 0; i < docBases.length; ++i) {
            Configuration docBas = docBases[i];
            if (!docBas.getAttributeAsBoolean("remote-access", false)) continue;
            remoteDocBase = docBas.getAttributeAsBoolean("remote-access", false);
        }
        if (remoteDocBase) {
            if (System.getSecurityManager() == null) {
                throw new SDXException(this.logger, 33, null, null);
            }
            try {
                String rmiCodebase;
                if (Utilities.checkString(this.rmiHost)) {
                    if (!Utilities.checkString(System.getProperty("java.rmi.server.hostname"))) {
                        System.setProperty("java.rmi.server.hostname", this.rmiHost);
                    } else if (!this.rmiHost.equalsIgnoreCase(System.getProperty("java.rmi.server.hostname"))) {
                        String[] args = new String[]{"java.rmi.server.hostname", System.getProperty("java.rmi.server.hostname"), this.rmiHost};
                        SDXException sdxE = new SDXException(null, 34, args, null);
                        Utilities.logWarn(this.logger, null, sdxE);
                    }
                }
                if (Utilities.checkString(rmiCodebase = this.libPath)) {
                    if (!Utilities.checkString(System.getProperty("java.rmi.server.codebase"))) {
                        System.setProperty("java.rmi.server.codebase", rmiCodebase);
                        System.setProperty("java.rmi.server.useCodebaseOnly", "true");
                    } else if (!rmiCodebase.equalsIgnoreCase(System.getProperty("java.rmi.server.codebase"))) {
                        String[] args = new String[]{"java.rmi.server.codebase", System.getProperty("java.rmi.server.codebase"), rmiCodebase};
                        SDXException sdxE = new SDXException(null, 34, args, null);
                        Utilities.logWarn(this.logger, null, sdxE);
                    }
                }
            }
            catch (SecurityException e) {
                throw new SDXException(this.logger, 35, null, e);
            }
            try {
                LocateRegistry.createRegistry(this.rmiPort);
                this.isRmiRegistryCreated = true;
            }
            catch (RemoteException e) {
                throw new SDXException(this.logger, 36, null, e);
            }
        }
    }

    public void reconfigure(Configuration conf) throws ConfigurationException {
        if (conf == null) {
            try {
                this.contextualize(this.context);
                this.initialize();
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void reconfigureApplication(String appId) throws SDXException {
        Application app;
        if (Utilities.checkString(appId) && (app = this.getApplicationById(appId)) != null) {
            String appPath = app.getPath();
            app = (Application)this.registeredAppsById.remove(appId);
            app = (Application)this.registeredAppsByPath.remove(appPath);
            app = null;
            this.addApplication(appPath);
        }
    }

    public void initialize() throws Exception {
        this.init();
    }

    private synchronized void init() throws Exception {
        this.contextPath = FileUtil.toFile((URL)new URL(this.contextPath)).getCanonicalPath() + File.separator;
        Utilities.logInfo(this.logger, "\tContext directory is " + this.contextPath);
        this.sdxConfPath = this.contextPath + this.CONFIGURATION_DIR_PATH;
        Utilities.checkDirectory(this.sdxConfPath, this.logger);
        String sdxConfFilePath = this.sdxConfPath + CONFIGURATION_FILE_NAME;
        File sdxConfFile = new File(sdxConfFilePath);
        if (!sdxConfFile.exists()) {
            String[] args = new String[]{CONFIGURATION_FILE_NAME, this.sdxConfPath};
            throw new SDXException(this.logger, 1, args, null);
        }
        Utilities.logInfo(this.logger, "\tLoading Framework Configuration file :  " + sdxConfFilePath);
        Utilities.logInfo(this.logger, "\tConfiguring framework... : " + this.toString());
        DefaultConfigurationBuilder frameConfigBuild = new DefaultConfigurationBuilder(true);
        try {
            this.sdxConf = frameConfigBuild.buildFromFile(sdxConfFile);
        }
        catch (Exception e) {
            String[] args = new String[]{sdxConfFile.getAbsolutePath()};
            throw new SDXException(this.logger, 2, args, e);
        }
        Configuration rmiConf = this.sdxConf.getChild("rmi-registry", false);
        if (rmiConf != null) {
            int port = rmiConf.getAttributeAsInteger(this.ATTRIBUTE_NAME_PORT, 9000);
            String host = rmiConf.getAttribute(this.ATTRIBUTE_NAME_HOST, SDX_DEFAULT_RMI_HOST);
            Utilities.checkConfAttributeValue(this.ATTRIBUTE_NAME_HOST, this.rmiHost, rmiConf.getLocation());
            Utilities.checkConfAttributeValue(this.ATTRIBUTE_NAME_PORT, Integer.toString(this.rmiPort), rmiConf.getLocation());
            this.rmiPort = port;
            this.rmiHost = host;
        }
        this.xmlLang = this.sdxConf.getAttribute("xml:lang", null);
        this.locale = Utilities.buildLocale(this.sdxConf, null);
        this.encoding = this.sdxConf.getAttribute(ATTRIBUTE_NAME_ENCODING, "UTF-8");
        this.analyzerMgr.enableLogging(this.logger);
        this.analyzerMgr.compose(this.manager);
        try {
            this.configureApplications();
        }
        catch (SDXException e) {
            // empty catch block
        }
        try {
            this.configureSuperUser();
        }
        catch (SDXException e) {
            // empty catch block
        }
        try {
            this.configurePipelines();
        }
        catch (SDXException sDXException) {
            // empty catch block
        }
    }

    public void start() {
    }

    public void suspend() {
    }

    public void stop() {
    }

    public void dispose() {
    }

    public void resume() {
    }

    public boolean hasComponent(Object hint) {
        return false;
    }

    public Component select(Object hint) throws ComponentException {
        return null;
    }

    public void release(Component component) {
    }

    private Hashtable getProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put(SDX_APP_PATH, this.contextPath);
        props.put("upload-directory", this.context_upload_dir);
        props.put(SDX_CONF_PATH, this.sdxConfPath);
        props.put(SDX_CONF, this.sdxConf);
        props.put(LIB_PATH, this.libPath);
        props.put(ANALYZER_MGR, this.analyzerMgr);
        props.put(ATTRIBUTE_NAME_ENCODING, this.encoding);
        if (new Integer(this.rmiPort) != null) {
            props.put(RMI_PORT, new Integer(this.rmiPort));
        }
        if (Utilities.checkString(this.rmiHost)) {
            props.put(RMI_HOST, this.rmiHost);
        }
        return props;
    }

    public synchronized void addApplication(String appPath) throws SDXException {
        if (Utilities.checkString(appPath)) {
            File appFile = new File(this.sdxAppsDir, appPath);
            try {
                if (appFile != null) {
                    appFile.createNewFile();
                }
            }
            catch (IOException e) {
                String[] args = new String[]{appFile.getAbsolutePath()};
                throw new SDXException(this.logger, 410, null, e);
            }
            this.configureApplication(appPath);
        }
    }

    private void addApplication(Application app) throws SDXException {
        String appKey = app.getPath();
        if (this.registeredAppsByPath.containsKey(appKey)) {
            String[] args = new String[]{"An application with the path name, " + appKey + ", already exists"};
            throw new SDXException(this.logger, 0, args, null);
        }
        this.registeredAppsByPath.put(appKey, app);
        appKey = app.getId();
        if (this.registeredAppsById.containsKey(appKey)) {
            String[] args = new String[]{"An application with the id, " + appKey + ", already exists"};
            throw new SDXException(this.logger, 0, args, null);
        }
        this.registeredAppsById.put(appKey, app);
    }

    public synchronized void removeApplication(String appId) throws SDXException {
        Application app;
        if (Utilities.checkString(appId) && (app = this.getApplicationById(appId)) != null) {
            String appPath = app.getPath();
            this.registeredAppsById.remove(appId);
            this.registeredAppsByPath.remove(appPath);
            File appFile = new File(this.sdxAppsDir, appPath);
            if (appFile != null && appFile.isFile() && appFile.exists()) {
                appFile.delete();
            }
        }
    }

    private void configureSuperUser() throws SDXException {
        try {
            this.getSuperUserInformationFromFile();
        }
        catch (SDXException sdxE) {
            Utilities.logInfo(this.logger, sdxE.getMessage());
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Enumeration getApplicationIds() {
        if (this.registeredAppsById != null) {
            return this.registeredAppsById.keys();
        }
        return null;
    }

    public Application getApplicationById(String id) throws SDXException {
        Application app = (Application)this.registeredAppsById.get(id);
        if (app == null) {
            String[] args = new String[]{id};
            throw new SDXException(this.logger, 1000, args, null);
        }
        return app;
    }

    public Application getApplicationByPath(String path) throws SDXException {
        Application app = (Application)this.registeredAppsByPath.get(path);
        if (app == null) {
            String[] args = new String[]{path};
            throw new SDXException(this.logger, 1000, args, null);
        }
        return app;
    }

    public Pipeline getPipeline(String id) throws SDXException {
        Pipeline pipe = (Pipeline)this.pipes.get(id);
        if (pipe == null) {
            String[] args = new String[]{id};
            throw new SDXException(this.logger, 7000, args, null);
        }
        return pipe.newInstance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSuperUser(String initialUserId, String initialPasswd, String newUserId, String newPasswd, String firstname, String lastname, String email, String xmlLang) throws SDXException {
        if (!Utilities.checkString(newUserId)) {
            throw new SDXException(this.logger, 400, null, null);
        }
        if (!Utilities.checkString(newPasswd)) {
            throw new SDXException(this.logger, 401, null, null);
        }
        if (this.isSuperUserSet) {
            this.validateSuperUser(initialUserId, initialPasswd);
        }
        String[] strings = new String[6];
        for (int i = 0; i < strings.length; ++i) {
            if (i == 0) {
                strings[i] = newUserId;
            }
            if (i == 1) {
                strings[i] = firstname;
            }
            if (i == 2) {
                strings[i] = lastname;
            }
            if (i == 3) {
                strings[i] = email;
            }
            if (i == 4) {
                strings[i] = xmlLang;
            }
            if (i == 5) {
                strings[i] = this.encryptPassword(newPasswd);
            }
            if (strings[i] != null) continue;
            strings[i] = "";
        }
        String data = Utilities.joinStrings(strings, ":");
        if (!Utilities.checkString(data)) {
            throw new SDXException(this.logger, 402, null, null);
        }
        File superUser = new File(this.sdxConfPath, this.SUPER_USER_FILE_NAME);
        FileOutputStream suOut = null;
        try {
            try {
                suOut = new FileOutputStream(superUser);
                suOut.write(data.getBytes());
                this.isSuperUserSet = true;
            }
            catch (IOException e) {
                String[] args = new String[]{this.sdxConfPath + this.SUPER_USER_FILE_NAME};
                throw new SDXException(this.logger, 403, args, e);
            }
            Object var16_14 = null;
            if (suOut == null) return;
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            if (suOut == null) throw throwable;
            try {
                suOut.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new SDXException(this.logger, 219, null, e);
            }
        }
        try {}
        catch (IOException e) {
            throw new SDXException(this.logger, 219, null, e);
        }
        suOut.close();
    }

    public boolean isSuperUserSet() {
        try {
            this.getSuperUserInformationFromFile();
        }
        catch (SDXException sDXException) {
            // empty catch block
        }
        return this.isSuperUserSet;
    }

    public SuperuserInformation validateSuperUser(String userid, String passwd) throws SDXException {
        SuperuserInformation su = this.getSuperUserInformationFromFile();
        if (this.isSuperUserSet) {
            if (su != null && userid.equals(su.getId())) {
                this.checkPassword(passwd);
                return su;
            }
            String[] args = new String[]{userid, passwd};
            throw new SDXException(this.logger, 404, args, null);
        }
        throw new SDXException(this.logger, 409, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SuperuserInformation getSuperUserInformationFromFile() throws SDXException {
        byte[] bytes;
        SuperuserInformation su;
        block17: {
            su = null;
            File superUser = new File(this.sdxConfPath, this.SUPER_USER_FILE_NAME);
            FileInputStream suIs = null;
            bytes = null;
            try {
                try {
                    suIs = new FileInputStream(superUser);
                    bytes = new byte[suIs.available()];
                    suIs.read(bytes);
                }
                catch (IOException e) {
                    Logger localLogger = e instanceof FileNotFoundException ? null : this.logger;
                    this.isSuperUserSet = false;
                    String[] args = new String[]{this.sdxConfPath + this.SUPER_USER_FILE_NAME};
                    throw new SDXException(localLogger, 407, args, e);
                }
                Object var9_5 = null;
                if (suIs == null) break block17;
            }
            catch (Throwable throwable) {
                Object var9_6 = null;
                if (suIs == null) throw throwable;
                try {
                    suIs.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SDXException(this.logger, 219, null, e);
                }
            }
            try {}
            catch (IOException e) {
                throw new SDXException(this.logger, 219, null, e);
            }
            suIs.close();
        }
        String data = null;
        if (bytes != null) {
            data = new String(bytes);
        }
        if (Utilities.checkString(data)) {
            String[] strings = StringUtils.split((String)data, (String)":");
            if (strings.length < 6) {
                this.isSuperUserSet = false;
                String[] args = new String[]{this.sdxConfPath + this.SUPER_USER_FILE_NAME};
                throw new SDXException(this.logger, 408, args, null);
            }
            String id = "";
            String firstname = "";
            String lastname = "";
            String email = "";
            String xmlLang = "";
            String passwd = "";
            for (int i = 0; i < strings.length; ++i) {
                if (i == 0) {
                    id = strings[i];
                }
                if (i == 1) {
                    firstname = strings[i];
                }
                if (i == 2) {
                    lastname = strings[i];
                }
                if (i == 3) {
                    email = strings[i];
                }
                if (i == 4) {
                    xmlLang = strings[i];
                }
                if (i != 5) continue;
                passwd = strings[i];
            }
            su = new SuperuserInformation();
            su.setId(id);
            su.setFirstname(firstname);
            su.setLastname(lastname);
            su.setEmail(email);
            su.setPreferredLocale(Utilities.buildLocale(xmlLang, null, null));
            this.suEncryptedPasswd = passwd;
        }
        if (su != null) {
            this.isSuperUserSet = true;
            return su;
        }
        this.isSuperUserSet = false;
        return su;
    }

    private void checkPassword(String passwd) throws SDXException {
        String providedEncryptedPasswd;
        if (passwd != this.suEncryptedPasswd && !this.suEncryptedPasswd.equals(providedEncryptedPasswd = this.encryptPassword(passwd))) {
            throw new SDXException(this.logger, 405, null, null);
        }
    }

    private String encryptPassword(String passwd) throws SDXException {
        if (passwd == null) {
            return passwd;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SDXException(this.logger, 406, null, e);
        }
        md.update(passwd.getBytes());
        return SourceUtil.encodeBASE64((byte[])md.digest());
    }

    public String getXmlLang() {
        return this.xmlLang;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void toSAX(ContentHandler handler) throws SAXException, ProcessingException {
    }

    public String getEncoding() {
        return this.encoding;
    }
}

