/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.user.User;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IndexParameters
implements XMLizable,
LogEnabled {
    private static final String[] SAME_ID_STRINGS = new String[]{"replace", "error", "ignore"};
    private static final String ATTRIBUTE_SAME_ID = "sameId";
    private static final String ATTRIBUTE_HANDLE_ATTACHED_DOCUMENTS = "handleAttachedDocuments";
    private static final String ATTRIBUTE_HANDLE_TABULAR_DATA = "handleTabularData";
    private Parameters pipelineParams = null;
    public static final int SAME_ID_REPLACE = 0;
    public static final int SAME_ID_ERROR = 1;
    public static final int SAME_ID_IGNORE = 2;
    private int sameId = 0;
    public static final int SAME_ID_REFRESH_SHARED_DOCUMENT = 6;
    protected int attachedDocumentSameId = 6;
    protected int subDocumentSameId = 6;
    private boolean handleAttachedDocuments = true;
    private boolean handleTabularData = true;
    private boolean saveOriginalDocument = true;
    public static final int SEND_STATS_EVENTS = 3;
    public static final int SEND_ERRORS_EVENTS = 4;
    public static final int SEND_ALL_EVENTS = 5;
    private int sendIndexationEvents = 4;
    private User user;
    protected Logger logger;
    private Pipeline pipe;
    private int batchMax = 25;

    public IndexParameters() {
    }

    public IndexParameters(int sameId) {
        this.sameId = sameId;
    }

    public IndexParameters(int sameId, boolean handleAttachedDocuments, boolean handleTabularData) {
        this.sameId = sameId;
        this.handleAttachedDocuments = handleAttachedDocuments;
        this.handleTabularData = handleTabularData;
    }

    public void setSameId(int sameId) {
        this.sameId = sameId;
    }

    public int handleSameId() {
        return this.sameId;
    }

    public void setAttachedDocumentSameId(int attachedDocumentSameId) {
        this.attachedDocumentSameId = attachedDocumentSameId;
    }

    public int handleAttachedDocumentSameId() {
        return this.attachedDocumentSameId;
    }

    public void setSubDocumentSameId(int subDocumentSameId) {
        this.subDocumentSameId = subDocumentSameId;
    }

    public int handleSubDocumentSameId() {
        return this.subDocumentSameId;
    }

    public boolean handleAttachedDocuments() {
        return this.handleAttachedDocuments;
    }

    public boolean handleTabularData() {
        return this.handleTabularData;
    }

    public void toSAX(ContentHandler handler) throws SAXException, ProcessingException {
        if (handler != null) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", ATTRIBUTE_SAME_ID, ATTRIBUTE_SAME_ID, "CDATA", this.getSameIdString());
            atts.addAttribute("", ATTRIBUTE_HANDLE_ATTACHED_DOCUMENTS, ATTRIBUTE_HANDLE_ATTACHED_DOCUMENTS, "CDATA", this.getHandleAttachedDocumentsString());
            atts.addAttribute("", ATTRIBUTE_HANDLE_TABULAR_DATA, ATTRIBUTE_HANDLE_TABULAR_DATA, "CDATA", this.getHandleTabularDataString());
            handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "parameters", "sdx:parameters", atts);
        }
    }

    private String getSameIdString() {
        return SAME_ID_STRINGS[this.handleSameId()];
    }

    private String getHandleAttachedDocumentsString() {
        return String.valueOf(this.handleAttachedDocuments());
    }

    private String getHandleTabularDataString() {
        return String.valueOf(this.handleTabularData());
    }

    public Parameters getPipelineParams() {
        return this.pipelineParams;
    }

    public void setPipelineParams(Parameters pipelineParams) {
        this.pipelineParams = pipelineParams;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) throws SDXException {
        this.user = user;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public Pipeline getPipeline() {
        return this.pipe;
    }

    public void setPipeline(Pipeline pipe) {
        this.pipe = pipe;
    }

    public int getBatchMax() {
        return this.batchMax;
    }

    public void setBatchMax(int batchMax) {
        this.batchMax = batchMax;
    }

    public boolean isSaveOriginalDocument() {
        return this.saveOriginalDocument;
    }

    public void setSaveOriginalDocument(boolean saveOriginalDocument) {
        this.saveOriginalDocument = saveOriginalDocument;
    }

    public int getSendIndexationEvents() {
        return this.sendIndexationEvents;
    }

    public void setSendIndexationEvents(int sendIndexationEvents) {
        this.sendIndexationEvents = sendIndexationEvents;
    }
}

