/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.utils.Date;
import fr.gouv.culture.sdx.utils.Utilities;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class OAIDocument
extends XMLDocument {
    private String dateString = null;
    private String identifier = null;
    public static final String INTERNAL_FIELD_NAME_SDXOAIDATE = "sdxoaidate";
    public static final String INTERNAL_FIELD_NAME_SDXOAIID = "sdxoaiid";

    public void addAdditionalSystemFields(Document doc) {
        Field idField;
        long oaidate;
        Field dateField;
        if (Utilities.checkString(this.dateString) && (dateField = Field.Keyword((String)INTERNAL_FIELD_NAME_SDXOAIDATE, (String)DateField.timeToString(oaidate = Date.parseUtcISO8601Date(this.dateString).getTime()))) != null) {
            doc.add(dateField);
        }
        if (Utilities.checkString(this.identifier) && (idField = Field.Keyword((String)INTERNAL_FIELD_NAME_SDXOAIID, (String)this.identifier)) != null) {
            doc.add(idField);
        }
    }

    public String getDateString() {
        return this.dateString;
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }
}

