/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.document.AbstractDocument;
import fr.gouv.culture.sdx.document.BinaryDocument;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.IndexableDocument;
import fr.gouv.culture.sdx.document.IndexableFieldProperty;
import fr.gouv.culture.sdx.documentbase.DefaultIDGenerator;
import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.serialization.XMLSerializer;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractIndexableDocument
extends AbstractDocument
implements IndexableDocument {
    protected String DOC_NAMESPACE = "http://www.culture.gouv.fr/ns/sdx/sdx";
    protected String DOC_ROOT_ELEMENT_NAME = "document";
    protected String DOC_FIELD_ELEMENT_NAME = "field";
    protected String DOC_ATTACHEDOC_ELEMENT_NAME = "attachedDocument";
    protected String DOC_MSG_ELEMENT_NAME = "message";
    protected Parameters nsTable = null;
    protected Vector properties;
    protected StringBuffer characterBuffer;
    protected String currentFieldName;
    protected int openSdxDocElems = 0;
    protected Vector attachedDocuments = null;
    protected Vector subDocuments;
    private boolean updateAttachedDocuments = true;
    protected IndexableDocument transformedDoc = null;
    protected IndexableDocument subDoc = null;
    protected ByteArrayOutputStream subDocBytes = null;
    protected boolean withinSdxElement = false;
    protected ContentHandler _msgHandler = null;
    protected float _boost = 1.0f;
    protected float _currentFieldBoost = 1.0f;
    protected XMLConsumer xmlConsumer;
    protected ContentHandler contentHandler;
    protected LexicalHandler lexicalHandler;
    protected StoreHandler storeHandler = new StoreHandler();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String nsURI, String name, String qName, Attributes atts) throws SAXException {
        if (this.DOC_NAMESPACE.equals(nsURI)) {
            this.withinSdxElement = true;
            if (this.DOC_FIELD_ELEMENT_NAME.equals(name)) {
                this._currentFieldBoost = 1.0f;
                if (this.openSdxDocElems > 1 && this.subDoc != null) {
                    this.subDoc.startElement(nsURI, name, qName, atts);
                } else if (atts != null) {
                    String boost = atts.getValue("boost");
                    if (Utilities.checkString(boost)) {
                        this._currentFieldBoost = Float.parseFloat(boost);
                    }
                    this.currentFieldName = atts.getValue("name");
                    if (this.currentFieldName == null || "".equals(this.currentFieldName)) {
                        this.currentFieldName = atts.getValue("code");
                    }
                }
                this.characterBuffer = new StringBuffer();
                return;
            }
            if (this.DOC_ATTACHEDOC_ELEMENT_NAME.equals(name)) {
                if (this.openSdxDocElems > 1 && this.subDoc != null) {
                    this.subDoc.startElement(nsURI, name, qName, atts);
                    return;
                } else {
                    if (!this.updateAttachedDocuments() || atts == null) return;
                    String id = atts.getValue("id");
                    String attid = atts.getValue("attid");
                    if (Utilities.checkString(attid)) {
                        if (!Utilities.checkString(id)) {
                            id = super.getId();
                        }
                        id = Utilities.attId(id, attid);
                    }
                    if (!Utilities.checkString(id)) return;
                    try {
                        this.addAttachedDocument(id, this.getURL(), atts.getValue("url"), atts.getValue("mimetype"), atts.getValue("repo"));
                        return;
                    }
                    catch (SDXException e) {
                        throw new SAXException(e.getMessage(), e);
                    }
                }
            }
            if (this.DOC_ROOT_ELEMENT_NAME.equals(name)) {
                try {
                    ++this.openSdxDocElems;
                    if (this.openSdxDocElems == 1) {
                        String boost;
                        this.handleDocumentId(atts);
                        String repo = atts.getValue("repo");
                        if (Utilities.checkString(repo)) {
                            this.setRepositoryForStorage(repo);
                        }
                        if (Utilities.checkString(boost = atts.getValue("boost"))) {
                            this.setBoost(Float.parseFloat(boost));
                        }
                    }
                    if (this.openSdxDocElems <= 1) return;
                    if (this.openSdxDocElems == 2) {
                        XMLSerializer sBytes = new XMLSerializer();
                        this.subDocBytes = new ByteArrayOutputStream();
                        sBytes.setOutputStream((OutputStream)this.subDocBytes);
                        try {
                            this.subDoc = (IndexableDocument)this.getClass().newInstance();
                        }
                        catch (InstantiationException e) {
                            throw new SAXException(e.getMessage(), e);
                        }
                        catch (IllegalAccessException e) {
                            throw new SAXException(e.getMessage(), e);
                        }
                        ((AbstractIndexableDocument)this.subDoc).resetFields();
                        this.setConsumer((XMLConsumer)sBytes);
                        if (this.xmlConsumer != null) {
                            this.xmlConsumer.startDocument();
                        }
                        this.startNamespaceMappings();
                    }
                    if (this.subDoc == null) return;
                    this.subDoc.startElement(nsURI, name, qName, atts);
                    return;
                }
                catch (SDXException e) {
                    throw new SAXException(e.getMessage(), e);
                }
            }
            if (!this.DOC_MSG_ELEMENT_NAME.equals(name)) return;
            this.characterBuffer = new StringBuffer();
            return;
        }
        this.withinSdxElement = false;
        if (this.openSdxDocElems == 2 && this.xmlConsumer != null) {
            this.xmlConsumer.startElement(nsURI, name, qName, atts);
            return;
        } else {
            if (this.subDoc == null) return;
            this.subDoc.startElement(nsURI, name, qName, atts);
        }
    }

    protected void handleDocumentId(Attributes atts) throws SDXException {
        String id = this.getId();
        boolean overrideId = true;
        boolean generateId = false;
        if (atts != null) {
            if (atts.getValue("overrideId") != null && atts.getValue("overrideId").equalsIgnoreCase("false")) {
                overrideId = false;
            }
            if (atts.getValue("generateId") != null && atts.getValue("generateId").equalsIgnoreCase("true")) {
                generateId = true;
            }
            if (Utilities.checkString(atts.getValue("id")) && overrideId) {
                id = atts.getValue("id");
            }
        }
        if ((!Utilities.checkString(id) || generateId) && overrideId) {
            id = this.generateId();
        }
        this.setId(id);
    }

    protected String generateId() throws SDXException {
        String newId = "";
        IDGenerator idGen = this.idGenerator;
        if (idGen == null) {
            SDXException sdxE = new SDXException(this.logger, 5006, null, null);
            Utilities.logWarn(this.logger, sdxE.getMessage(), sdxE);
            idGen = this.idGenerator = new DefaultIDGenerator();
        }
        if (idGen == null) {
            throw new SDXException(this.logger, 5007, null, null);
        }
        newId = Utilities.checkString(this.idPrefix) || Utilities.checkString(this.idSuffix) ? idGen.generate(this.idPrefix, this.idSuffix) : idGen.generate();
        return newId;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.openSdxDocElems > 1) {
            if (this.withinSdxElement && this.subDoc != null) {
                this.subDoc.characters(ch, start, length);
            } else if (!this.withinSdxElement) {
                if (this.openSdxDocElems == 2 && this.xmlConsumer != null) {
                    this.xmlConsumer.characters(ch, start, length);
                } else if (this.subDoc != null) {
                    this.subDoc.characters(ch, start, length);
                }
            }
        } else if (this.characterBuffer != null) {
            this.characterBuffer.append(ch, start, length);
        }
    }

    public void comment(char[] chars, int i, int i1) throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endEntity(String s) throws SAXException {
    }

    public void endPrefixMapping(String s) throws SAXException {
        if (this.openSdxDocElems > 1) {
            if (this.withinSdxElement && this.subDoc != null) {
                this.subDoc.endPrefixMapping(s);
            } else if (!this.withinSdxElement) {
                if (this.openSdxDocElems == 2 && this.xmlConsumer != null) {
                    this.xmlConsumer.endPrefixMapping(s);
                } else if (this.subDoc != null) {
                    this.subDoc.endPrefixMapping(s);
                }
            }
        }
        if (this.nsTable != null) {
            this.nsTable.removeParameter(s);
        }
    }

    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
    }

    public void processingInstruction(String s, String s1) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String s) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String s, String s1, String s2) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startEntity(String s) throws SAXException {
    }

    public void startPrefixMapping(String s, String s1) throws SAXException {
        if (this.nsTable == null) {
            this.nsTable = new Parameters();
        }
        if (!s1.equals("http://www.culture.gouv.fr/ns/sdx/sdx")) {
            this.nsTable.setParameter(s, s1);
        }
        if (this.openSdxDocElems > 1) {
            if (this.withinSdxElement && this.subDoc != null) {
                this.subDoc.startPrefixMapping(s, s1);
            } else if (!this.withinSdxElement) {
                if (this.openSdxDocElems == 2 && this.xmlConsumer != null) {
                    this.xmlConsumer.startPrefixMapping(s, s1);
                } else if (this.subDoc != null) {
                    this.subDoc.startPrefixMapping(s, s1);
                }
            }
        }
    }

    public void endElement(String nsURI, String name, String qName) throws SAXException {
        if (this.DOC_NAMESPACE.equals(nsURI)) {
            if (this.DOC_FIELD_ELEMENT_NAME.equals(name)) {
                if (this.openSdxDocElems > 1 && this.subDoc != null) {
                    this.subDoc.endElement(nsURI, name, qName);
                } else if (this.properties != null && this.currentFieldName != null && this.characterBuffer != null && this.characterBuffer.length() > 0) {
                    IndexableFieldProperty currentFieldProperty = new IndexableFieldProperty();
                    currentFieldProperty.enableLogging(this.logger);
                    currentFieldProperty.setName(this.currentFieldName);
                    currentFieldProperty.addValue(this.characterBuffer.toString());
                    currentFieldProperty.setBoost(this._currentFieldBoost);
                    this.properties.add(currentFieldProperty);
                }
                this.currentFieldName = null;
            } else if (this.DOC_ATTACHEDOC_ELEMENT_NAME.equals(name)) {
                if (this.openSdxDocElems > 1 && this.subDoc != null) {
                    this.subDoc.endElement(nsURI, name, qName);
                }
            } else if (this.DOC_ROOT_ELEMENT_NAME.equals(name)) {
                --this.openSdxDocElems;
                if (this.openSdxDocElems >= 1) {
                    if (this.subDoc != null) {
                        this.subDoc.endElement(nsURI, name, qName);
                    }
                    if (this.openSdxDocElems == 1) {
                        this.endNamespaceMappings();
                        if (this.xmlConsumer != null) {
                            this.xmlConsumer.endDocument();
                        }
                        try {
                            if (this.subDocBytes != null && this.subDoc != null) {
                                this.subDocBytes.close();
                                this.subDoc.setContent(this.subDocBytes.toByteArray());
                                if (this.subDocuments == null) {
                                    this.subDocuments = new Vector();
                                }
                                this.subDocuments.add(this.subDoc);
                                this.subDoc = null;
                                this.subDocBytes = null;
                            }
                        }
                        catch (IOException e) {
                            throw new SAXException(e.getMessage(), e);
                        }
                        this.setConsumer(null);
                    }
                }
            } else if (this.DOC_MSG_ELEMENT_NAME.equals(name) && this.logger != null && this.characterBuffer != null && this.characterBuffer.length() > 0) {
                String loggerId = "";
                String qualElemName = "sdx:message";
                if (Utilities.checkString(super.getId())) {
                    loggerId = super.getId() + ".";
                }
                loggerId = loggerId + qualElemName;
                String bufferContents = this.characterBuffer.toString();
                char[] bufferChars = bufferContents.toCharArray();
                Utilities.logInfo(this.logger.getChildLogger(loggerId), bufferContents);
                if (this._msgHandler != null) {
                    this._msgHandler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "message", qualElemName, new AttributesImpl());
                    this._msgHandler.characters(bufferChars, 0, bufferChars.length);
                    this._msgHandler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "message", qualElemName);
                }
            }
        } else if (this.openSdxDocElems == 2 && this.xmlConsumer != null) {
            this.xmlConsumer.endElement(nsURI, name, qName);
        } else if (this.subDoc != null) {
            this.subDoc.endElement(nsURI, name, qName);
        }
        this.characterBuffer = new StringBuffer();
    }

    private void startNamespaceMappings() throws SAXException {
        String[] prefixes = null;
        if (this.nsTable != null) {
            prefixes = this.nsTable.getNames();
        }
        if (prefixes != null) {
            for (int i = 0; i < prefixes.length; ++i) {
                String prefix = prefixes[i];
                String uri = null;
                try {
                    uri = this.nsTable.getParameter(prefix);
                }
                catch (ParameterException e) {
                    throw new SAXException(e.getMessage(), (Exception)((Object)e));
                }
                if (uri == null) continue;
                if (this.subDoc != null) {
                    this.subDoc.startPrefixMapping(prefix, uri);
                }
                if (this.xmlConsumer == null) continue;
                this.xmlConsumer.startPrefixMapping(prefix, uri);
            }
        }
    }

    private void endNamespaceMappings() throws SAXException {
        String[] prefixes = null;
        if (this.nsTable != null) {
            prefixes = this.nsTable.getNames();
        }
        if (prefixes != null) {
            for (int i = 0; i < prefixes.length; ++i) {
                String prefix = prefixes[i];
                if (this.subDoc != null) {
                    this.subDoc.endPrefixMapping(prefix);
                }
                if (this.xmlConsumer == null) continue;
                this.xmlConsumer.endPrefixMapping(prefix);
            }
        }
    }

    public void setConsumer(XMLConsumer consumer) {
        this.xmlConsumer = consumer;
        this.contentHandler = consumer;
        this.lexicalHandler = consumer;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public Enumeration getFieldValues() {
        if (this.properties != null && this.properties.elements() != null) {
            return this.properties.elements();
        }
        return null;
    }

    public void addAttachedDocument(String id, URL baseURL, String url, String mimetype, String repoId) throws SDXException {
        if (id != null) {
            if (this.attachedDocuments == null) {
                this.attachedDocuments = new Vector();
            }
            try {
                BinaryDocument doc = new BinaryDocument();
                doc.enableLogging(this.logger);
                doc.setId(id);
                doc.setMimeType(mimetype);
                if (Utilities.checkString(repoId)) {
                    doc.setRepositoryForStorage(repoId);
                }
                doc.setContent(Utilities.attUrl(baseURL, url));
                this.attachedDocuments.add(doc);
            }
            catch (MalformedURLException e) {
                String[] args1 = new String[]{this.getId(), url};
                throw new SDXException(this.logger, 5004, args1, e);
            }
        }
    }

    public void setAttachedDocuments(Vector list) {
        this.attachedDocuments = list;
    }

    public boolean updateAttachedDocuments() {
        return this.updateAttachedDocuments;
    }

    public void setUpdateAttachedDocuments(boolean updateAttachedDocuments) {
        this.updateAttachedDocuments = updateAttachedDocuments;
    }

    public Enumeration getAttachedDocuments() {
        if (this.attachedDocuments != null) {
            return this.attachedDocuments.elements();
        }
        return null;
    }

    protected void resetFields() {
        this.properties = new Vector();
    }

    public void resetAttachedDocuments() {
        this.attachedDocuments = new Vector();
    }

    public IndexableDocument getTransformedDocument() {
        return this.transformedDoc;
    }

    protected void setUpTransformedDocument() throws SDXException {
        this.transformedDoc.setId(this.getId());
        if (Utilities.checkString(this.getPreferredFilename())) {
            this.transformedDoc.setPreferredFilename(this.getPreferredFilename());
        }
        this.transformedDoc.setRepositoryForStorage(this.getRepositoryForStorage());
    }

    public Enumeration getSubDocuments() {
        if (this.subDocuments != null) {
            return this.subDocuments.elements();
        }
        return null;
    }

    public StoreHandler getStoreHandler() {
        return this.storeHandler;
    }

    public void setMessageHandler(ContentHandler handler) {
        this._msgHandler = handler;
    }

    public void setBoost(float boost) {
        this._boost = boost;
    }

    public float getBoost() {
        return this._boost;
    }

    public class StoreHandler {
        ArrayList docsStored = new ArrayList();

        public void addDoc(Document doc) throws SDXException {
            Utilities.checkDocument(null, doc);
            this.docsStored.add(doc);
        }

        public Document[] getDocs() {
            return this.docsStored.toArray(new Document[0]);
        }
    }
}

