/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.application;

import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.documentbase.IndexParameters;
import fr.gouv.culture.sdx.documentbase.LuceneDocumentBase;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.resolver.entity.SDXResolver;
import fr.gouv.culture.sdx.search.Searchable;
import fr.gouv.culture.sdx.search.lucene.FieldsDefinition;
import fr.gouv.culture.sdx.thesaurus.SDXThesaurus;
import fr.gouv.culture.sdx.thesaurus.Thesaurus;
import fr.gouv.culture.sdx.user.AnonymousUserInformation;
import fr.gouv.culture.sdx.user.Group;
import fr.gouv.culture.sdx.user.GroupInformationInserter;
import fr.gouv.culture.sdx.user.Identity;
import fr.gouv.culture.sdx.user.User;
import fr.gouv.culture.sdx.user.UserDatabase;
import fr.gouv.culture.sdx.user.UserInformation;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.rdbms.hsql.HSQLDB;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.excalibur.xml.EntityResolver;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLizable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Application
implements XMLizable,
Configurable,
LogEnabled,
Composable,
Contextualizable {
    private Logger logger;
    private DefaultContext context;
    private ComponentManager manager;
    private Hashtable props;
    private String path;
    private String id;
    private Locale locale;
    private String xmlLang = "";
    private Hashtable repositories;
    private Hashtable fieldDefintions = null;
    private Hashtable documentBases;
    private DocumentBase defaultDocumentBase = null;
    private UserDatabase userDatabase;
    private Hashtable thesauri = new Hashtable();
    private Hashtable userInformations;
    private String defaultAdminGroupId = null;
    private Configuration defaultAdminGroupConf = null;
    private String defaultAdminUserId = null;
    public static final String USER_DOCUMENT_BASE_ID = "sdxuserdb";
    public static final String APPLICATION_ID = "appId";
    public static final String APPLICATION_REPOSITORIES = "appRepos";
    public static final String APPLICATION_FIELD_LISTS = "appRepos";
    public static final String DOCUMENTBASES_DIR_PATH = "dbsDirPath";
    public static final String REPOSITORIES_DIR_PATH = "reposDirPath";
    public static final String USERS_DIR_PATH = "usersDirPath";
    public static final String USERS_DOCUMENTBASE_DIR_PATH = "userDocBaseDirPath";
    public static final String THESAURI_DIR_PATH = "thesauriDirPath";
    private final String REPOSITORIES_DIR_NAME = "repos";
    private final String DOCUMENTBASES_DIR_NAME = "dbs";
    private final String USERS_DIR_NAME = "users";
    private final String USERS_DATABASE_DIR_NAME = "userDataBase";
    private final String USERS_DOCUMENTBASE_DIR_NAME = "userDocBase";
    private final String THESAURI_DIR_NAME = "thesauri";
    private final String LIB_DIR_NAME = "lib" + File.separator;
    private final String CLASSES_DIR_NAME = "classes" + File.separator;
    private final String ATTRIBUTE_ID = "id";
    public static final String ELEMENT_NAME_USER_DOCUMENT_BASE = "userDocumentBase";
    private String ELEMENT_NAME_ADMIN = "admin";
    private String ATTRIBUTE_GROUP_ID = "groupId";
    private String ATTRIBUTE_USER_ID = "userId";
    private String ATTRIBUTE_USER_PASSWORD = "userPassword";
    private final String ELEMENT_NAME_CATALOGS = "catalogs";
    private final String ELEMENT_NAME_CATALOG = "catalog";
    private final String ATTRIBUTE_CATALOG_SRC = "src";
    private final String DEFAULT_DOCUMENTBASE_TYPE = "lucene";
    private final String DEFAULT_THESAURUS_TYPE = "lucene";
    public static final String DEFAULT_DATABASE_CONF = "defaultDatabaseType";
    public static final String SDX_DATABASE_DIR_PATH = "sdxDatabaseDirPath";
    public static final String HSQL_DATABASE = "hsqldb";
    public String DATABASES_DIR_NAME = "databases";
    protected int sessionObjectLimit = 5;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void contextualize(Context context) throws ContextException {
        if (context == null) {
            throw new ContextException("Context provided was null", null);
        }
        this.context = (DefaultContext)context;
    }

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.manager = componentManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] catalogConfList;
        Utilities.checkConfiguration(configuration);
        this.path = (String)this.props.get("appPathName");
        this.id = configuration.getAttribute("id");
        if (!Utilities.checkString(this.id)) {
            String[] args = new String[]{this.path, configuration.getLocation()};
            SDXException sdxE = new SDXException(this.logger, 12, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
        }
        this.props.put(APPLICATION_ID, this.id);
        this.xmlLang = configuration.getAttribute("xml:lang");
        Utilities.checkConfAttributeValue("xml:lang", this.xmlLang, configuration.getLocation());
        this.locale = Utilities.buildLocale(configuration, null);
        String appConfPath = Utilities.getStringFromHashtable("appConfDirPath", this.props);
        String dbsDirPath = appConfPath + "dbs" + File.separator;
        String reposDirPath = appConfPath + "repos" + File.separator;
        String usersDirPath = appConfPath + "users" + File.separator;
        String usersDocbaseDirPath = usersDirPath + "userDocBase" + File.separator;
        String thesauriDbsPath = appConfPath + "thesauri" + File.separator;
        String sdxDatabaseDir = appConfPath + this.DATABASES_DIR_NAME + File.separator;
        this.props.put(DOCUMENTBASES_DIR_PATH, dbsDirPath);
        this.props.put(REPOSITORIES_DIR_PATH, reposDirPath);
        this.props.put(USERS_DIR_PATH, usersDirPath);
        this.props.put(USERS_DOCUMENTBASE_DIR_PATH, usersDocbaseDirPath);
        this.props.put(THESAURI_DIR_PATH, thesauriDbsPath);
        this.props.put(SDX_DATABASE_DIR_PATH, sdxDatabaseDir);
        try {
            this.props.put(HSQL_DATABASE, new HSQLDB());
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        this.loadClasses(appConfPath);
        this.configureDefaultDatabaseType(configuration);
        this.configureSessionObjectLimit(configuration);
        this.configureRepositories(configuration);
        this.configureFieldLists(configuration);
        this.configureUserDocumentBase(configuration);
        this.defaultAdminGroupConf = configuration.getChild(this.ELEMENT_NAME_ADMIN, false);
        Configuration catalogs = configuration.getChild("catalogs", false);
        if (catalogs != null && (catalogConfList = catalogs.getChildren("catalog")) != null && catalogConfList.length > 0) {
            try {
                this.addEntityCatalogs(catalogConfList);
            }
            catch (SDXException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        Configuration[] dbConfList = new Configuration[configuration.getChild("documentBases").getChildren("documentBase").length];
        dbConfList = configuration.getChild("documentBases").getChildren("documentBase");
        if (dbConfList == null || dbConfList.length == 0) {
            String[] args = new String[]{((Configuration)this.props.get("appConf")).getLocation()};
            SDXException sdxE = new SDXException(this.logger, 7, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
        }
        this.configureDocumentBases(dbConfList);
        this.configureThesauri(configuration);
    }

    protected void configureFieldLists(Configuration configuration) throws ConfigurationException {
        String elemNameFieldLists = "fieldLists";
        Configuration[] fieldListConfList = new Configuration[configuration.getChild(elemNameFieldLists).getChildren("fieldList").length];
        fieldListConfList = configuration.getChild(elemNameFieldLists).getChildren("fieldList");
        if (fieldListConfList == null || fieldListConfList.length == 0) {
            String[] args = new String[]{this.id};
            SDXException sdxE = new SDXException(null, 28, args, null);
            Utilities.logInfo(this.logger, sdxE.getMessage());
            return;
        }
        if (this.fieldDefintions == null) {
            this.fieldDefintions = new Hashtable();
        }
        for (int i = 0; i < fieldListConfList.length; ++i) {
            FieldsDefinition fieldsDef = null;
            try {
                fieldsDef = Utilities.configureFieldList(this.logger, fieldListConfList[i], this.props);
                String id = fieldsDef.getId();
                Utilities.checkConfAttributeValue("id", id, fieldListConfList[i].getLocation());
                this.fieldDefintions.put(fieldsDef.getId(), fieldsDef);
                continue;
            }
            catch (ConfigurationException e) {
                Utilities.logException(this.logger, (Exception)((Object)e));
            }
        }
        this.props.put("appRepos", this.fieldDefintions);
    }

    protected void configureUserDocumentBase(Configuration configuration) throws ConfigurationException {
        Configuration userDbConf = configuration.getChild(ELEMENT_NAME_USER_DOCUMENT_BASE, false);
        if (userDbConf == null) {
            String[] args = new String[]{configuration.getLocation(), configuration.getLocation()};
            SDXException sdxE = new SDXException(this.logger, 13, args, null);
            Utilities.logWarn(this.logger, sdxE.getMessage(), sdxE);
        }
        if (this.documentBases == null) {
            this.documentBases = new Hashtable();
        }
        try {
            LuceneDocumentBase userDb = new LuceneDocumentBase();
            userDb.enableLogging(this.logger);
            userDb.compose(this.manager);
            userDb.setProperties(new Hashtable(this.props));
            userDb.setId(USER_DOCUMENT_BASE_ID);
            userDb.configure(userDbConf);
            userDb.init();
            this.documentBases.put(USER_DOCUMENT_BASE_ID, userDb);
        }
        catch (ComponentException e) {
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
    }

    protected void configureSessionObjectLimit(Configuration configuration) {
        this.sessionObjectLimit = configuration.getAttributeAsInteger("sessionObjectLimit", 5);
    }

    private void configureDefaultDatabaseType(Configuration configuration) throws ConfigurationException {
        Configuration defaultDatabaseConf = configuration.getChild("database", false);
        if (defaultDatabaseConf != null) {
            this.props.put(DEFAULT_DATABASE_CONF, defaultDatabaseConf);
        }
    }

    private void configureRepositories(Configuration configuration) {
        Configuration[] repoConfList = new Configuration[configuration.getChild("repositories").getChildren("repository").length];
        repoConfList = configuration.getChild("repositories", true).getChildren("repository");
        if (repoConfList == null || repoConfList.length == 0) {
            String[] args = new String[]{this.id};
            SDXException sdxE = new SDXException(null, 28, args, null);
            Utilities.logInfo(this.logger, sdxE.getMessage());
            return;
        }
        if (this.repositories == null) {
            this.repositories = new Hashtable();
        }
        for (int i = 0; i < repoConfList.length; ++i) {
            Repository repo = null;
            try {
                repo = Utilities.createRepository(repoConfList[i], this.manager, this.props, this.logger);
                this.repositories.put(repo.getId(), repo);
                continue;
            }
            catch (SDXException e) {
                continue;
            }
            catch (ConfigurationException e) {
                Utilities.logException(this.logger, (Exception)((Object)e));
            }
        }
        this.props.put("appRepos", this.repositories);
    }

    private void configureDocumentBases(Configuration[] dbConfList) {
        DocumentBase firstDocumentBase = null;
        for (int i = 0; i < dbConfList.length; ++i) {
            String[] args;
            try {
                String[] args2;
                String dbType = dbConfList[i].getAttribute("type", "lucene");
                String dbClassName = "fr.gouv.culture.sdx.documentbase." + dbType.substring(0, 1).toUpperCase() + dbType.substring(1, dbType.length()).toLowerCase() + "DocumentBase";
                Class<?> dbClass = null;
                try {
                    dbClass = Class.forName(dbClassName);
                }
                catch (ClassNotFoundException e) {
                    args2 = new String[]{dbConfList[i].getAttribute("id", this.id), e.getMessage()};
                    SDXException sdxE = new SDXException(null, 8, args2, e);
                    Utilities.logWarn(this.logger, sdxE.getMessage(), null);
                    dbClassName = dbType;
                    try {
                        dbClass = Class.forName(dbClassName);
                    }
                    catch (ClassNotFoundException e1) {
                        String[] args22 = new String[]{dbConfList[i].getAttribute("id", this.id), e1.getMessage()};
                        throw new SDXException(this.logger, 8, args22, e1);
                    }
                }
                Object obj = dbClass.newInstance();
                if (obj == null) {
                    args2 = new String[]{dbClassName};
                    throw new SDXException(this.logger, 220, args2, null);
                }
                if (!(obj instanceof DocumentBase)) {
                    args2 = new String[]{"DocumentBase", dbClass.getName(), dbType};
                    throw new SDXException(this.logger, 10, args2, null);
                }
                DocumentBase db = (DocumentBase)obj;
                db.enableLogging(this.logger);
                db.compose(this.manager);
                db.contextualize((Context)this.context);
                db.setProperties(new Hashtable(this.props));
                db.configure(dbConfList[i]);
                db.init();
                this.documentBases.put(db.getId(), db);
                if (db.isDefault()) {
                    this.defaultDocumentBase = db;
                }
                if (i == 0) {
                    firstDocumentBase = db;
                }
            }
            catch (InstantiationException e) {
                args = new String[]{dbConfList[i].getLocation(), e.getMessage()};
                new SDXException(this.logger, 8, args, e);
            }
            catch (IllegalAccessException e) {
                args = new String[]{dbConfList[i].getLocation(), e.getMessage()};
                new SDXException(this.logger, 8, args, e);
            }
            catch (ComponentException e) {
                args = new String[]{dbConfList[i].getLocation(), e.getMessage()};
                new SDXException(this.logger, 8, args, e);
            }
            catch (ConfigurationException e) {
                Utilities.logException(this.logger, (Exception)((Object)e));
            }
            catch (ContextException e) {
                Utilities.logException(this.logger, (Exception)((Object)e));
            }
            catch (SDXException e) {
                // empty catch block
            }
            if (this.defaultDocumentBase != null) continue;
            this.defaultDocumentBase = firstDocumentBase;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addEntityCatalogs(Configuration[] catalogConfList) throws SDXException, ConfigurationException {
        SDXResolver resolver = null;
        String src = "";
        File srcFile = null;
        try {
            try {
                Component c = this.manager.lookup(EntityResolver.ROLE);
                if (c != null && c instanceof SDXResolver) {
                    resolver = (SDXResolver)c;
                }
                if (resolver == null) {
                    SDXException sdxE = new SDXException(null, 26, null, null);
                    String[] args = new String[]{src, sdxE.getMessage()};
                    throw new SDXException(this.logger, 25, args, sdxE);
                }
                for (int i = 0; i < catalogConfList.length; ++i) {
                    Configuration conf = catalogConfList[i];
                    if (conf == null) continue;
                    src = conf.getAttribute("src");
                    Utilities.checkConfAttributeValue("src", src, conf.getLocation());
                    srcFile = Utilities.resolveFile(null, conf.getLocation(), this.props, src, false);
                    if (srcFile == null) continue;
                    resolver.addCatalog(srcFile.toURL());
                }
                Object var9_13 = null;
                if (resolver == null) return;
            }
            catch (ComponentException e) {
                throw new SDXException(this.logger, 26, null, e);
            }
            catch (MalformedURLException e) {
                String[] args = new String[]{src, e.getMessage()};
                throw new SDXException(this.logger, 25, args, e);
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (resolver == null) throw throwable;
            this.manager.release(resolver);
            throw throwable;
        }
        this.manager.release((Component)resolver);
    }

    private void configureThesauri(Configuration configuration) {
        Configuration[] thConfList = new Configuration[configuration.getChild("thesauri", true).getChildren("thesaurus").length];
        thConfList = configuration.getChild("thesauri", true).getChildren("thesaurus");
        for (int i = 0; i < thConfList.length; ++i) {
            String[] args;
            try {
                String[] args2;
                String thType = thConfList[i].getAttribute("type", "lucene");
                String thClassName = "fr.gouv.culture.sdx.thesaurus." + thType.substring(0, 1).toUpperCase() + thType.substring(1, thType.length()).toLowerCase() + "Thesaurus";
                Class<?> thClass = null;
                try {
                    thClass = Class.forName(thClassName);
                }
                catch (ClassNotFoundException e) {
                    args2 = new String[]{thConfList[i].getAttribute("id"), e.getMessage()};
                    SDXException sdxE = new SDXException(null, 41, args2, e);
                    Utilities.logWarn(this.logger, sdxE.getMessage(), null);
                    thClassName = thType;
                    try {
                        thClass = Class.forName(thClassName);
                    }
                    catch (ClassNotFoundException e1) {
                        String[] args22 = new String[]{thConfList[i].getAttribute("id"), e1.getMessage()};
                        throw new SDXException(this.logger, 41, args22, e1);
                    }
                }
                Object obj = thClass.newInstance();
                if (obj == null) {
                    args2 = new String[]{thClassName};
                    throw new SDXException(this.logger, 220, args2, null);
                }
                if (!(obj instanceof Thesaurus)) {
                    args2 = new String[]{"Thesaurus", thClass.getName(), thType};
                    throw new SDXException(this.logger, 10, args2, null);
                }
                SDXThesaurus th = (SDXThesaurus)obj;
                th.enableLogging(this.logger);
                th.compose(this.manager);
                th.setProperties(new Hashtable(this.props));
                th.configure(thConfList[i]);
                th.init();
                this.thesauri.put(th.getId(), th);
                continue;
            }
            catch (InstantiationException e) {
                args = new String[]{thConfList[i].getLocation(), e.getMessage()};
                new SDXException(this.logger, 41, args, e);
                continue;
            }
            catch (IllegalAccessException e) {
                args = new String[]{thConfList[i].getLocation(), e.getMessage()};
                new SDXException(this.logger, 41, args, e);
                continue;
            }
            catch (ComponentException e) {
                args = new String[]{thConfList[i].getLocation(), e.getMessage()};
                new SDXException(this.logger, 41, args, e);
                continue;
            }
            catch (ConfigurationException e) {
                Utilities.logException(this.logger, (Exception)((Object)e));
                continue;
            }
            catch (SDXException e) {
                // empty catch block
            }
        }
    }

    public void init() throws SDXException, ConfigurationException, ComponentException {
        Utilities.checkDirectory(Utilities.getStringFromHashtable(DOCUMENTBASES_DIR_PATH, this.props), this.logger);
        this.userDatabase = new UserDatabase("sdxuserdatabase");
        this.userDatabase.enableLogging(this.logger);
        this.userDatabase.compose(this.manager);
        this.userDatabase.setProperties(new Hashtable(this.props));
        this.userDatabase.configure((Configuration)new DefaultConfiguration("hack", ""));
        this.userDatabase.init();
        this.verifyDefaultAdminGroup();
    }

    private void loadClasses(String appConfPath) throws ConfigurationException {
        String libPath = appConfPath + this.LIB_DIR_NAME;
        File libDir = new File(libPath);
        String classesPath = appConfPath + this.CLASSES_DIR_NAME;
        File classesDir = new File(classesPath);
        String classpath = "";
        try {
            if (libDir.exists() || classesDir.exists()) {
                classpath = (String)this.context.get((Object)"classpath");
                if (!classpath.endsWith(File.pathSeparator)) {
                    classpath = classpath + File.pathSeparator;
                }
                if (Utilities.checkString(classpath)) {
                    if (libDir.exists()) {
                        File[] libs = libDir.listFiles();
                        for (int i = 0; i < libs.length; ++i) {
                            classpath = classpath + libs[i].getAbsolutePath() + File.pathSeparator;
                        }
                    }
                    if (classesDir.exists()) {
                        classpath = classpath + classesDir.getAbsolutePath() + File.pathSeparator;
                    }
                }
                this.context.put((Object)"classpath", (Object)classpath);
            }
        }
        catch (ContextException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public void setProperties(Hashtable props) {
        this.props = props;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public Repository getRepository(String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            return null;
        }
        Repository repo = (Repository)this.repositories.get(id);
        if (repo == null) {
            String[] args = new String[]{id, this.getId()};
            throw new SDXException(this.logger, 1002, args, null);
        }
        return repo;
    }

    public DocumentBase getDocumentBase(String dbId) throws SDXException {
        if (!Utilities.checkString(dbId)) {
            return null;
        }
        DocumentBase db = null;
        db = (DocumentBase)this.documentBases.get(dbId);
        if (db == null) {
            String[] args = new String[]{dbId, this.getId()};
            throw new SDXException(this.logger, 1001, args, null);
        }
        return db;
    }

    public Enumeration getDocumentBasesIds() {
        if (this.documentBases != null) {
            return this.documentBases.keys();
        }
        return null;
    }

    public DocumentBase getDefaultDocumentBase() {
        return this.defaultDocumentBase;
    }

    public String getXmlLang() {
        return this.xmlLang;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public SDXThesaurus getThesaurus(String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            return null;
        }
        SDXThesaurus th = null;
        th = (SDXThesaurus)this.thesauri.get(id);
        if (th == null) {
            String[] args = new String[]{id, this.getId()};
            throw new SDXException(this.logger, 1005, args, null);
        }
        return th;
    }

    public Searchable getSearchable(String id) {
        Searchable searchable = null;
        if (!Utilities.checkString(id)) {
            return null;
        }
        searchable = (Searchable)this.documentBases.get(id);
        if (searchable == null) {
            searchable = (Searchable)this.thesauri.get(id);
        }
        return searchable;
    }

    public UserDatabase getUserDatabase() {
        return this.userDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultAdminGroupId() {
        String gid = null;
        try {
            if (this.getUserInformation(this.defaultAdminGroupId) != null) {
                gid = this.defaultAdminGroupId;
                return gid;
            }
        }
        catch (SDXException e) {
            Utilities.logException(this.logger, e);
            gid = null;
            return gid;
        }
        finally {
            return gid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultAdminUserId() {
        String uid = null;
        try {
            if (this.getUserInformation(this.defaultAdminUserId) != null) {
                uid = this.defaultAdminUserId;
                return uid;
            }
        }
        catch (SDXException e) {
            uid = null;
            return uid;
        }
        finally {
            return uid;
        }
    }

    private void verifyDefaultAdminGroup() throws SDXException, ConfigurationException {
        UserDatabase udb = this.getUserDatabase();
        if (udb != null && this.defaultAdminGroupConf != null) {
            String adminGroupId = this.defaultAdminGroupConf.getAttribute(this.ATTRIBUTE_GROUP_ID);
            Utilities.checkConfAttributeValue(this.ATTRIBUTE_GROUP_ID, adminGroupId, this.defaultAdminGroupConf.getLocation());
            String adminUserId = this.defaultAdminGroupConf.getAttribute(this.ATTRIBUTE_USER_ID);
            Utilities.checkConfAttributeValue(this.ATTRIBUTE_USER_ID, adminUserId, this.defaultAdminGroupConf.getLocation());
            String passwd = this.defaultAdminGroupConf.getAttribute(this.ATTRIBUTE_USER_PASSWORD, null);
            if (udb.getEntity(adminGroupId) == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = null;
                try {
                    builder = factory.newDocumentBuilder();
                    Document doc = null;
                    Element top = null;
                    doc = builder.newDocument();
                    top = doc.createElementNS("http://www.culture.gouv.fr/ns/sdx/sdx", "sdx:group");
                    doc.appendChild(top);
                    top.setAttribute("id", adminGroupId);
                    Group adminGroup = new Group();
                    adminGroup.enableLogging(this.logger);
                    adminGroup.setId(adminGroupId);
                    adminGroup.setPreferredFilename(adminGroupId + ".xml");
                    adminGroup.setContent(doc);
                    this.addIdentity(adminGroup, null, null, null, null);
                    this.defaultAdminGroupId = adminGroupId;
                    doc = builder.newDocument();
                    top = doc.createElementNS("http://www.culture.gouv.fr/ns/sdx/sdx", "sdx:user");
                    doc.appendChild(top);
                    top.setAttribute("id", adminUserId);
                    User adminUser = new User();
                    adminUser.enableLogging(this.logger);
                    adminUser.setId(adminUserId);
                    adminUser.setPreferredFilename(adminUserId + ".xml");
                    adminUser.setContent(doc);
                    this.addIdentity(adminUser, passwd, null, null, null);
                    this.defaultAdminUserId = adminUserId;
                    this.addMember(adminGroup, adminUserId);
                }
                catch (ParserConfigurationException e) {
                    throw new ConfigurationException(e.getMessage(), (Throwable)e);
                }
                catch (SAXException e) {
                    throw new ConfigurationException(e.getMessage(), (Throwable)e);
                }
                catch (ProcessingException e) {
                    throw new ConfigurationException(e.getMessage(), (Throwable)e);
                }
            }
            if (udb.getEntity(adminGroupId) != null) {
                this.defaultAdminGroupId = adminGroupId;
            }
            if (udb.getEntity(adminUserId) != null) {
                this.defaultAdminUserId = adminUserId;
            }
        }
    }

    public void addMember(Group group, String id) throws SDXException {
        if (group == null || group.getId() == null || id == null) {
            return;
        }
        this.userDatabase.addMember(group, id);
        this.resetUserInformation(id);
    }

    public void addMembers(Group group, String[] ids) throws SDXException {
        if (group == null || group.getId() == null || ids == null || ids.length == 0) {
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            this.addMember(group, ids[i]);
        }
    }

    public void replaceMembers(Group group, String[] ids) throws SDXException {
        String[] members = this.userDatabase.getMembers(group.getId());
        if (members != null && members.length != 0) {
            for (int i = 0; i < members.length; ++i) {
                this.resetUserInformation(members[i]);
            }
        }
        this.userDatabase.deleteMembers(group);
        this.addMembers(group, ids);
    }

    public Hashtable getParents(String id) throws SDXException {
        if (id == null) {
            return null;
        }
        return this.userDatabase.getParents(id);
    }

    public String[] getMembers(String groupname) throws SDXException {
        if (groupname == null) {
            return null;
        }
        return this.userDatabase.getMembers(groupname);
    }

    public void addIdentity(Identity identity, String password, Repository repository, IndexParameters params, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        if (identity == null) {
            throw new SDXException(this.logger, 1004, null, null);
        }
        DocumentBase userDB = (DocumentBase)this.documentBases.get(USER_DOCUMENT_BASE_ID);
        if (userDB == null) {
            String[] args = new String[]{USER_DOCUMENT_BASE_ID, this.getId()};
            throw new SDXException(this.logger, 1001, args, null);
        }
        userDB.index(identity, repository, params, handler);
        this.userDatabase.add(identity, this.encode(password));
        if (identity.getDocType() == "user") {
            this.resetUserInformation(identity.getId());
        }
    }

    public boolean changePassword(String username, String oldPass, String newPass) throws SDXException {
        if (this.userDatabase == null) {
            return false;
        }
        return this.userDatabase.changePassword(username, oldPass, newPass);
    }

    public void deleteIdentity(Identity identity) throws SDXException {
        if (identity == null) {
            throw new SDXException(this.logger, 1004, null, null);
        }
        Utilities.checkDocument(this.logger, identity);
        DocumentBase userDB = (DocumentBase)this.documentBases.get(USER_DOCUMENT_BASE_ID);
        try {
            userDB.delete(identity, null);
        }
        catch (SAXException e) {
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
        this.userDatabase.delete(identity);
        if (identity.getDocType() == "user") {
            this.resetUserInformation(identity.getId());
        }
    }

    public boolean validateUser(String username, String password) throws SDXException {
        if (username == null) {
            return false;
        }
        return this.userDatabase.checkPassword(username, this.encode(password));
    }

    public boolean isMember(Identity identity, String groupName) throws SDXException {
        return this.userDatabase.isMember(identity, groupName);
    }

    private String encode(String password) {
        if (password == null) {
            return null;
        }
        return password;
    }

    public UserInformation getUserInformation(String username) throws SDXException {
        if (username == null) {
            username = "sdxAnonymous";
        }
        if (this.userInformations != null && this.userInformations.get(username) != null) {
            return (UserInformation)this.userInformations.get(username);
        }
        UserInformation userInfo = this.userDatabase.getUserInformation(this.id, username, this.locale, this.defaultAdminGroupId);
        if (userInfo == null) {
            return null;
        }
        if (this.userInformations == null) {
            this.userInformations = new Hashtable();
        }
        this.userInformations.put(username, userInfo);
        return userInfo;
    }

    public UserInformation getUserInformation() throws SDXException {
        return this.getUserInformation(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getUserDocument(String username, Hashtable groups, XMLConsumer consumer) throws SDXException {
        Utilities.checkXmlConsumer(this.logger, consumer);
        if (username == null || username.equals("sdxAnonymous")) {
            AnonymousUserInformation anon = (AnonymousUserInformation)this.userInformations.get("sdxAnonymous");
            try {
                if (anon == null) return;
                anon.toSAX((ContentHandler)consumer);
                return;
            }
            catch (SAXException e) {
                String[] args = new String[]{"sdxAnonymous", e.getMessage()};
                throw new SDXException(this.logger, 1003, args, e);
            }
        } else if (groups != null && groups.size() > 0) {
            GroupInformationInserter gii = new GroupInformationInserter(groups, (ContentHandler)consumer);
            gii.enableLogging(this.logger);
            GroupInformationInserter pipe = gii;
            ((DocumentBase)this.documentBases.get(USER_DOCUMENT_BASE_ID)).getDocument(new XMLDocument(username), (XMLConsumer)pipe);
            return;
        } else {
            ((DocumentBase)this.documentBases.get(USER_DOCUMENT_BASE_ID)).getDocument(new XMLDocument(username), consumer);
        }
    }

    private void resetUserInformation(String username) {
        if (username == null) {
            return;
        }
        if (this.userInformations == null) {
            this.userInformations = new Hashtable();
        } else if (this.userInformations.containsKey(username)) {
            this.userInformations.remove(username);
        }
    }

    public void toSAX(ContentHandler handler) throws SAXException, ProcessingException {
    }

    public int getSessionObjectLimit() {
        return this.sessionObjectLimit;
    }
}

