/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.oai;

import fr.gouv.culture.oai.OAIHarvester;
import fr.gouv.culture.oai.SynchronizedOAIObjectImpl;
import fr.gouv.culture.oai.util.OAIUtilities;
import fr.gouv.culture.util.apache.cocoon.components.source.URLSource;
import java.net.URL;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.xml.EmbeddedXMLPipe;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.SourceParameters;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractOAIHarvester
extends SynchronizedOAIObjectImpl
implements OAIHarvester,
Composable {
    public static final String OAI_REQUEST_URL = "oaiRequestUrl";
    public static final String OAI_REPOSITORY_URL = "oaiRepositoryUrl";
    protected ComponentManager manager = null;
    protected String[] adminEmails = null;
    protected String userAgent = "";
    protected String requestUrl = null;
    protected String newRequestUrl = null;
    protected Parameters requestParams = null;
    protected StringBuffer sBuff = null;
    protected boolean captureElemContent = false;
    protected boolean captureRecord = false;
    protected boolean deleteRecord = false;
    protected String repoUrl = null;
    protected String responseDate = null;
    protected String resumptionToken = null;
    protected String currentOaiIdentifier = null;
    protected String currentDatestamp = null;
    protected String currentOaiStatus = null;
    protected String identifierName = "";
    protected String currentMetadtaUrlIdentifier = null;
    protected XMLConsumer firstXmlConsumer = null;

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.manager = componentManager;
    }

    public void setConsumer(XMLConsumer consumer) {
        if (consumer != null && this.firstXmlConsumer == null) {
            this.firstXmlConsumer = consumer = new EmbeddedXMLPipe((ContentHandler)consumer);
        }
        super.setConsumer(consumer);
    }

    public String[] getAdminEmails() {
        return this.adminEmails;
    }

    public void setAdminEmails(String[] adminEmails) {
        this.adminEmails = adminEmails;
    }

    public void setIdentifierName(String name) {
        this.identifierName = name;
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
    }

    public void startElement(String s, String s1, String s2, Attributes attributes) throws SAXException {
        if ("http://www.openarchives.org/OAI/2.0/".equals(s)) {
            if ("responseDate".equals(s1) || "resumptionToken".equals(s1) || "identifier".equals(s1) || "datestamp".equals(s1)) {
                this.captureElemContent = true;
            } else if ("record".equals(s1)) {
                this.captureRecord = true;
                this.prepareRecordCapture();
                super.startDocument();
                super.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            } else if ("request".equals(s1)) {
                this.captureElemContent = true;
                if (attributes != null) {
                    int attsLen = attributes.getLength();
                    for (int i = 0; i < attsLen; ++i) {
                        if (this.requestParams == null) {
                            this.requestParams = new Parameters();
                        }
                        String paramName = attributes.getLocalName(i);
                        String paramVal = attributes.getValue(i);
                        if (!OAIUtilities.checkString(paramName) || !OAIUtilities.checkString(paramVal)) continue;
                        this.requestParams.setParameter(paramName, paramVal);
                    }
                }
            } else if ("header".equals(s1)) {
                String status;
                if (attributes != null && "deleted".equalsIgnoreCase(status = attributes.getValue("status"))) {
                    this.currentOaiStatus = status;
                    this.deleteRecord = true;
                    this.captureRecord = true;
                }
            } else if ("error".equals(s1)) {
                String errorCode;
                this.captureElemContent = true;
                if (attributes != null && OAIUtilities.checkString(errorCode = attributes.getValue("code"))) {
                    OAIUtilities.logError(this.logger, errorCode, null);
                }
            }
        } else if (OAIUtilities.checkString(this.identifierName) && this.identifierName.equals(s1)) {
            this.captureElemContent = true;
        }
        super.startElement(s, s1, s2, attributes);
    }

    public void characters(char[] chars, int relation, int relation1) throws SAXException {
        if (this.captureElemContent) {
            if (this.sBuff == null) {
                this.sBuff = new StringBuffer();
            }
            this.sBuff.append(chars, relation, relation1);
        }
        super.characters(chars, relation, relation1);
    }

    public void endElement(String s, String s1, String s2) throws SAXException {
        super.endElement(s, s1, s2);
        if (this.sBuff != null && this.sBuff.length() > 0) {
            String content = this.sBuff.toString();
            if ("http://www.openarchives.org/OAI/2.0/".equals(s)) {
                if ("responseDate".equals(s1)) {
                    this.responseDate = content;
                } else if ("resumptionToken".equals(s1)) {
                    this.resumptionToken = content;
                } else if ("identifier".equals(s1)) {
                    this.currentOaiIdentifier = content;
                } else if ("datestamp".equals(s1)) {
                    this.currentDatestamp = content;
                } else if ("request".equals(s1)) {
                    this.repoUrl = content;
                } else if ("error".equals(s1)) {
                    this.handleErrors(content);
                }
            }
            if (!"http://www.openarchives.org/OAI/2.0/".equals(s) && OAIUtilities.checkString(this.identifierName) && this.identifierName.equals(s1)) {
                this.currentMetadtaUrlIdentifier = content;
                try {
                    this.prepareResourceFromUrlIdentifierCapture();
                }
                catch (Exception e) {
                    OAIUtilities.logException(this.logger, e);
                }
            }
        }
        if ("http://www.openarchives.org/OAI/2.0/".equals(s)) {
            if ("header".equals(s1) && this.deleteRecord) {
                this.prepareRecordForDeletion();
            }
            if (this.captureRecord) {
                if ("record".equals(s1)) {
                    try {
                        this.captureRecord = false;
                        this.captureResourceFromUrlIdentifier();
                        super.endPrefixMapping("xsi");
                        super.endDocument();
                        this.captureRecord();
                    }
                    catch (Exception e) {
                        OAIUtilities.logException(this.logger, e);
                    }
                    super.recycle();
                    super.setConsumer(this.firstXmlConsumer);
                    this.acquireSynchronizedXMLConsumer();
                }
            } else if ("OAI-PMH".equals(s1)) {
                try {
                    boolean storedData = this.storeHarvestedData();
                    if (this.resumptionToken == null) {
                        this.saveCriticalFields(storedData);
                    } else {
                        this.handleResumptionToken();
                    }
                }
                catch (Exception e) {
                    OAIUtilities.logException(this.logger, e);
                    throw new SAXException(e.getMessage(), e);
                }
                finally {
                    this.resetAllFieldsFinally();
                }
            }
        }
        this.sBuff = null;
        this.captureElemContent = false;
    }

    protected void abortRecordCapture() {
        this.resetRecordCaptureFields(true);
    }

    protected void handleErrors(String errorMsg) {
        OAIUtilities.logError(this.logger, "An error occured during harvesting, please see below : ", null);
        OAIUtilities.logError(this.logger, this.repoUrl, null);
        if (this.requestParams != null) {
            String[] paramNames = this.requestParams.getNames();
            for (int i = 0; i < paramNames.length; ++i) {
                String paramName = paramNames[i];
                String paramVal = "";
                if (OAIUtilities.checkString(paramName)) {
                    paramVal = this.requestParams.getParameter(paramName, "");
                }
                OAIUtilities.logError(this.logger, "parameter : " + paramName + "  value : " + paramVal, null);
            }
        }
        OAIUtilities.logError(this.logger, errorMsg, null);
        OAIUtilities.logError(this.logger, "End Harvest Error", null);
    }

    protected abstract void prepareRecordCapture() throws SAXException;

    protected abstract boolean shouldHarvestDocument();

    protected abstract void captureRecord() throws Exception;

    protected abstract void prepareRecordForDeletion();

    protected abstract void prepareResourceFromUrlIdentifierCapture();

    protected abstract void captureResourceFromUrlIdentifier();

    protected abstract boolean storeHarvestedData() throws Exception;

    protected abstract void storeFailedHarvestData(Exception var1);

    protected abstract void handleResumptionToken();

    protected abstract void saveCriticalFields(boolean var1) throws SAXException;

    protected abstract void resetRecordCaptureFields(boolean var1);

    protected void resetAllFields() {
        this.resetResumptionToken();
        this.identifierName = null;
        this.requestParams = null;
        this.currentOaiIdentifier = null;
        this.currentMetadtaUrlIdentifier = null;
        this.repoUrl = null;
        this.sBuff = null;
        this.captureElemContent = false;
        this.captureRecord = false;
        this.synchronizedXmlConsumerAcquired = false;
    }

    protected void resetAllFieldsFinally() {
        this.resetAllFields();
    }

    public void recycle() {
        this.firstXmlConsumer = null;
        super.recycle();
    }

    protected void resetResumptionToken() {
        this.resumptionToken = null;
    }

    public synchronized void receiveSynchronizedRequest(String url) {
        this.receiveSynchronizedRequest(url, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void receiveSynchronizedRequest(String url, String originalRequestUrl) {
        if (OAIUtilities.checkString(url)) {
            this.requestUrl = originalRequestUrl;
            String currentUrl = url;
            String oldRequestUrl = null;
            while (currentUrl != null && !currentUrl.equals(oldRequestUrl)) {
                try {
                    this.acquire();
                    this.receiveRequest(currentUrl);
                }
                catch (Exception e) {
                    OAIUtilities.logError(this.logger, currentUrl, e);
                    this.newRequestUrl = null;
                }
                finally {
                    this.release();
                }
                oldRequestUrl = currentUrl;
                currentUrl = this.newRequestUrl;
            }
            originalRequestUrl = null;
            url = null;
            this.requestUrl = null;
            this.newRequestUrl = null;
            oldRequestUrl = null;
            String string = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void receiveRequest(String url) {
        if (OAIUtilities.checkString(url)) {
            try {
                URL rUrl = new URL(url);
                URLSource source = new URLSource(rUrl, this.manager);
                SourceParameters sp = new SourceParameters();
                sp.setParameter("user-agent", this.userAgent);
                for (int i = 0; i < this.adminEmails.length; ++i) {
                    String adminEmail = this.adminEmails[i];
                    sp.setParameter("from", adminEmail);
                }
                source.setRequestProperties(sp);
                OAIUtilities.logInfo(this.logger, "Begin reception of OAI response from url : " + url);
                source.toSAX((ContentHandler)((Object)this));
            }
            catch (Exception e) {
                OAIUtilities.logError(this.logger, url, e);
            }
            finally {
                OAIUtilities.logInfo(this.logger, "End reception of OAI response from url : " + url);
            }
        }
    }

    protected Parameters getHarvestParameters() {
        Parameters ret = new Parameters();
        if (this.requestParams != null) {
            ret.merge(this.requestParams);
        }
        ret.setParameter(OAI_REPOSITORY_URL, this.repoUrl);
        ret.setParameter(OAI_REQUEST_URL, this.requestUrl);
        for (int i = 0; i < this.adminEmails.length; ++i) {
            String adminEmail = this.adminEmails[i];
            ret.setParameter("adminEmail_" + Integer.toString(i), adminEmail);
        }
        return ret;
    }
}

