/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.utils;

import fr.gouv.culture.sdx.documentbase.DefaultIDGenerator;
import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 9 janv. 2004
 * Time: 13:56:53
 * To change this template use Options | File Templates.
 */
public class ConfigurationUtilities {

    public static IDGenerator configureIDGenerator(Logger logger, Configuration configuration) throws ConfigurationException {
        IDGenerator idGen = new DefaultIDGenerator();//we use the sdx default
        Configuration idGenConf = configuration.getChild(IDGenerator.ELEMENT_NAME_ID_GENERATOR, false);
        if (idGenConf != null) {
            //we attempt to use what is given
            String idGenClassName = idGenConf.getAttribute(IDGenerator.ATTRIBUTE_CLASS, IDGenerator.ATTRIBUTE_VALUE_DEFAULT_ID_GENERATOR_CLASS);
            try {
                Class idGenClass = Class.forName(idGenClassName);
                Object obj = idGenClass.newInstance();
                if (obj == null) {
                    String[] args = new String[1];
                    args[0] = idGenClassName;
                    SDXException sdxE = new SDXException(logger, SDXExceptionCode.ERROR_NEW_OBJECT_INSTANCE_NULL, args, null);
                    throw new ConfigurationException(sdxE.getMessage(), sdxE);
                }
                if (obj instanceof IDGenerator)
                    idGen = (IDGenerator) obj;
                else {
                    //the object doesn't implement our interface
                    String[] args = new String[3];
                    args[0] = IDGenerator.CLASS_NAME;
                    args[1] = idGenClass.getName();//getting the actual class name
                    args[2] = IDGenerator.CLASS_NAME;
                    SDXException sdxE = new SDXException(logger, SDXExceptionCode.ERROR_CLASS_NOT_INSTANCEOF_SDX_INTERFACE, null, null);
                    throw new ConfigurationException(sdxE.getMessage(), sdxE);
                }
                idGen.configure(idGenConf);
            } catch (ClassNotFoundException e) {
                SDXException sdxE = new SDXException(logger, SDXExceptionCode.ERROR_CONFIGURE_ID_GENERATOR, null, e);
                throw new ConfigurationException(sdxE.getMessage(), sdxE);
            } catch (InstantiationException e) {
                SDXException sdxE = new SDXException(logger, SDXExceptionCode.ERROR_CONFIGURE_ID_GENERATOR, null, e);
                throw new ConfigurationException(sdxE.getMessage(), sdxE);
            } catch (IllegalAccessException e) {
                SDXException sdxE = new SDXException(logger, SDXExceptionCode.ERROR_CONFIGURE_ID_GENERATOR, null, e);
                throw new ConfigurationException(sdxE.getMessage(), sdxE);
            }
        }

        return idGen;
    }
}
