/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.IStream;
import com.hp.hpl.mesa.rdf.jena.common.RDFDefaultErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.RDFReader;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;

public class NTripleReader
implements RDFReader {
    Model model = null;
    Hashtable anons = new Hashtable();
    IStream in = null;
    boolean inErr = false;
    int errCount = 0;
    RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    NTripleReader() {
    }

    public void read(Model model, Reader reader, String string) throws RDFException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.model = model;
        this.in = new IStream(reader);
        this.readRDF();
        if (this.errCount != 0) {
            throw new RDFException(24);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(Model model, String string) throws RDFException {
        try {
            try {
                this.read(model, new InputStreamReader(new URL(string).openStream()), string);
            }
            catch (Exception exception) {
                throw new RDFException(exception);
            }
            Object var5_3 = null;
            if (this.errCount == 0) return;
            throw new RDFException(24);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.errCount == 0) throw throwable;
            throw new RDFException(24);
        }
    }

    public Object setProperty(String string, Object object) throws RDFException {
        this.errorHandler.error(new RDFException(22));
        return null;
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    /*
     * Unable to fully structure code
     */
    protected void readRDF() throws RDFException {
        var2_1 = null;
        ** GOTO lbl42
        {
            block9: {
                block8: {
                    this.inErr = false;
                    this.skipWhiteSpace();
                    if (this.in.eof()) {
                        return;
                    }
                    var1_2 = this.readResource();
                    if (this.inErr) ** GOTO lbl38
                    this.skipWhiteSpace();
                    try {
                        var2_1 = this.model.createProperty(this.readResource().getURI());
                    }
                    catch (Exception var4_5) {
                        this.errorHandler.fatalError(var4_5);
                    }
                    if (this.inErr) ** GOTO lbl38
                    this.skipWhiteSpace();
                    var3_3 = this.readNode();
                    if (this.inErr) ** GOTO lbl38
                    this.skipWhiteSpace();
                    if (!this.in.eof()) break block8;
                    this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("premature end of file", this.in.getLinepos(), this.in.getCharpos())));
                    this.inErr = true;
                    ** GOTO lbl38
                }
                if (this.in.readChar() == '.') break block9;
                this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("expected '.'", this.in.getLinepos(), this.in.getCharpos())));
                this.inErr = true;
                ** GOTO lbl38
            }
            try {
                this.model.add(var1_2, var2_1, var3_3);
            }
            catch (Exception var4_6) {
                this.errorHandler.fatalError(var4_6);
            }
            do {
                if (!this.in.eof()) continue block4;
lbl38:
                // 6 sources

                if (!this.inErr) continue;
                ++this.errCount;
                while (!this.in.eof() && this.in.readChar() != '\n') {
                }
lbl42:
                // 3 sources

            } while (!this.in.eof());
        }
    }

    public Resource readResource() throws RDFException {
        char c = this.in.readChar();
        if (this.in.eof()) {
            this.inErr = true;
            return null;
        }
        if (c == '_') {
            c = this.in.readChar();
            if (this.in.eof()) {
                this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("premature end of file", this.in.getLinepos(), this.in.getCharpos())));
                this.inErr = true;
                return null;
            }
            if (c != ':') {
                this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("expected ':'", this.in.getLinepos(), this.in.getCharpos())));
                this.inErr = true;
                return null;
            }
            String string = this.readName();
            if (string == null) {
                this.inErr = true;
                return null;
            }
            return this.lookupResource(string);
        }
        if (c == '<') {
            String string = this.readURI();
            if (string == null) {
                this.inErr = true;
                return null;
            }
            c = this.in.readChar();
            if (c != '>') {
                this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("expected '>'", this.in.getLinepos(), this.in.getCharpos())));
                this.inErr = true;
                return null;
            }
            return this.model.createResource(string);
        }
        this.inErr = true;
        return null;
    }

    public RDFNode readNode() throws RDFException {
        this.skipWhiteSpace();
        if (this.in.nextChar() == '\"') {
            return this.readLiteral();
        }
        return this.readResource();
    }

    protected Literal readLiteral() throws RDFException {
        String string = "";
        int n = this.in.readChar();
        if (n != 34) {
            this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("expected '\"'", this.in.getLinepos(), this.in.getCharpos())));
            this.inErr = true;
            return null;
        }
        while (true) {
            n = this.in.readChar();
            if (this.in.eof()) {
                this.inErr = true;
                return null;
            }
            if (n == 92) {
                char c = this.in.readChar();
                if (this.in.eof()) {
                    this.inErr = true;
                    return null;
                }
                if (c == 'n') {
                    n = 10;
                } else if (c == 'r') {
                    n = 13;
                } else if (c == 't') {
                    n = 9;
                } else if (c == '\\' || c == '\"') {
                    n = c;
                } else {
                    this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("illegal escape sequence '" + c + "'", this.in.getLinepos(), this.in.getCharpos())));
                }
            } else if (n == 34) {
                return this.model.createLiteral(string);
            }
            string = string + (char)n;
        }
    }

    protected String readURI() {
        String string = "";
        while (this.in.nextChar() != '>') {
            char c = this.in.readChar();
            if (this.in.eof()) {
                this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("premature end of file", this.in.getLinepos(), this.in.getCharpos())));
                this.inErr = true;
                return null;
            }
            string = string + c;
        }
        return string;
    }

    protected String readName() {
        String string = "";
        while (!Character.isWhitespace(this.in.nextChar())) {
            string = string + this.in.readChar();
            if (!this.in.eof()) continue;
            this.errorHandler.error(new RDFException(24, this.syntaxErrorMessage("premature end of file", this.in.getLinepos(), this.in.getCharpos())));
            this.inErr = true;
            return null;
        }
        return string;
    }

    protected void skipWhiteSpace() {
        while (Character.isWhitespace(this.in.nextChar()) || this.in.nextChar() == '#') {
            char c = this.in.readChar();
            if (this.in.eof()) {
                return;
            }
            if (c != '#') continue;
            while (c != '\n') {
                c = this.in.readChar();
                if (!this.in.eof()) continue;
                return;
            }
        }
    }

    protected Resource lookupResource(String string) throws RDFException {
        Resource resource = (Resource)this.anons.get(string);
        if (resource == null) {
            resource = this.model.createResource();
            this.anons.put(string, resource);
        }
        return resource;
    }

    protected String syntaxErrorMessage(String string, int n, int n2) {
        return "syntax error at line " + n + " position " + n2 + ": " + string;
    }
}

