/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.environment.Environment;

public final class CategoryNode
extends AbstractParentProcessingNode {
    private String categoryName;
    private Map nodes;

    public void setCategory(String categoryName, Map nodes) {
        this.categoryName = categoryName;
        this.nodes = nodes != null ? nodes : new HashMap(0);
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        String msg = "Cannot invoke " + this.categoryName + " at " + this.getLocation();
        this.getLogger().error(msg);
        throw new ProcessingException(msg);
    }

    public final ProcessingNode getNodeByName(String name) throws Exception {
        ProcessingNode node = (ProcessingNode)this.nodes.get(name);
        if (node == null) {
            String msg = "Unknown " + this.categoryName + " named '" + name + "' at " + this.getLocation();
            this.getLogger().error(msg);
            throw new ProcessingException(msg);
        }
        return node;
    }

    public final boolean invokeByName(String name, Environment env, InvokeContext context) throws Exception {
        return this.getNodeByName(name).invoke(env, context);
    }
}

