/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpSharedState;
import org.apache.commons.httpclient.HttpUrlMethod;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public class HttpMultiClient {
    private static final Log log = LogSource.getInstance("org.apache.commons.httpclient.HttpMultiClient");
    private HttpSharedState state = null;
    private HttpConnectionManager mgr = new HttpConnectionManager();
    private boolean strictMode = true;
    private int timeoutConnection = 0;
    private int timeoutRequest = 0;

    public void setState(HttpSharedState state) {
        this.state = state;
    }

    public HttpSharedState getState() {
        if (this.state == null) {
            this.state = new HttpSharedState();
        }
        return this.state;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public void setConnectionTimeout(int timeout) {
        this.timeoutConnection = timeout;
    }

    public int getConnectionTimeout() {
        return this.timeoutConnection;
    }

    public void setRequestTimeout(int timeout) {
        this.timeoutRequest = timeout;
    }

    public int getRequestTimeout() {
        return this.timeoutRequest;
    }

    public int executeMethod(HttpUrlMethod method) throws IOException, HttpException {
        if (null == method) {
            throw new NullPointerException("method parameter");
        }
        HttpConnection connection = this.mgr.getConnection(method.getUrl(), this.timeoutConnection);
        connection.setSoTimeout(this.timeoutRequest);
        int status = 0;
        method.setStrictMode(this.strictMode);
        try {
            try {
                status = method.execute(this.getState(), connection);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (HttpException ex) {
                throw ex;
            }
            Object var7_4 = null;
            this.mgr.releaseConnection(connection);
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.mgr.releaseConnection(connection);
            throw throwable;
        }
        if (status == 301 || status == 302 || status == 303 || status == 307) {
            Header header = method.getResponseHeader("Location");
            String url = header.getValue();
            if (url == null) {
                log.error("HttpMultiClient.executeMethod:  Received redirect without Location header.");
                throw new HttpException("Received redirect without Location header.");
            }
            method.recycle();
            method.setUrl(url);
            return this.executeMethod(method);
        }
        return status;
    }
}

