/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class Expression
implements Serializable {
    protected SourceLocator m_slocator;

    public boolean canTraverseOutsideSubtree() {
        return false;
    }

    public void setSourceLocator(SourceLocator locator) {
        this.m_slocator = locator;
    }

    public XObject execute(XPathContext xctxt, int currentNode) throws TransformerException {
        return this.execute(xctxt);
    }

    public XObject execute(XPathContext xctxt, int currentNode, DTM dtm, int expType) throws TransformerException {
        return this.execute(xctxt);
    }

    public abstract XObject execute(XPathContext var1) throws TransformerException;

    public double num(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt).num();
    }

    public boolean bool(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt).bool();
    }

    public XMLString xstr(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt).xstr();
    }

    public boolean isNodesetExpr() {
        return false;
    }

    public int asNode(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt).iter().nextNode();
    }

    public DTMIterator asIterator(XPathContext xctxt, int contextNode) throws TransformerException {
        try {
            xctxt.pushCurrentNodeAndExpression(contextNode, contextNode);
            DTMIterator dTMIterator = this.execute(xctxt).iter();
            Object var5_4 = null;
            xctxt.popCurrentNodeAndExpression();
            return dTMIterator;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            xctxt.popCurrentNodeAndExpression();
            throw throwable;
        }
    }

    public void executeCharsToContentHandler(XPathContext xctxt, ContentHandler handler) throws TransformerException, SAXException {
        XObject obj = this.execute(xctxt);
        obj.dispatchCharactersEvents(handler);
    }

    public boolean isStableNumber() {
        return false;
    }

    public abstract void fixupVariables(Vector var1, int var2);

    public void warn(XPathContext xctxt, int msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHWarning(msg, args);
        if (null != xctxt) {
            ErrorListener eh = xctxt.getErrorListener();
            eh.warning(new TransformerException(fmsg, xctxt.getSAXLocator()));
        }
    }

    public void assertion(boolean b, String msg) throws TransformerException {
        if (!b) {
            String fMsg = XSLMessages.createXPATHMessage(30, new Object[]{msg});
            throw new RuntimeException(fMsg);
        }
    }

    public void error(XPathContext xctxt, int msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHMessage(msg, args);
        if (null != xctxt) {
            ErrorListener eh = xctxt.getErrorListener();
            TransformerException te = new TransformerException(fmsg, this.m_slocator);
            eh.fatalError(te);
        }
    }
}

