/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.main;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import org.jfor.jfor.converter.Converter;
import org.jfor.jfor.converter.IConverterOption;
import org.jfor.jfor.main.JForVersionInfo;
import org.xml.sax.InputSource;

public class CmdLineConverter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        try {
            try {
                if (stringArray.length < 2) {
                    System.err.println("Usage: CmdLineConverter <xsl:fo input file> <rtf output file>");
                    System.exit(1);
                }
                String string = System.getProperty("user.dir");
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                InputSource inputSource = new InputSource(string2);
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string3));
                CmdLineConverter.setUserDir(new File(string2).getCanonicalFile().getParent());
                System.err.println(JForVersionInfo.getLongVersionInfo());
                System.err.println("Converting XSL:FO file '" + string2 + "' to RTF output '" + string3 + "'...");
                new Converter(inputSource, (Writer)bufferedWriter, (IConverterOption)Converter.createConverterOption());
                System.err.println("Done writing RTF output '" + string3 + "'.");
                CmdLineConverter.setUserDir(string);
            }
            catch (Exception exception) {
                System.out.println(exception);
                Object var7_8 = null;
                System.exit(0);
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            System.exit(0);
            throw throwable;
        }
        System.exit(0);
    }

    private static String fileToUrl(String string) throws MalformedURLException {
        return CmdLineConverter.toURL(new File(string)).toString();
    }

    private static void setUserDir(String string) {
        if (string == null) {
            System.out.println("relative image path is not supported");
            return;
        }
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("user.dir", string);
        System.setProperties(properties);
    }

    private static URL toURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }
}

