/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;

public class IndexSearcher
extends Searcher {
    IndexReader reader;

    public IndexSearcher(String path) throws IOException {
        this(IndexReader.open(path));
    }

    public IndexSearcher(Directory directory) throws IOException {
        this(IndexReader.open(directory));
    }

    public IndexSearcher(IndexReader r) {
        this.reader = r;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    public Document doc(int i) throws IOException {
        return this.reader.document(i);
    }

    public int maxDoc() throws IOException {
        return this.reader.maxDoc();
    }

    public TopDocs search(Query query, Filter filter, int nDocs) throws IOException {
        Scorer scorer = query.weight(this).scorer(this.reader);
        if (scorer == null) {
            return new TopDocs(0, new ScoreDoc[0]);
        }
        final BitSet bits = filter != null ? filter.bits(this.reader) : null;
        final HitQueue hq = new HitQueue(nDocs);
        final int[] totalHits = new int[1];
        scorer.score(new HitCollector(){

            public final void collect(int doc, float score) {
                if (score > 0.0f && (bits == null || bits.get(doc))) {
                    totalHits[0] = totalHits[0] + 1;
                    hq.insert(new ScoreDoc(doc, score));
                }
            }
        }, this.reader.maxDoc());
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        int i = hq.size() - 1;
        while (i >= 0) {
            scoreDocs[i] = (ScoreDoc)hq.pop();
            --i;
        }
        return new TopDocs(totalHits[0], scoreDocs);
    }

    public void search(Query query, Filter filter, final HitCollector results) throws IOException {
        Scorer scorer;
        HitCollector collector = results;
        if (filter != null) {
            final BitSet bits = filter.bits(this.reader);
            collector = new HitCollector(){

                public final void collect(int doc, float score) {
                    if (bits.get(doc)) {
                        results.collect(doc, score);
                    }
                }
            };
        }
        if ((scorer = query.weight(this).scorer(this.reader)) == null) {
            return;
        }
        scorer.score(collector, this.reader.maxDoc());
    }

    public Query rewrite(Query original) throws IOException {
        Query query = original;
        Query rewrittenQuery = query.rewrite(this.reader);
        while (rewrittenQuery != query) {
            query = rewrittenQuery;
            rewrittenQuery = query.rewrite(this.reader);
        }
        return query;
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return query.weight(this).explain(this.reader, doc);
    }
}

