/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.nongnu.pulsefire.device.DeviceCommandListener;
import org.nongnu.pulsefire.device.DeviceData;
import org.nongnu.pulsefire.device.ui.JComponentEnableStateListener;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingListener;
import org.nongnu.pulsefire.device.ui.SpringLayoutGrid;
import org.nongnu.pulsefire.device.ui.components.JCommandButton;
import org.nongnu.pulsefire.device.ui.components.JCommandDial;
import org.nongnu.pulsefire.device.ui.components.JCommandSettingListDialog;
import org.nongnu.pulsefire.device.ui.components.JFireQMapTable;
import org.nongnu.pulsefire.device.ui.components.JIntegerTextField;
import org.nongnu.pulsefire.device.ui.tabs.AbstractFireTabPanel;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;
import org.nongnu.pulsefire.wire.CommandVariableType;

public class JTabPanelLpm
extends AbstractFireTabPanel
implements ActionListener,
TableModelListener,
DeviceCommandListener,
PulseFireUISettingListener {
    private static final long serialVersionUID = -6711428986888517858L;
    private JTable tuneStepTable = null;
    private JTable tuneResultTable = null;
    private LpmTuneStepTableModel tuneStepModel = null;
    private LpmTuneResultTableModel tuneResultModel = null;
    private JProgressBar progressBar = null;
    private JLabel lpmStepLabel = null;
    private JButton stepEditButton = null;
    private JButton stepAddButton = null;
    private JButton stepDelButton = null;
    private JButton lpmAutoStartButton = null;
    private JButton lpmAutoCancelButton = null;
    private JButton lpmAutoLoopButton = null;
    private JButton lpmTuneStartButton = null;
    private JButton lpmTuneStopButton = null;
    private JButton lpmTuneNextButton = null;
    private JButton resultFieldsButton = null;
    private JButton resultClearButton = null;
    private JButton resultExportButton = null;
    private List<CommandName> stepFields = CommandName.decodeCommandList((String)PulseFireUI.getInstance().getSettingsManager().getSettingString(PulseFireUISettingKeys.LPM_RESULT_FIELDS));
    private boolean updateProgress = false;
    private boolean runSingle = false;
    private boolean runLoop = false;
    private boolean runTune = false;
    private int tuneStep = 0;
    private List<LpmCommandStep> tuneCommandSteps = new ArrayList<LpmCommandStep>(4000);

    public JTabPanelLpm() {
        this.setLayout(new FlowLayout(0));
        JPanel wrap = new JPanel();
        wrap.setLayout(new SpringLayout());
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new SpringLayout());
        leftPanel.add(this.createLpmConfig());
        leftPanel.add(this.createLpmTuneConfig());
        leftPanel.add(this.createLpmTune());
        SpringLayoutGrid.makeCompactGrid(leftPanel, 3, 1);
        wrap.add(leftPanel);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new FlowLayout(0, 0, 0));
        JPanel wrapRightPanel = new JPanel();
        wrapRightPanel.add(this.createLpmTuneResult());
        rightPanel.add(wrapRightPanel);
        wrap.add(rightPanel);
        SpringLayoutGrid.makeCompactGrid(wrap, 1, 2, 0, 0, 0, 0);
        this.add(wrap);
        PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(CommandName.lpm_done, (DeviceCommandListener)this);
        PulseFireUI.getInstance().getDeviceManager().addDeviceCommandListener(CommandName.lpm_level, (DeviceCommandListener)this);
        PulseFireUI.getInstance().getSettingsManager().addSettingListener(PulseFireUISettingKeys.LPM_RESULT_FIELDS, this);
    }

    private JPanel createLpmConfig() {
        JPanel configPanel = JComponentFactory.createJFirePanel("Lpm Config");
        configPanel.setLayout(new BorderLayout());
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new FlowLayout(0));
        inputPanel.add(JComponentFactory.createJLabel("Start"));
        inputPanel.add(JComponentFactory.createJPanelJWrap(new JCommandDial(CommandName.lpm_start)));
        inputPanel.add(JComponentFactory.createJLabel("Stop"));
        inputPanel.add(JComponentFactory.createJPanelJWrap(new JCommandDial(CommandName.lpm_stop)));
        inputPanel.add(JComponentFactory.createJLabel("Size"));
        inputPanel.add(JComponentFactory.createJPanelJWrap(new JCommandDial(CommandName.lpm_size)));
        inputPanel.add(JComponentFactory.createJLabel("Relay"));
        JPanel relayMapPanel = new JPanel();
        relayMapPanel.setLayout(new FlowLayout(0, 0, 0));
        relayMapPanel.add(new JFireQMapTable(CommandName.lpm_relay_map, "Open", "Close"));
        configPanel.add((Component)inputPanel, "Center");
        configPanel.add((Component)relayMapPanel, "South");
        return configPanel;
    }

    private JPanel createLpmTuneConfig() {
        JPanel panel = JComponentFactory.createJFirePanel("Actions");
        panel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new SpringLayout());
        JPanel butSinglePanel = new JPanel();
        butSinglePanel.setLayout(new FlowLayout(0));
        JPanel butTunePanel = new JPanel();
        butTunePanel.setLayout(new FlowLayout(0));
        this.lpmAutoStartButton = new JCommandButton(CommandName.req_trigger, CommandName.lpm_fire, null);
        this.lpmAutoLoopButton = new JButton("Loop");
        this.lpmAutoCancelButton = new JButton("Cancel");
        this.lpmTuneStartButton = new JButton("Start");
        this.lpmTuneStopButton = new JButton("Stop");
        this.lpmTuneNextButton = new JButton("Next");
        butSinglePanel.add(this.lpmAutoStartButton);
        butSinglePanel.add(this.lpmAutoLoopButton);
        butSinglePanel.add(this.lpmAutoCancelButton);
        butTunePanel.add(this.lpmTuneStartButton);
        butTunePanel.add(this.lpmTuneStopButton);
        butTunePanel.add(this.lpmTuneNextButton);
        this.lpmAutoStartButton.addActionListener(this);
        this.lpmAutoLoopButton.addActionListener(this);
        this.lpmAutoCancelButton.addActionListener(this);
        this.lpmTuneStartButton.addActionListener(this);
        this.lpmTuneStopButton.addActionListener(this);
        this.lpmTuneNextButton.addActionListener(this);
        this.lpmTuneStartButton.setEnabled(false);
        this.lpmAutoLoopButton.setEnabled(false);
        this.lpmTuneStopButton.setEnabled(false);
        this.lpmTuneNextButton.setEnabled(false);
        this.lpmAutoCancelButton.setEnabled(false);
        JPanel barPanel = new JPanel();
        barPanel.setLayout(new FlowLayout(0));
        this.progressBar = new JProgressBar();
        barPanel.add(this.progressBar);
        barPanel.add(JComponentFactory.createJLabel("Steps"));
        this.lpmStepLabel = new JLabel("0/0");
        barPanel.add(this.lpmStepLabel);
        topPanel.add(JComponentFactory.createJLabel("Auto Lpm"));
        topPanel.add(butSinglePanel);
        topPanel.add(JComponentFactory.createJLabel("Auto Tune"));
        topPanel.add(butTunePanel);
        topPanel.add(JComponentFactory.createJLabel("Progress"));
        topPanel.add(barPanel);
        SpringLayoutGrid.makeCompactGrid(topPanel, 3, 2, 6, 0, 0, 0);
        panel.add(topPanel);
        return panel;
    }

    private JPanel createLpmTune() {
        JPanel panel = JComponentFactory.createJFirePanel("Auto Tune");
        panel.setLayout(new BorderLayout());
        this.tuneStepModel = new LpmTuneStepTableModel();
        this.tuneStepModel.addTableModelListener(this);
        this.tuneStepTable = new JTable(this.tuneStepModel);
        this.tuneStepTable.getTableHeader().setReorderingAllowed(false);
        this.tuneStepTable.setAutoResizeMode(0);
        this.tuneStepTable.setFillsViewportHeight(true);
        this.tuneStepTable.setShowHorizontalLines(true);
        this.tuneStepTable.setSelectionMode(0);
        this.tuneStepTable.setRowMargin(2);
        this.tuneStepTable.setRowHeight(26);
        this.tuneStepTable.getColumnModel().getColumn(0).setPreferredWidth(55);
        this.tuneStepTable.getColumnModel().getColumn(1).setPreferredWidth(160);
        this.tuneStepTable.getColumnModel().getColumn(2).setPreferredWidth(55);
        this.tuneStepTable.getColumnModel().getColumn(3).setPreferredWidth(55);
        this.tuneStepTable.getColumnModel().getColumn(4).setPreferredWidth(55);
        this.tuneStepTable.getColumnModel().getColumn(5).setPreferredWidth(55);
        this.tuneStepTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LpmTuneStep step = JTabPanelLpm.this.tuneStepModel.dataGet(JTabPanelLpm.this.tuneStepTable.getSelectedRow());
                    JLpmTuneStepDialog dialog = new JLpmTuneStepDialog(PulseFireUI.getInstance().getMainFrame(), step);
                    dialog.setVisible(true);
                }
            }
        });
        ToolTipManager.sharedInstance().unregisterComponent(this.tuneStepTable);
        ToolTipManager.sharedInstance().unregisterComponent(this.tuneStepTable.getTableHeader());
        JScrollPane scroll = new JScrollPane(this.tuneStepTable);
        scroll.setPreferredSize(new Dimension(450, 120));
        panel.add((Component)scroll, "Center");
        JPanel tableActions = new JPanel();
        tableActions.setLayout(new FlowLayout(2));
        this.stepAddButton = new JButton("Add");
        this.stepEditButton = new JButton("Edit");
        this.stepDelButton = new JButton("Delete");
        JComponentEnableStateListener.attach(this.stepAddButton);
        JComponentEnableStateListener.attach(this.stepEditButton);
        JComponentEnableStateListener.attach(this.stepDelButton);
        this.stepAddButton.addActionListener(this);
        this.stepEditButton.addActionListener(this);
        this.stepDelButton.addActionListener(this);
        tableActions.add(this.stepAddButton);
        tableActions.add(this.stepEditButton);
        tableActions.add(this.stepDelButton);
        panel.add((Component)tableActions, "South");
        return panel;
    }

    private JPanel createLpmTuneResult() {
        JPanel panel = JComponentFactory.createJFirePanel("Lpm Results");
        panel.setLayout(new BorderLayout());
        this.tuneResultModel = new LpmTuneResultTableModel();
        this.tuneResultModel.addTableModelListener(this);
        this.tuneResultTable = new JTable(this.tuneResultModel);
        this.tuneResultTable.getTableHeader().setReorderingAllowed(false);
        this.tuneResultTable.setAutoResizeMode(0);
        this.tuneResultTable.setFillsViewportHeight(true);
        this.tuneResultTable.setShowHorizontalLines(true);
        this.tuneResultTable.setSelectionMode(0);
        this.tuneResultTable.setRowMargin(2);
        this.tuneResultTable.setRowHeight(26);
        this.tuneResultTable.getColumnModel().getColumn(0).setPreferredWidth(220);
        this.tuneResultTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.tuneResultTable.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.tuneResultTable.getColumnModel().getColumn(3).setPreferredWidth(80);
        ToolTipManager.sharedInstance().unregisterComponent(this.tuneResultTable);
        ToolTipManager.sharedInstance().unregisterComponent(this.tuneResultTable.getTableHeader());
        JScrollPane scroll = new JScrollPane(this.tuneResultTable);
        scroll.setPreferredSize(new Dimension(700, 500));
        panel.add((Component)scroll, "Center");
        JPanel tableActions = new JPanel();
        tableActions.setLayout(new FlowLayout(2));
        this.resultFieldsButton = new JButton("Fields");
        this.resultClearButton = new JButton("Clear");
        this.resultExportButton = new JButton("Export");
        this.resultFieldsButton.addActionListener(this);
        this.resultClearButton.addActionListener(this);
        this.resultExportButton.addActionListener(this);
        this.resultClearButton.setEnabled(false);
        this.resultExportButton.setEnabled(false);
        tableActions.add(this.resultFieldsButton);
        tableActions.add(this.resultClearButton);
        tableActions.add(this.resultExportButton);
        panel.add((Component)tableActions, "South");
        return panel;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }

    @Override
    public void deviceConnect() {
        super.deviceConnect();
        this.lpmAutoLoopButton.setEnabled(true);
    }

    @Override
    public void deviceDisconnect() {
        super.deviceConnect();
        this.lpmAutoLoopButton.setEnabled(false);
    }

    private void requestLpm() {
        Command cmd = new Command(CommandName.req_trigger);
        cmd.setArgu0(CommandName.lpm_fire.name());
        PulseFireUI.getInstance().getDeviceManager().requestCommand(cmd);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.stepEditButton.equals(e.getSource()) && this.tuneStepTable.getSelectedRow() != -1) {
            LpmTuneStep step = this.tuneStepModel.dataGet(this.tuneStepTable.getSelectedRow());
            JLpmTuneStepDialog dialog = new JLpmTuneStepDialog(PulseFireUI.getInstance().getMainFrame(), step);
            dialog.setVisible(true);
        } else if (this.stepAddButton.equals(e.getSource())) {
            LpmTuneStep step = new LpmTuneStep();
            for (int i = 0; i < this.tuneStepModel.getRowCount(); ++i) {
                LpmTuneStep s = this.tuneStepModel.dataGet(i);
                if (s.getOrder() <= step.getOrder()) continue;
                step.setOrder(s.getOrder() + 10);
            }
            JLpmTuneStepDialog dialog = new JLpmTuneStepDialog(PulseFireUI.getInstance().getMainFrame(), step);
            dialog.setVisible(true);
        } else if (this.stepDelButton.equals(e.getSource()) && this.tuneStepTable.getSelectedRow() != -1) {
            this.tuneStepModel.dataRemove(this.tuneStepTable.getSelectedRow());
            this.tuneStepModel.fireTableDataChanged();
        } else if (this.lpmAutoStartButton.equals(e.getSource())) {
            this.lpmAutoCancelButton.setEnabled(true);
            this.lpmAutoLoopButton.setEnabled(false);
            this.lpmAutoStartButton.setEnabled(false);
            this.lpmTuneStartButton.setEnabled(false);
            this.stepEditButton.setEnabled(false);
            this.stepAddButton.setEnabled(false);
            this.stepDelButton.setEnabled(false);
            this.updateProgress = true;
            this.runSingle = true;
        } else if (this.lpmAutoLoopButton.equals(e.getSource())) {
            this.requestLpm();
            this.updateProgress = true;
            this.runLoop = true;
            this.lpmAutoCancelButton.setEnabled(true);
            this.lpmAutoLoopButton.setEnabled(false);
            this.lpmAutoStartButton.setEnabled(false);
            this.lpmTuneStartButton.setEnabled(false);
        } else if (this.lpmAutoCancelButton.equals(e.getSource())) {
            this.requestLpm();
            this.updateProgress = true;
            this.runLoop = false;
            this.lpmAutoLoopButton.setEnabled(true);
            this.lpmAutoStartButton.setEnabled(true);
            this.lpmTuneStartButton.setEnabled(true);
            this.stepEditButton.setEnabled(true);
            this.stepAddButton.setEnabled(true);
            this.stepDelButton.setEnabled(true);
        } else if (this.lpmTuneStartButton.equals(e.getSource())) {
            this.lpmAutoStartButton.setEnabled(false);
            this.lpmTuneStartButton.setEnabled(false);
            this.lpmTuneStopButton.setEnabled(true);
            this.lpmTuneNextButton.setEnabled(true);
            this.runTune = true;
            this.tuneStep = 0;
            this.calcCommandSteps();
            this.requestCommandStep();
        } else if (this.lpmTuneStopButton.equals(e.getSource())) {
            this.lpmAutoStartButton.setEnabled(true);
            this.lpmTuneStartButton.setEnabled(true);
            this.lpmTuneStopButton.setEnabled(false);
            this.lpmTuneNextButton.setEnabled(false);
            this.runTune = false;
        } else if (this.lpmTuneNextButton.equals(e.getSource())) {
            this.updateProgress = false;
            this.progressBar.setValue(0);
            this.requestCommandStep();
        } else if (this.resultFieldsButton.equals(e.getSource())) {
            ArrayList<CommandName> commands = new ArrayList<CommandName>(100);
            for (CommandName cn : CommandName.values()) {
                if (CommandVariableType.CMD == cn.getType() || CommandVariableType.INFO == cn.getType()) continue;
                commands.add(cn);
            }
            JCommandSettingListDialog dialog = new JCommandSettingListDialog(PulseFireUI.getInstance().getMainFrame(), "Select Lpm Result Fields", "Select the fields to log with the lpm result.", PulseFireUISettingKeys.LPM_RESULT_FIELDS, commands, commands);
            dialog.setVisible(true);
        } else if (this.resultClearButton.equals(e.getSource())) {
            this.tuneResultModel.dataClear();
        } else if (this.resultExportButton.equals(e.getSource())) {
            JFileChooser fc = new JFileChooser();
            fc.setApproveButtonText("Save");
            fc.setSelectedFile(new File("lpm-results.csv"));
            int returnVal = fc.showOpenDialog((JButton)e.getSource());
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this.writeExport(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeExport(File file) {
        String FIELD_QUOTE = "\"";
        String FIELD_SEPERATOR = ",";
        String FIELD_END = System.getProperty("line.separator");
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), Charset.forName("UTF-8"));
            writer.append("#");
            for (int c = 0; c < this.tuneResultModel.getColumnCount(); ++c) {
                writer.append(this.tuneResultModel.getColumnName(c));
                if (c >= this.tuneResultModel.getColumnCount() - 1) continue;
                writer.append(FIELD_SEPERATOR);
            }
            writer.append(FIELD_END);
            for (int i = 0; i < this.tuneResultModel.getRowCount(); ++i) {
                for (int c = 0; c < this.tuneResultModel.getColumnCount(); ++c) {
                    writer.append(FIELD_QUOTE);
                    writer.append(this.tuneResultModel.getValueAt(i, c).toString());
                    writer.append(FIELD_QUOTE);
                    if (c >= this.tuneResultModel.getColumnCount() - 1) continue;
                    writer.append(FIELD_SEPERATOR);
                }
                writer.append(FIELD_END);
                writer.flush();
            }
            writer.append(FIELD_END);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.tuneResultModel.equals(e.getSource())) {
            if (this.tuneResultModel.getRowCount() > 0) {
                this.resultClearButton.setEnabled(true);
                this.resultExportButton.setEnabled(true);
            } else {
                this.resultClearButton.setEnabled(false);
                this.resultExportButton.setEnabled(false);
            }
            return;
        }
        if (this.tuneStepModel.getRowCount() > 0) {
            this.lpmTuneStartButton.setEnabled(true);
        } else {
            this.lpmTuneStartButton.setEnabled(false);
        }
        this.updateStepLabel();
        this.tuneResultModel.fireTableStructureChanged();
    }

    private void updateStepLabel() {
        int stepsTotal = 0;
        for (int i = 0; i < this.tuneStepModel.getRowCount(); ++i) {
            LpmTuneStep s = this.tuneStepModel.dataGet(i);
            int ss = (s.getValueStop() - s.getValueStart()) / s.getValueStep();
            if (stepsTotal != 0) {
                stepsTotal *= ss;
                continue;
            }
            stepsTotal = ss;
        }
        this.lpmStepLabel.setText(this.tuneStep + "/" + stepsTotal);
    }

    public void commandReceived(Command command) {
        if (CommandName.lpm_done.equals((Object)command.getCommandName())) {
            if ("done".equals(command.getArgu0())) {
                return;
            }
            LpmTuneResult result = new LpmTuneResult();
            result.setDate(new Date());
            result.setLpmResult(command.getArgu0());
            result.setLpmTime(command.getArgu1());
            result.setMmwResult("");
            for (CommandName cn : this.stepFields) {
                result.getStepFields().add(this.renderStepField(cn));
            }
            for (int i = 0; i < this.tuneStepModel.getRowCount(); ++i) {
                if (this.runTune) {
                    LpmCommandStep step = this.tuneCommandSteps.get(this.tuneStep);
                    if (step.commands.size() > i) {
                        Command c = step.commands.get(i);
                        result.getStepData().add(c.getArgu0());
                        continue;
                    }
                    result.getStepData().add("");
                    continue;
                }
                result.getStepData().add("");
            }
            this.tuneResultModel.dataAdd(result);
            this.progressBar.setValue(0);
            this.updateProgress = false;
            if (this.runSingle) {
                this.runSingle = false;
                this.lpmAutoCancelButton.setEnabled(false);
                this.lpmAutoLoopButton.setEnabled(true);
                this.lpmAutoStartButton.setEnabled(true);
                if (this.tuneStepModel.getRowCount() > 0) {
                    this.lpmTuneStartButton.setEnabled(true);
                }
                return;
            }
            if (this.runLoop) {
                PulseFireUI.getInstance().getEventTimeManager().addRunOnce(new TriggerFire());
                return;
            }
            if (this.runTune) {
                ++this.tuneStep;
                this.requestCommandStep();
                return;
            }
        } else if (CommandName.lpm_level.equals((Object)command.getCommandName()) && this.updateProgress && this.runSingle | this.runLoop | this.runTune) {
            Command lpmStartCmd = PulseFireUI.getInstance().getDeviceData().getDeviceParameter(CommandName.lpm_start);
            Command lpmStopCmd = PulseFireUI.getInstance().getDeviceData().getDeviceParameter(CommandName.lpm_stop);
            if (lpmStartCmd != null && lpmStopCmd != null) {
                int lpmStop;
                int stepSize;
                int lpmLevel = new Integer(command.getArgu0());
                int lpmStart = new Integer(lpmStartCmd.getArgu0());
                int stepProgress = (lpmStart - lpmLevel) / (stepSize = (lpmStart - (lpmStop = new Integer(lpmStopCmd.getArgu0()).intValue())) / 100);
                if (stepProgress < 0 | stepProgress > 100) {
                    stepProgress = 0;
                }
                this.progressBar.setValue(stepProgress);
            }
        }
    }

    @Override
    public void settingUpdated(PulseFireUISettingKeys key, String value) {
        this.stepFields = CommandName.decodeCommandList((String)value);
        this.tuneResultModel.fireTableStructureChanged();
    }

    private void calcCommandSteps() {
        if (this.tuneStepModel.getRowCount() == 0) {
            return;
        }
        this.tuneCommandSteps.clear();
        for (int i = 0; i < this.tuneStepModel.getRowCount(); ++i) {
            LpmTuneStep s = this.tuneStepModel.dataGet(i);
            s.setValueCurrent(s.getValueStart());
        }
        this.calcCommandStepsDeep(0);
    }

    private void calcCommandStepsDeep(int stepIndex) {
        if (stepIndex >= this.tuneStepModel.getRowCount()) {
            return;
        }
        LpmTuneStep step = this.tuneStepModel.dataGet(stepIndex);
        for (int ii = 0; ii < (step.getValueStop() - step.getValueStart()) / step.getValueStep(); ++ii) {
            step.setValueCurrent(step.getValueStart() + ii * step.getValueStep());
            this.calcCommandStepsDeep(stepIndex + 1);
            if (this.tuneStepModel.getRowCount() > stepIndex + 1) continue;
            LpmCommandStep cmd = new LpmCommandStep();
            long time = 0L;
            for (int i = 0; i < this.tuneStepModel.getRowCount(); ++i) {
                LpmTuneStep s = this.tuneStepModel.dataGet(i);
                Command c = new Command(s.getCommandName());
                c.setArgu0("" + s.getValueCurrent());
                if (s.getCommandName().isIndexedA()) {
                    c.setArgu1("" + s.getCommandIndex());
                }
                cmd.commands.add(c);
                long timeS = s.getRecoveryTime();
                if (timeS == 0L) {
                    timeS = 1L;
                }
                time += timeS;
            }
            cmd.recoveryTime = time;
            this.tuneCommandSteps.add(cmd);
        }
    }

    private void requestCommandStep() {
        if (this.tuneCommandSteps.isEmpty() || this.tuneStep >= this.tuneCommandSteps.size()) {
            this.tuneStep = 0;
            this.runTune = false;
            this.progressBar.setValue(0);
            this.lpmAutoStartButton.setEnabled(true);
            this.lpmTuneStartButton.setEnabled(true);
            this.lpmTuneStopButton.setEnabled(false);
            this.lpmTuneNextButton.setEnabled(false);
            this.stepEditButton.setEnabled(true);
            this.stepAddButton.setEnabled(true);
            this.stepDelButton.setEnabled(true);
        } else {
            PulseFireUI.getInstance().getEventTimeManager().addRunOnce(new TriggerFire());
        }
        this.updateStepLabel();
    }

    private String renderStepField(CommandName cn) {
        DeviceData devData = PulseFireUI.getInstance().getDeviceData();
        StringBuffer buf = new StringBuffer(200);
        String FIELD_SPACE = " ";
        String FIELD_SEPERATOR = ",";
        if (cn.isIndexedA()) {
            for (int i = 0; i < cn.getMaxIndexA(); ++i) {
                Command cmd = devData.getDeviceParameterIndexed(cn, Integer.valueOf(i));
                if (cmd != null) {
                    if (cn.isIndexedB()) {
                        buf.append(cmd.getArgu0());
                        if (cmd.getArgu1() != null) {
                            buf.append(FIELD_SPACE);
                            buf.append(cmd.getArgu1());
                        }
                        if (cmd.getArgu2() != null) {
                            buf.append(FIELD_SPACE);
                            buf.append(cmd.getArgu2());
                        }
                        if (cmd.getArgu3() != null) {
                            buf.append(FIELD_SPACE);
                            buf.append(cmd.getArgu3());
                        }
                        if (cmd.getArgu4() != null) {
                            buf.append(FIELD_SPACE);
                            buf.append(cmd.getArgu4());
                        }
                        if (cmd.getArgu5() != null) {
                            buf.append(FIELD_SPACE);
                            buf.append(cmd.getArgu5());
                        }
                        if (cmd.getArgu6() != null) {
                            buf.append(FIELD_SPACE);
                            buf.append(cmd.getArgu6());
                        }
                        if (cmd.getArgu7() != null) {
                            buf.append(FIELD_SPACE);
                            buf.append(cmd.getArgu7());
                        }
                    } else {
                        buf.append(cmd.getArgu0());
                    }
                } else {
                    buf.append(FIELD_SPACE);
                }
                if (i >= cn.getMaxIndexA() - 1) continue;
                buf.append(FIELD_SEPERATOR);
            }
        } else {
            Command cmd = devData.getDeviceParameter(cn);
            if (cmd != null) {
                buf.append(cmd.getArgu0());
            } else {
                buf.append(FIELD_SPACE);
            }
        }
        return buf.toString();
    }

    class TriggerFire
    implements Runnable {
        TriggerFire() {
        }

        @Override
        public void run() {
            try {
                if (JTabPanelLpm.this.runTune && JTabPanelLpm.this.tuneStep < JTabPanelLpm.this.tuneCommandSteps.size()) {
                    LpmCommandStep step = (LpmCommandStep)JTabPanelLpm.this.tuneCommandSteps.get(JTabPanelLpm.this.tuneStep);
                    for (Command cmd : step.commands) {
                        PulseFireUI.getInstance().getDeviceManager().requestCommand(cmd).waitForResponseChecked();
                    }
                    Thread.sleep(step.recoveryTime * 1000L);
                } else {
                    Thread.sleep(15000L);
                }
                if (JTabPanelLpm.this.runTune | JTabPanelLpm.this.runLoop) {
                    JTabPanelLpm.this.requestLpm();
                    JTabPanelLpm.this.updateProgress = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class LpmCommandStep {
        List<Command> commands = new ArrayList<Command>(10);
        long recoveryTime = 0L;

        LpmCommandStep() {
        }
    }

    class JLpmTuneStepDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 8511082377154332785L;
        private LpmTuneStep step;
        private JButton saveButton;
        private JButton cancelButton;
        private JIntegerTextField orderField;
        private JComboBox stepCommandBox;
        private JComboBox stepCommandIndexBox;
        private JIntegerTextField startValueField;
        private JIntegerTextField stopValueField;
        private JIntegerTextField stepValueField;
        private JIntegerTextField recoveryTimeField;

        public JLpmTuneStepDialog(Frame parentFrame, LpmTuneStep step) {
            super(parentFrame, true);
            this.step = null;
            this.saveButton = null;
            this.cancelButton = null;
            this.orderField = null;
            this.stepCommandBox = null;
            this.stepCommandIndexBox = null;
            this.startValueField = null;
            this.stopValueField = null;
            this.stepValueField = null;
            this.recoveryTimeField = null;
            this.step = step;
            this.setTitle("Edit Tune Step");
            this.setMinimumSize(new Dimension(300, 350));
            this.setPreferredSize(new Dimension(350, 350));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    JLpmTuneStepDialog.this.clearAndHide();
                }
            });
            JPanel mainPanel = new JPanel();
            mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add((Component)this.createPanelCenter(), "Center");
            mainPanel.add((Component)this.createPanelBottom(), "South");
            this.getContentPane().add(mainPanel);
            this.pack();
            this.setLocationRelativeTo(parentFrame);
        }

        public void clearAndHide() {
            this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.saveButton) {
                this.step.setOrder(this.orderField.getValue());
                this.step.setCommandName((CommandName)this.stepCommandBox.getSelectedItem());
                this.step.setCommandIndex(this.stepCommandBox.getSelectedIndex());
                this.step.setValueStart(this.startValueField.getValue());
                this.step.setValueStop(this.stopValueField.getValue());
                this.step.setValueStep(this.stepValueField.getValue());
                this.step.setRecoveryTime(this.recoveryTimeField.getValue());
                if (!JTabPanelLpm.this.tuneStepModel.dataContains(this.step)) {
                    JTabPanelLpm.this.tuneStepModel.dataAdd(this.step);
                } else {
                    JTabPanelLpm.this.tuneStepModel.fireDataReorder();
                }
                this.clearAndHide();
                return;
            }
            if (e.getSource() == this.cancelButton) {
                this.clearAndHide();
                return;
            }
            if (this.stepCommandBox.equals(e.getSource()) && this.stepCommandBox.getSelectedIndex() != -1) {
                CommandName cn = (CommandName)this.stepCommandBox.getSelectedItem();
                if (cn.isIndexedA()) {
                    this.stepCommandIndexBox.removeAllItems();
                    for (int i = 0; i < cn.getMaxIndexA(); ++i) {
                        this.stepCommandIndexBox.addItem("" + i);
                    }
                    this.stepCommandIndexBox.setEnabled(true);
                } else {
                    this.stepCommandIndexBox.setEnabled(false);
                }
            }
        }

        private JPanel createPanelCenter() {
            JPanel panel = new JPanel();
            panel.setLayout(new SpringLayout());
            panel.add(new JLabel("Order"));
            this.orderField = new JIntegerTextField(this.step.getOrder(), 6);
            panel.add(this.orderField);
            panel.add(new JLabel("Command"));
            List cmds = CommandName.valuesMapIndex();
            for (int i = 0; i < JTabPanelLpm.this.tuneStepModel.getRowCount(); ++i) {
                LpmTuneStep s = JTabPanelLpm.this.tuneStepModel.dataGet(i);
                if (s.getCommandName().equals((Object)this.step.getCommandName())) continue;
                cmds.remove(s.getCommandName());
            }
            this.stepCommandBox = new JComboBox<Object>(cmds.toArray());
            this.stepCommandBox.setSelectedItem(this.step.getCommandName());
            this.stepCommandBox.addActionListener(this);
            panel.add(this.stepCommandBox);
            panel.add(new JLabel("Index"));
            this.stepCommandIndexBox = new JComboBox();
            this.stepCommandIndexBox.setEnabled(false);
            panel.add(this.stepCommandIndexBox);
            panel.add(new JLabel("Start"));
            this.startValueField = new JIntegerTextField(this.step.getValueStart(), 6);
            panel.add(this.startValueField);
            panel.add(new JLabel("Stop"));
            this.stopValueField = new JIntegerTextField(this.step.getValueStop(), 6);
            panel.add(this.stopValueField);
            panel.add(new JLabel("Step"));
            this.stepValueField = new JIntegerTextField(this.step.getValueStep(), 6);
            panel.add(this.stepValueField);
            panel.add(new JLabel("Recovery Time"));
            this.recoveryTimeField = new JIntegerTextField(this.step.getRecoveryTime(), 6);
            panel.add(this.recoveryTimeField);
            SpringLayoutGrid.makeCompactGrid(panel, 7, 2);
            return panel;
        }

        private JPanel createPanelBottom() {
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createEmptyBorder());
            panel.setLayout(new FlowLayout(2));
            this.saveButton = new JButton("Save");
            this.saveButton.addActionListener(this);
            panel.add(this.saveButton);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            panel.add(this.cancelButton);
            return panel;
        }
    }

    public class LpmTuneResultTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1432038909521987705L;
        private String[] columnNames = new String[]{"Date", "LpmTime", "LpmResult", "LpmMmw"};
        private List<LpmTuneResult> data = new ArrayList<LpmTuneResult>(1000);

        public LpmTuneResult dataGet(int row) {
            if (row < this.data.size()) {
                return this.data.get(row);
            }
            return null;
        }

        public void dataAdd(LpmTuneResult result) {
            this.data.add(result);
            this.fireTableDataChanged();
        }

        public void dataClear() {
            this.data.clear();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length + JTabPanelLpm.this.tuneStepModel.getRowCount() + JTabPanelLpm.this.stepFields.size();
        }

        @Override
        public String getColumnName(int col) {
            if (col < this.columnNames.length) {
                return this.columnNames[col];
            }
            if (col - this.columnNames.length < JTabPanelLpm.this.tuneStepModel.getRowCount()) {
                return JTabPanelLpm.this.tuneStepModel.dataGet(col - this.columnNames.length).getCommandName().name();
            }
            if (col - this.columnNames.length - JTabPanelLpm.this.tuneStepModel.getRowCount() < JTabPanelLpm.this.stepFields.size()) {
                return ((CommandName)JTabPanelLpm.this.stepFields.get(col - this.columnNames.length - JTabPanelLpm.this.tuneStepModel.getRowCount())).name();
            }
            return "error";
        }

        @Override
        public Object getValueAt(int row, int col) {
            LpmTuneResult result = this.data.get(row);
            if (col < this.columnNames.length) {
                switch (col) {
                    default: {
                        return result.getDate();
                    }
                    case 1: {
                        return result.getLpmTime();
                    }
                    case 2: {
                        return result.getLpmResult();
                    }
                    case 3: 
                }
                return result.getMmwResult();
            }
            if (col - this.columnNames.length < JTabPanelLpm.this.tuneStepModel.getRowCount()) {
                if (result.getStepData().size() > col - this.columnNames.length) {
                    return result.getStepData().get(col - this.columnNames.length);
                }
                return "";
            }
            if (col - this.columnNames.length - JTabPanelLpm.this.tuneStepModel.getRowCount() < JTabPanelLpm.this.stepFields.size()) {
                if (result.getStepFields().size() > col - this.columnNames.length - JTabPanelLpm.this.tuneStepModel.getRowCount()) {
                    return result.getStepFields().get(col - this.columnNames.length - JTabPanelLpm.this.tuneStepModel.getRowCount());
                }
                return "";
            }
            return "error";
        }
    }

    public class LpmTuneStepTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1432038909521987705L;
        private String[] columnNames = new String[]{"Order", "Command", "Start", "Stop", "Step", "RTime"};
        private List<LpmTuneStep> data = new ArrayList<LpmTuneStep>(100);

        public void fireDataReorder() {
            Collections.sort(this.data, new Comparator<LpmTuneStep>(){

                @Override
                public int compare(LpmTuneStep o1, LpmTuneStep o2) {
                    return new Integer(o1.getOrder()).compareTo(o2.getOrder());
                }
            });
            this.fireTableDataChanged();
        }

        public LpmTuneStep dataGet(int row) {
            if (row < this.data.size()) {
                return this.data.get(row);
            }
            return null;
        }

        public void dataAdd(LpmTuneStep step) {
            this.data.add(step);
            this.fireDataReorder();
        }

        public void dataRemove(int row) {
            if (row < this.data.size()) {
                this.data.remove(row);
                this.fireTableDataChanged();
            }
        }

        public boolean dataContains(LpmTuneStep step) {
            return this.data.contains(step);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            LpmTuneStep step = this.data.get(row);
            switch (col) {
                default: {
                    return step.getOrder();
                }
                case 1: {
                    if (step.getCommandName().isIndexedA()) {
                        String idx = "" + step.getCommandIndex();
                        if (idx.length() == 1) {
                            idx = "0" + idx;
                        }
                        return step.getCommandName().name() + idx;
                    }
                    return step.getCommandName().name();
                }
                case 2: {
                    return step.getValueStart();
                }
                case 3: {
                    return step.getValueStop();
                }
                case 4: {
                    return step.getValueStep();
                }
                case 5: 
            }
            return step.getRecoveryTime();
        }
    }

    public class LpmTuneResult {
        private Date date = null;
        private String lpmTime = null;
        private String lpmResult = null;
        private String mmwResult = null;
        private List<String> stepData = new ArrayList<String>(10);
        private List<String> stepFields = new ArrayList<String>(10);

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public String getLpmTime() {
            return this.lpmTime;
        }

        public void setLpmTime(String lpmTime) {
            this.lpmTime = lpmTime;
        }

        public String getLpmResult() {
            return this.lpmResult;
        }

        public void setLpmResult(String lpmResult) {
            this.lpmResult = lpmResult;
        }

        public String getMmwResult() {
            return this.mmwResult;
        }

        public void setMmwResult(String mmwResult) {
            this.mmwResult = mmwResult;
        }

        public List<String> getStepData() {
            return this.stepData;
        }

        public List<String> getStepFields() {
            return this.stepFields;
        }
    }

    public class LpmTuneStep {
        private int order = 1;
        private CommandName commandName = null;
        private int commandIndex = 0;
        private int valueStart = 0;
        private int valueStop = 10;
        private int valueStep = 1;
        private int valueCurrent = 0;
        private int recoveryTime = 10;

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public CommandName getCommandName() {
            return this.commandName;
        }

        public void setCommandName(CommandName commandName) {
            this.commandName = commandName;
        }

        public int getCommandIndex() {
            return this.commandIndex;
        }

        public void setCommandIndex(int commandIndex) {
            this.commandIndex = commandIndex;
        }

        public int getValueStart() {
            return this.valueStart;
        }

        public void setValueStart(int valueStart) {
            this.valueStart = valueStart;
        }

        public int getValueStop() {
            return this.valueStop;
        }

        public void setValueStop(int valueStop) {
            this.valueStop = valueStop;
        }

        public int getValueStep() {
            return this.valueStep;
        }

        public void setValueStep(int valueStep) {
            this.valueStep = valueStep;
        }

        public int getValueCurrent() {
            return this.valueCurrent;
        }

        public void setValueCurrent(int valueCurrent) {
            this.valueCurrent = valueCurrent;
        }

        public int getRecoveryTime() {
            return this.recoveryTime;
        }

        public void setRecoveryTime(int recoveryTime) {
            this.recoveryTime = recoveryTime;
        }
    }
}

