/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class PatternLogFormatter
extends Formatter {
    private final String lineSeperator;
    private final MessageFormat logFormat;
    private final MessageFormat logErrorFormat;
    private final DateFormat dateFormat;
    private static final String DEFAULT_LOG_FORMAT = "%d %l [%C.%s] %m%r";
    private static final String DEFAULT_LOG_ERROR_FORMAT = "%d %l [%C.%s] %m%r%S";
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String[] LOG_OPTIONS = new String[]{"%d", "%l", "%n", "%m", "%t", "%s", "%c", "%C", "%S", "%r"};

    public PatternLogFormatter() {
        int i;
        String logFormatStr = LogManager.getLogManager().getProperty(this.getClass().getName() + ".log_pattern");
        String logFormatErrorStr = LogManager.getLogManager().getProperty(this.getClass().getName() + ".log_error_pattern");
        String logDateStr = LogManager.getLogManager().getProperty(this.getClass().getName() + ".date_pattern");
        this.dateFormat = logDateStr != null && !logDateStr.isEmpty() ? new SimpleDateFormat(logDateStr) : new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        if (logFormatStr == null || logFormatStr.isEmpty()) {
            logFormatStr = DEFAULT_LOG_FORMAT;
        }
        if (logFormatStr.contains("{") || logFormatStr.contains("}")) {
            throw new IllegalArgumentException("Curly braces not allowed in log pattern.");
        }
        for (i = 0; i < LOG_OPTIONS.length; ++i) {
            logFormatStr = logFormatStr.replace(LOG_OPTIONS[i], "{" + i + "}");
        }
        this.logFormat = new MessageFormat(logFormatStr);
        if (logFormatErrorStr == null || logFormatErrorStr.isEmpty()) {
            logFormatErrorStr = DEFAULT_LOG_ERROR_FORMAT;
        }
        if (logFormatErrorStr.contains("{") || logFormatErrorStr.contains("}")) {
            throw new IllegalArgumentException("Curly braces not allowed in log pattern.");
        }
        for (i = 0; i < LOG_OPTIONS.length; ++i) {
            logFormatErrorStr = logFormatErrorStr.replace(LOG_OPTIONS[i], "{" + i + "}");
        }
        this.logErrorFormat = new MessageFormat(logFormatErrorStr);
        this.lineSeperator = String.format("%n", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord record) {
        String[] logFields = new String[10];
        logFields[1] = record.getLevel().toString();
        logFields[2] = record.getLoggerName();
        logFields[3] = record.getMessage();
        if ((logFields[3] == null || logFields[3].isEmpty()) && record.getThrown() != null) {
            logFields[3] = record.getThrown().getMessage();
        }
        logFields[4] = Integer.toString(record.getThreadID());
        logFields[5] = record.getSourceMethodName() != null ? record.getSourceMethodName() : "?";
        logFields[6] = record.getSourceClassName() != null ? record.getSourceClassName() : "?";
        int dotIdx = logFields[6].lastIndexOf(".") + 1;
        logFields[7] = dotIdx > 0 && dotIdx < logFields[6].length() ? logFields[6].substring(dotIdx) : logFields[6];
        logFields[8] = record.getThrown() != null ? this.createStackTrace(record.getThrown()) : "";
        logFields[9] = this.lineSeperator;
        MessageFormat messageFormat = this.logFormat;
        synchronized (messageFormat) {
            logFields[0] = this.dateFormat.format(new Date(record.getMillis()));
            if (record.getThrown() == null) {
                return this.logFormat.format(logFields);
            }
            return this.logErrorFormat.format(logFields);
        }
    }

    private String createStackTrace(Throwable t) {
        StringWriter buf = new StringWriter();
        t.printStackTrace(new PrintWriter(buf));
        return buf.getBuffer().toString();
    }
}

